/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.tasks.WorkResult;

public abstract class CustomFileSystemOperations
implements BuildService<BuildServiceParameters.None> {
    @Inject
    protected abstract FileSystemOperations getFs();

    public WorkResult copyPreservingTimestamps(CopySyncConfigurationCustomizer customizer) {
        CopySyncConfiguration config = new CopySyncConfiguration();
        customizer.customize(config);
        ArrayList<CopiedFileMetadata> copiedFilesMetadata = new ArrayList<CopiedFileMetadata>();
        WorkResult result = this.getFs().copy(copy -> CustomFileSystemOperations.configureCopyOrSyncOperation(copy, config, copiedFilesMetadata));
        CustomFileSystemOperations.restoreTimestamps(copiedFilesMetadata);
        return result;
    }

    public WorkResult syncPreservingTimestamps(CopySyncConfigurationCustomizer customizer) {
        CopySyncConfiguration config = new CopySyncConfiguration();
        customizer.customize(config);
        ArrayList<CopiedFileMetadata> copiedFilesMetadata = new ArrayList<CopiedFileMetadata>();
        WorkResult result = this.getFs().sync(sync -> CustomFileSystemOperations.configureCopyOrSyncOperation((CopySpec)sync, config, copiedFilesMetadata));
        CustomFileSystemOperations.restoreTimestamps(copiedFilesMetadata);
        return result;
    }

    public WorkResult delete(Action<? super DeleteSpec> action) {
        return this.getFs().delete(action);
    }

    public static void deleteFileIfExists(Path file) {
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            throw new GradleException("Failed to delete file: " + String.valueOf(file), (Throwable)e);
        }
    }

    private static void configureCopyOrSyncOperation(CopySpec copy, CopySyncConfiguration config, List<CopiedFileMetadata> copiedFilesMetadata) {
        for (Path src : config.sources) {
            copy.from((Object)src, spec -> spec.eachFile((Action)new TimestampPreservingCopyAction(src, config.destination, copiedFilesMetadata)));
        }
        copy.into((Object)config.destination);
        if (!config.includes.isEmpty()) {
            copy.include(config.includes);
        }
        if (!config.excludes.isEmpty()) {
            copy.exclude(config.excludes);
        }
    }

    private static void restoreTimestamps(List<CopiedFileMetadata> copiedFilesMetadata) {
        for (CopiedFileMetadata m : copiedFilesMetadata) {
            try {
                Files.setLastModifiedTime(m.destination(), m.sourceMtime());
            }
            catch (IOException e) {
                throw new GradleException("Failed to restore the timestamp of the file: " + String.valueOf(m.destination()), (Throwable)e);
            }
        }
    }

    public static class CopySyncConfiguration {
        List<Path> sources = new ArrayList<Path>();
        Path destination;
        List<String> includes = new ArrayList<String>();
        List<String> excludes = new ArrayList<String>();

        public CopySyncConfiguration into(Path destination) {
            this.destination = destination;
            return this;
        }

        public CopySyncConfiguration into(File destination) {
            this.destination = destination.toPath();
            return this;
        }

        public CopySyncConfiguration from(Path ... sources) {
            this.sources.addAll(List.of(sources));
            return this;
        }

        public CopySyncConfiguration include(String ... includes) {
            this.includes.addAll(List.of(includes));
            return this;
        }

        public CopySyncConfiguration exclude(String ... excludes) {
            this.excludes.addAll(List.of(excludes));
            return this;
        }
    }

    public static interface CopySyncConfigurationCustomizer {
        public void customize(CopySyncConfiguration var1);
    }

    private record CopiedFileMetadata(Path source, Path destination, FileTime sourceMtime) {
    }

    private static final class TimestampPreservingCopyAction
    implements Action<FileCopyDetails> {
        private final Path srcDir;
        private final Path destDir;
        private final List<CopiedFileMetadata> processedFiles;

        public TimestampPreservingCopyAction(Path srcDir, Path destDir, List<CopiedFileMetadata> processedFiles) {
            this.srcDir = srcDir;
            this.destDir = destDir;
            this.processedFiles = processedFiles;
        }

        public void execute(FileCopyDetails details) {
            FileTime sourceMtime;
            Path sourceFile = this.srcDir.resolve(details.getSourcePath());
            try {
                sourceMtime = Files.getLastModifiedTime(sourceFile, new LinkOption[0]);
            }
            catch (IOException e) {
                throw new GradleException("Failed to get source file mtime for " + details.getSourcePath(), (Throwable)e);
            }
            Path destFile = this.destDir.resolve(details.getPath());
            if (Files.exists(destFile, new LinkOption[0]) && !Files.isWritable(destFile)) {
                CustomFileSystemOperations.deleteFileIfExists(destFile);
            }
            this.processedFiles.add(new CopiedFileMetadata(sourceFile, destFile, sourceMtime));
        }
    }
}

