/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.gradle.tasks.AbstractQuarkusExtension;
import io.quarkus.gradle.tasks.EffectiveConfig;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;

public class EffectiveConfigProvider {
    final ListProperty<String> ignoredEntries;
    final ConfigurableFileCollection mainResources;
    final MapProperty<String, String> forcedProperties;
    final MapProperty<String, Object> projectProperties;
    final MapProperty<String, String> quarkusBuildProperties;
    final MapProperty<String, Object> manifestAttributes;
    final MapProperty<String, Attributes> manifestSections;
    final Property<Boolean> nativeBuild;
    final Property<String> quarkusProfileSystemVariable;
    final Property<String> quarkusProfileEnvVariable;

    public EffectiveConfigProvider(ListProperty<String> ignoredEntries, ConfigurableFileCollection mainResources, MapProperty<String, String> forcedProperties, MapProperty<String, Object> projectProperties, MapProperty<String, String> quarkusBuildProperties, MapProperty<String, Object> manifestAttributes, MapProperty<String, Attributes> manifestSections, Property<Boolean> nativeBuild, Property<String> quarkusProfileSystemVariable, Property<String> quarkusProfileEnvVariable) {
        this.ignoredEntries = ignoredEntries;
        this.mainResources = mainResources;
        this.forcedProperties = forcedProperties;
        this.projectProperties = projectProperties;
        this.quarkusBuildProperties = quarkusBuildProperties;
        this.manifestAttributes = manifestAttributes;
        this.manifestSections = manifestSections;
        this.nativeBuild = nativeBuild;
        this.quarkusProfileSystemVariable = quarkusProfileSystemVariable;
        this.quarkusProfileEnvVariable = quarkusProfileEnvVariable;
    }

    public EffectiveConfig buildEffectiveConfiguration(ApplicationModel appModel, Map<String, ?> additionalForcedProperties) {
        ResolvedDependency appArtifact = appModel.getAppArtifact();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.exportCustomManifestProperties(properties);
        HashMap<String, String> defaultProperties = new HashMap<String, String>();
        String userIgnoredEntries = String.join((CharSequence)",", (Iterable)this.ignoredEntries.get());
        if (!userIgnoredEntries.isEmpty()) {
            defaultProperties.put("quarkus.package.jar.user-configured-ignored-entries", userIgnoredEntries);
        }
        Set resourcesDirs = this.mainResources.getFiles();
        defaultProperties.putIfAbsent("quarkus.application.name", appArtifact.getArtifactId());
        defaultProperties.putIfAbsent("quarkus.application.version", appArtifact.getVersion());
        HashMap<String, String> forced = new HashMap<String, String>((Map)this.forcedProperties.get());
        additionalForcedProperties.forEach((k, v) -> forced.put((String)k, v.toString()));
        if (((Boolean)this.nativeBuild.get()).booleanValue()) {
            forced.put("quarkus.native.enabled", "true");
        }
        return EffectiveConfig.builder().withPlatformProperties(appModel.getPlatformProperties()).withForcedProperties(forced).withTaskProperties(properties).withBuildProperties((Map)this.quarkusBuildProperties.get()).withProjectProperties((Map)this.projectProperties.get()).withDefaultProperties(defaultProperties).withSourceDirectories(resourcesDirs).withProfile(this.getQuarkusProfile()).build();
    }

    private void exportCustomManifestProperties(Map<String, Object> properties) {
        for (Map.Entry attribute : ((Map)this.manifestAttributes.get()).entrySet()) {
            properties.put(AbstractQuarkusExtension.toManifestAttributeKey((String)attribute.getKey()), attribute.getValue());
        }
        for (Map.Entry section : ((Map)this.manifestSections.get()).entrySet()) {
            for (Map.Entry attribute : ((Attributes)section.getValue()).entrySet()) {
                properties.put(AbstractQuarkusExtension.toManifestSectionAttributeKey((String)section.getKey(), (String)attribute.getKey()), attribute.getValue());
            }
        }
    }

    private String getQuarkusProfile() {
        Object p;
        String profile = (String)this.quarkusProfileSystemVariable.getOrNull();
        if (profile == null) {
            profile = (String)this.quarkusProfileEnvVariable.getOrNull();
        }
        if (profile == null) {
            profile = (String)((Map)this.quarkusBuildProperties.get()).get("quarkus.profile");
        }
        if (profile == null && (p = ((Map)this.projectProperties.get()).get("quarkus.profile")) != null) {
            profile = p.toString();
        }
        if (profile == null) {
            profile = "prod";
        }
        return profile;
    }
}

