/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.actions;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.gradle.extension.QuarkusPluginExtension;
import io.quarkus.gradle.tasks.EffectiveConfigProvider;
import io.quarkus.gradle.tasks.QuarkusPluginExtensionView;
import io.quarkus.gradle.tooling.ToolingUtils;
import io.quarkus.runtime.LaunchMode;
import io.smallrye.config.SmallRyeConfig;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.testing.Test;

public class BeforeTestAction
implements Action<Task> {
    private final File projectDir;
    private final FileCollection combinedOutputSourceDirs;
    private final Provider<RegularFile> applicationModelPath;
    private final Provider<File> nativeRunnerPath;
    private final FileCollection mainSourceSetClassesDir;
    private final QuarkusPluginExtensionView extensionView;
    private final MapProperty<String, Object> manifestAttributes;
    private final MapProperty<String, Attributes> manifestSections;

    public BeforeTestAction(File projectDir, FileCollection combinedOutputSourceDirs, Provider<RegularFile> applicationModelPath, Provider<File> nativeRunnerPath, FileCollection mainSourceSetClassesDir, QuarkusPluginExtensionView extensionView, MapProperty<String, Object> manifestAttributes, MapProperty<String, Attributes> manifestSections) {
        this.projectDir = projectDir;
        this.combinedOutputSourceDirs = combinedOutputSourceDirs;
        this.applicationModelPath = applicationModelPath;
        this.nativeRunnerPath = nativeRunnerPath;
        this.mainSourceSetClassesDir = mainSourceSetClassesDir;
        this.extensionView = extensionView;
        this.manifestAttributes = manifestAttributes;
        this.manifestSections = manifestSections;
    }

    public void execute(Task t) {
        try {
            Test task = (Test)t;
            Map props = task.getSystemProperties();
            Path serializedModel = ((RegularFile)this.applicationModelPath.get()).getAsFile().toPath();
            ApplicationModel applicationModel = ToolingUtils.deserializeAppModel((Path)serializedModel);
            SmallRyeConfig config = this.effectiveProvider().buildEffectiveConfiguration(applicationModel, new HashMap()).getConfig();
            config.getOptionalValue(LaunchMode.TEST.getProfileKey(), String.class).ifPresent(value -> props.put(LaunchMode.TEST.getProfileKey(), value));
            props.put("quarkus-internal-test.serialized-app-model.path", serializedModel.toString());
            StringJoiner outputSourcesDir = new StringJoiner(",");
            for (File outputSourceDir : this.combinedOutputSourceDirs.getFiles()) {
                outputSourcesDir.add(outputSourceDir.getAbsolutePath());
            }
            props.put("OUTPUT_SOURCES_DIR", outputSourcesDir.toString());
            File outputDirectoryAsFile = QuarkusPluginExtension.getLastFile(this.mainSourceSetClassesDir);
            Path projectDirPath = this.projectDir.toPath();
            String fileList = task.getTestClassesDirs().getFiles().stream().filter(File::exists).distinct().map(testSrcDir -> String.format("%s:%s", projectDirPath.relativize(testSrcDir.toPath()), projectDirPath.relativize(outputDirectoryAsFile.toPath()))).collect(Collectors.joining(","));
            task.environment("TEST_TO_MAIN_MAPPINGS", (Object)fileList);
            task.getLogger().debug("test dir mapping - {}", (Object)fileList);
            String nativeRunner = ((File)this.nativeRunnerPath.get()).toPath().toAbsolutePath().toString();
            props.put("native.image.path", nativeRunner);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to resolve deployment classpath", e);
        }
    }

    private EffectiveConfigProvider effectiveProvider() {
        return new EffectiveConfigProvider(this.extensionView.getIgnoredEntries(), this.extensionView.getMainResources(), this.extensionView.getForcedProperties(), this.extensionView.getProjectProperties(), this.extensionView.getQuarkusBuildProperties(), this.manifestAttributes, this.manifestSections, this.extensionView.getNativeBuild(), this.extensionView.getQuarkusProfileSystemVariable(), this.extensionView.getQuarkusProfileEnvVariable());
    }
}

