/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.attributes.Category;
import org.gradle.api.file.FileTree;

public class GradleUtils {
    private static final Pattern COMPOSE_FILE = Pattern.compile("(^docker-compose|^compose)(-dev(-)?service).*.(yml|yaml)");

    public static String getQuarkusCoreVersion(Project project) {
        List<Dependency> bomDeps = GradleUtils.listProjectBoms(project);
        if (bomDeps.isEmpty()) {
            throw new GradleException("No platforms detected in the project");
        }
        Configuration boms = project.getConfigurations().detachedConfiguration(bomDeps.toArray(new Dependency[0]));
        AtomicReference quarkusVersionRef = new AtomicReference();
        boms.getResolutionStrategy().eachDependency(d -> {
            if (quarkusVersionRef.get() == null && d.getTarget().getName().equals("quarkus-core") && d.getTarget().getGroup().equals("io.quarkus")) {
                quarkusVersionRef.set(d.getTarget().getVersion());
            }
        });
        boms.getResolvedConfiguration();
        String quarkusCoreVersion = (String)quarkusVersionRef.get();
        if (quarkusCoreVersion == null) {
            throw new IllegalStateException("Failed to determine the Quarkus core version for the project");
        }
        return quarkusCoreVersion;
    }

    public static List<Dependency> listProjectBoms(Project project) {
        Configuration impl = project.getConfigurations().getByName("implementation");
        ArrayList<Dependency> boms = new ArrayList<Dependency>();
        impl.getIncoming().getDependencies().forEach(d -> {
            if (!(d instanceof ModuleDependency)) {
                return;
            }
            ModuleDependency module = (ModuleDependency)d;
            Category category = (Category)module.getAttributes().getAttribute(Category.CATEGORY_ATTRIBUTE);
            if (category != null && ("enforced-platform".equals(category.getName()) || "platform".equals(category.getName()))) {
                boms.add((Dependency)d);
            }
        });
        return boms;
    }

    public static FileTree composeDevFiles(Project project) {
        return project.getLayout().getProjectDirectory().getAsFileTree().matching(p -> p.include(element -> COMPOSE_FILE.matcher(element.getName()).matches()));
    }
}

