/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.common.plugins.config;

import io.openliberty.tools.common.plugins.config.XmlDocument;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public class LooseConfigData
extends XmlDocument {
    private String projectRoot = null;
    private String sourceOnDiskName = null;

    public void setProjectRoot(String root) {
        this.projectRoot = root;
    }

    public void setSourceOnDiskName(String name) {
        this.sourceOnDiskName = name;
    }

    public LooseConfigData() throws ParserConfigurationException {
        this.createDocument("archive");
    }

    public void addDir(File src, String target) throws DOMException, IOException {
        if (src != null && src.exists() && src.isDirectory()) {
            this.addDir(this.doc.getDocumentElement(), src, target);
        }
    }

    public void addDir(Element parent, File src, String target) throws DOMException, IOException {
        if (src != null && src.exists() && src.isDirectory()) {
            Element child = this.doc.createElement("dir");
            this.addElement(parent, child, src, target);
        }
    }

    public void addFile(File src, String target) throws DOMException, IOException {
        if (src != null && src.exists() && src.isFile()) {
            this.addFile(this.doc.getDocumentElement(), src, target);
        }
    }

    public void addFile(Element parent, File src, String target) throws DOMException, IOException {
        this.addFile(parent, src, target, null);
    }

    public void addFile(Element parent, File src, String target, File copyDirectory) throws DOMException, IOException {
        if (src != null && src.exists() && src.isFile()) {
            Element child = this.doc.createElement("file");
            if (copyDirectory != null && copyDirectory.exists() && copyDirectory.isDirectory() && !src.getCanonicalPath().contains(copyDirectory.getCanonicalPath())) {
                File copyFileDirectory = new File(copyDirectory, Long.toString(System.nanoTime()));
                copyFileDirectory.mkdir();
                File copyFile = new File(copyFileDirectory, src.getName());
                FileUtils.copyFile((File)src, (File)copyFile);
                this.addElement(parent, child, copyFile, target);
            } else {
                this.addElement(parent, child, src, target);
            }
        }
    }

    public Element addArchive(String target) {
        return this.addArchive(this.doc.getDocumentElement(), target);
    }

    public Element addArchive(Element parent, String target) {
        Element child = this.doc.createElement("archive");
        this.addElement(parent, child, target);
        return child;
    }

    public void addArchive(File src, String target) throws DOMException, IOException {
        Element child = this.addArchive(target);
        this.addElement(child, this.doc.createElement("dir"), src, "/");
    }

    public void toXmlFile(File xmlFile) throws Exception {
        this.writeXMLDocument(xmlFile);
    }

    public Element getDocumentRoot() {
        return this.doc.getDocumentElement();
    }

    private void addElement(Element parent, Element child, File src, String target) throws DOMException, IOException {
        String name = src.getCanonicalPath();
        if (this.sourceOnDiskName != null && this.projectRoot != null && name.startsWith(this.projectRoot)) {
            child.setAttribute("sourceOnDisk", this.sourceOnDiskName + name.substring(this.projectRoot.length()));
        } else {
            child.setAttribute("sourceOnDisk", src.getCanonicalPath());
        }
        this.addElement(parent, child, target);
    }

    private void addElement(Element parent, Element child, String target) {
        child.setAttribute("targetInArchive", target);
        parent.appendChild(child);
    }
}

