/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.common.arquillian.objects;

import io.openliberty.tools.common.arquillian.objects.LibertyProperty;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class LibertyRemoteObject {
    private static final String XML_START = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<arquillian xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xmlns=\"http://jboss.org/schema/arquillian\"\n    xsi:schemaLocation=\"http://jboss.org/schema/arquillian http://jboss.org/schema/arquillian/arquillian_1_0.xsd\">\n    <container qualifier=\"liberty_remote\" default=\"true\">\n        <configuration>\n";
    private static final String XML_END = "        </configuration>\n    </container>\n</arquillian>\n";
    private final Map<LibertyProperty.LibertyPropertyI, String> arquillianProperties;

    public LibertyRemoteObject(Map<LibertyProperty.LibertyPropertyI, String> arquillianProperties) {
        this.arquillianProperties = arquillianProperties;
    }

    public Map<LibertyProperty.LibertyPropertyI, String> getArquillianProperties() {
        return this.arquillianProperties;
    }

    public void build(File arquillianXml) throws IOException {
        StringBuilder xml = new StringBuilder(XML_START);
        for (Map.Entry<LibertyProperty.LibertyPropertyI, String> e : this.arquillianProperties.entrySet()) {
            LibertyRemoteProperty property = (LibertyRemoteProperty)e.getKey();
            String key = property.name();
            xml.append("            <property name=\"").append(key).append("\">").append(e.getValue()).append("</property>\n");
        }
        xml.append(XML_END);
        xml.append("<!-- This file was generated by the Liberty build plugin. -->");
        LibertyProperty.write(xml, arquillianXml);
    }

    public static enum LibertyRemoteProperty implements LibertyProperty.LibertyPropertyI
    {
        serverName,
        serverStartTimeout,
        appDeployTimeout,
        appUndeployTimeout,
        username,
        password,
        hostName,
        httpPort,
        httpsPort,
        outputToConsole;

    }
}

