/*
 * Decompiled with CFR 0.152.
 */
package io.openapitools.swagger.config;

import io.openapitools.swagger.config.SwaggerComponents;
import io.openapitools.swagger.config.SwaggerExternalDoc;
import io.openapitools.swagger.config.SwaggerInfo;
import io.openapitools.swagger.config.SwaggerSecurityRequirement;
import io.openapitools.swagger.config.SwaggerServer;
import io.openapitools.swagger.config.SwaggerTag;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.Parameter;

public class SwaggerConfig {
    @Parameter
    private SwaggerInfo info;
    @Parameter
    private File descriptionFile;
    @Parameter
    private List<SwaggerServer> servers = Collections.emptyList();
    @Parameter
    private SwaggerComponents components;
    @Parameter
    private List<SwaggerSecurityRequirement> securityRequirements = Collections.emptyList();
    @Parameter
    private List<SwaggerTag> tags = Collections.emptyList();
    @Parameter
    private SwaggerExternalDoc externalDoc;
    @Parameter
    private Map<String, Object> extensions = Collections.emptyMap();

    public OpenAPI createSwaggerModel() {
        OpenAPI spec = new OpenAPI();
        if (this.info != null) {
            spec.setInfo(this.info.createInfoModel());
        }
        if (this.descriptionFile != null) {
            if (spec.getInfo() == null) {
                spec.setInfo(new Info());
            }
            try {
                spec.getInfo().setDescription(Files.readAllLines(this.descriptionFile.toPath()).stream().collect(Collectors.joining("\n")));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read descriptor file " + this.descriptionFile, e);
            }
        }
        if (this.components != null) {
            spec.setComponents(this.components.createComponentsModel());
        }
        if (this.externalDoc != null) {
            spec.setExternalDocs(this.externalDoc.createExternalDocModel());
        }
        spec.setExtensions(this.extensions);
        this.servers.forEach(s -> spec.addServersItem(s.createServerModel()));
        this.securityRequirements.forEach(s -> spec.addSecurityItem(s.createSecurityModel()));
        this.tags.forEach(t -> spec.addTagsItem(t.createTagModel()));
        return spec;
    }
}

