/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.maven;

import io.openapiprocessor.maven.Nested;
import io.openapiprocessor.maven.Options;
import io.openapiprocessor.maven.ProcessorRunner;
import io.openapiprocessor.maven.UpToDateCheck;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="process", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class ProcessMojo
extends AbstractMojo {
    public static final String API_PATH = "apiPath";
    public static final String TARGET_DIR = "targetDir";
    @Parameter(required=true)
    private String id;
    @Parameter(required=false)
    private File apiPath;
    @Parameter(required=false)
    private Options options;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Map<String, Object> properties = this.createProperties();
            File sourceRoot = this.apiPath.getParentFile();
            File targetRoot = new File((String)properties.get(TARGET_DIR));
            UpToDateCheck upToDateCheck = new UpToDateCheck();
            boolean upToDate = upToDateCheck.isUpToDate(sourceRoot, targetRoot);
            if (!upToDate) {
                this.getLog().info((CharSequence)"Changes detected - generating target files!");
                new ProcessorRunner(this.id, properties).run();
            } else {
                this.getLog().info((CharSequence)"Nothing to process - all generated target files are up to date.");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("openapi-processor-" + this.id + " execution failed!", e);
        }
    }

    private Map<String, Object> createProperties() throws MojoExecutionException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.addProperties(this.options, properties);
        this.setApiPath(properties);
        return properties;
    }

    private void addProperties(Options options, Map<String, Object> target) {
        if (options == null) {
            return;
        }
        Map<String, Object> source = options.getValues();
        if (source == null) {
            return;
        }
        target.putAll(source);
        this.addNestedProperties(options.getNested(), target);
    }

    private void addNestedProperties(Nested nested, Map<String, Object> parent) {
        if (nested == null) {
            return;
        }
        Map<String, Object> source = nested.getValues();
        if (source == null) {
            return;
        }
        HashMap<String, Object> target = new HashMap<String, Object>(source);
        parent.put(nested.getName(), target);
        this.addNestedProperties(nested.getNested(), target);
    }

    private void setApiPath(Map<String, Object> properties) throws MojoExecutionException {
        if (!properties.containsKey(API_PATH)) {
            if (this.apiPath == null) {
                throw new MojoExecutionException((Object)this, "'common <apiPath>' or '" + this.id + " <apiPath>' not set!", "'common <apiPath>' or '" + this.id + " <apiPath>' not set!");
            }
            properties.put(API_PATH, this.apiPath);
        } else {
            this.apiPath = new File((String)properties.get(API_PATH));
        }
    }
}

