/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.stomp.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.stomp.LastStompContentSubframe;
import io.netty.handler.codec.stomp.StompFrame;
import io.netty.handler.codec.stomp.StompHeadersSubframe;
import io.netty.handler.codec.stomp.StompSubframe;
import io.netty.handler.codec.stomp.StompSubframeEncoder;
import java.util.List;

public class StompWebSocketFrameEncoder
extends StompSubframeEncoder {
    public void encode(ChannelHandlerContext ctx, StompSubframe msg, List<Object> out) throws Exception {
        Object webSocketFrame;
        super.encode(ctx, msg, out);
        if (out.isEmpty()) {
            return;
        }
        if (msg instanceof StompFrame) {
            if (out.size() == 1) {
                webSocketFrame = new TextWebSocketFrame(StompWebSocketFrameEncoder.getFirst(out));
            } else {
                CompositeByteBuf content = ctx.alloc().compositeBuffer(out.size());
                for (Object byteBuf : out) {
                    content.addComponent(true, (ByteBuf)byteBuf);
                }
                webSocketFrame = new TextWebSocketFrame((ByteBuf)content);
            }
        } else {
            webSocketFrame = msg instanceof StompHeadersSubframe ? new TextWebSocketFrame(false, 0, StompWebSocketFrameEncoder.getFirst(out)) : (msg instanceof LastStompContentSubframe ? new ContinuationWebSocketFrame(true, 0, StompWebSocketFrameEncoder.getFirst(out)) : new ContinuationWebSocketFrame(false, 0, StompWebSocketFrameEncoder.getFirst(out)));
        }
        out.clear();
        out.add(webSocketFrame);
    }

    private static ByteBuf getFirst(List<Object> container) {
        return (ByteBuf)container.get(0);
    }
}

