/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2.internal.hpack;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.internal.hpack.HpackUtil;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.ThrowableUtil;
import java.io.IOException;

final class HuffmanDecoder {
    private static final IOException EOS_DECODED = (IOException)ThrowableUtil.unknownStackTrace((Throwable)new IOException("HPACK - EOS Decoded"), HuffmanDecoder.class, (String)"decode(...)");
    private static final IOException INVALID_PADDING = (IOException)ThrowableUtil.unknownStackTrace((Throwable)new IOException("HPACK - Invalid Padding"), HuffmanDecoder.class, (String)"decode(...)");
    private static final Node ROOT = HuffmanDecoder.buildTree(HpackUtil.HUFFMAN_CODES, HpackUtil.HUFFMAN_CODE_LENGTHS);
    private final DecoderProcessor processor;

    HuffmanDecoder(int initialCapacity) {
        this.processor = new DecoderProcessor(initialCapacity);
    }

    public AsciiString decode(ByteBuf buf, int length) throws IOException {
        this.processor.reset();
        buf.forEachByte(buf.readerIndex(), length, (ByteProcessor)this.processor);
        buf.skipBytes(length);
        return this.processor.end();
    }

    private static Node buildTree(int[] codes, byte[] lengths) {
        Node root = new Node();
        for (int i = 0; i < codes.length; ++i) {
            HuffmanDecoder.insert(root, i, codes[i], lengths[i]);
        }
        return root;
    }

    private static void insert(Node root, int symbol, int code, byte length) {
        Node current = root;
        while (length > 8) {
            if (current.isTerminal()) {
                throw new IllegalStateException("invalid Huffman code: prefix not unique");
            }
            length = (byte)(length - 8);
            int i = code >>> length & 0xFF;
            if (current.children[i] == null) {
                ((Node)current).children[i] = new Node();
            }
            current = current.children[i];
        }
        Node terminal = new Node(symbol, length);
        int shift = 8 - length;
        int start = code << shift & 0xFF;
        int end = 1 << shift;
        for (int i = start; i < start + end; ++i) {
            ((Node)current).children[i] = terminal;
        }
    }

    private static final class DecoderProcessor
    implements ByteProcessor {
        private final int initialCapacity;
        private byte[] bytes;
        private int index;
        private Node node;
        private int current;
        private int currentBits;
        private int symbolBits;

        DecoderProcessor(int initialCapacity) {
            this.initialCapacity = ObjectUtil.checkPositive((int)initialCapacity, (String)"initialCapacity");
        }

        void reset() {
            this.node = ROOT;
            this.current = 0;
            this.currentBits = 0;
            this.symbolBits = 0;
            this.bytes = new byte[this.initialCapacity];
            this.index = 0;
        }

        public boolean process(byte value) throws IOException {
            this.current = this.current << 8 | value & 0xFF;
            this.currentBits += 8;
            this.symbolBits += 8;
            do {
                this.node = this.node.children[this.current >>> this.currentBits - 8 & 0xFF];
                this.currentBits -= this.node.bits;
                if (!this.node.isTerminal()) continue;
                if (this.node.symbol == 256) {
                    throw EOS_DECODED;
                }
                this.append(this.node.symbol);
                this.node = ROOT;
                this.symbolBits = this.currentBits;
            } while (this.currentBits >= 8);
            return true;
        }

        AsciiString end() throws IOException {
            while (this.currentBits > 0) {
                this.node = this.node.children[this.current << 8 - this.currentBits & 0xFF];
                if (!this.node.isTerminal() || this.node.bits > this.currentBits) break;
                if (this.node.symbol == 256) {
                    throw EOS_DECODED;
                }
                this.currentBits -= this.node.bits;
                this.append(this.node.symbol);
                this.node = ROOT;
                this.symbolBits = this.currentBits;
            }
            int mask = (1 << this.symbolBits) - 1;
            if (this.symbolBits > 7 || (this.current & mask) != mask) {
                throw INVALID_PADDING;
            }
            return new AsciiString(this.bytes, 0, this.index, false);
        }

        private void append(int i) {
            try {
                this.bytes[this.index] = (byte)i;
            }
            catch (IndexOutOfBoundsException ignore) {
                byte[] newBytes = new byte[this.bytes.length + this.initialCapacity];
                System.arraycopy(this.bytes, 0, newBytes, 0, this.bytes.length);
                this.bytes = newBytes;
                this.bytes[this.index] = (byte)i;
            }
            ++this.index;
        }
    }

    private static final class Node {
        private final int symbol;
        private final int bits;
        private final Node[] children;

        Node() {
            this.symbol = 0;
            this.bits = 8;
            this.children = new Node[256];
        }

        Node(int symbol, int bits) {
            assert (bits > 0 && bits <= 8);
            this.symbol = symbol;
            this.bits = bits;
            this.children = null;
        }

        private boolean isTerminal() {
            return this.children == null;
        }
    }
}

