/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.HpackEncoder;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.Http2Settings;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class DefaultHttp2FrameReaderTest {
    @Mock
    private Http2FrameListener listener;
    @Mock
    private ChannelHandlerContext ctx;
    private DefaultHttp2FrameReader frameReader;
    private HpackEncoder hpackEncoder;

    @BeforeEach
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.ctx.alloc()).thenReturn((Object)UnpooledByteBufAllocator.DEFAULT);
        this.frameReader = new DefaultHttp2FrameReader();
        this.hpackEncoder = new HpackEncoder();
    }

    @AfterEach
    public void tearDown() {
        this.frameReader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readHeaderFrame() throws Http2Exception {
        boolean streamId = true;
        ByteBuf input = Unpooled.buffer();
        try {
            Http2Headers headers = new DefaultHttp2Headers().authority((CharSequence)"foo").method((CharSequence)"get").path((CharSequence)"/").scheme((CharSequence)"https");
            Http2Flags flags = new Http2Flags().endOfHeaders(true).endOfStream(true);
            this.writeHeaderFrame(input, 1, headers, flags);
            this.frameReader.readFrame(this.ctx, input, this.listener);
            ((Http2FrameListener)Mockito.verify((Object)this.listener)).onHeadersRead(this.ctx, 1, headers, 0, true);
        }
        finally {
            input.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readHeaderFrameAndContinuationFrame() throws Http2Exception {
        boolean streamId = true;
        ByteBuf input = Unpooled.buffer();
        try {
            Http2Headers headers = new DefaultHttp2Headers().authority((CharSequence)"foo").method((CharSequence)"get").path((CharSequence)"/").scheme((CharSequence)"https");
            this.writeHeaderFrame(input, 1, headers, new Http2Flags().endOfHeaders(false).endOfStream(true));
            this.writeContinuationFrame(input, 1, (Http2Headers)new DefaultHttp2Headers().add((Object)"foo", (Object)"bar"), new Http2Flags().endOfHeaders(true));
            this.frameReader.readFrame(this.ctx, input, this.listener);
            ((Http2FrameListener)Mockito.verify((Object)this.listener)).onHeadersRead(this.ctx, 1, (Http2Headers)headers.add((Object)"foo", (Object)"bar"), 0, true);
        }
        finally {
            input.release();
        }
    }

    @Test
    public void readUnknownFrame() throws Http2Exception {
        ByteBuf input = Unpooled.buffer();
        ByteBuf payload = Unpooled.buffer();
        try {
            payload.writeByte(1);
            Http2CodecUtil.writeFrameHeader((ByteBuf)input, (int)payload.readableBytes(), (byte)-1, (Http2Flags)new Http2Flags(), (int)0);
            input.writeBytes(payload);
            this.frameReader.readFrame(this.ctx, input, this.listener);
            ((Http2FrameListener)Mockito.verify((Object)this.listener)).onUnknownFrame(this.ctx, (byte)-1, 0, new Http2Flags(), payload.slice(0, 1));
        }
        finally {
            payload.release();
            input.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void failedWhenUnknownFrameInMiddleOfHeaderBlock() throws Http2Exception {
        boolean streamId = true;
        final ByteBuf input = Unpooled.buffer();
        try {
            Http2Headers headers = new DefaultHttp2Headers().authority((CharSequence)"foo").method((CharSequence)"get").path((CharSequence)"/").scheme((CharSequence)"https");
            Http2Flags flags = new Http2Flags().endOfHeaders(false).endOfStream(true);
            this.writeHeaderFrame(input, 1, headers, flags);
            Http2CodecUtil.writeFrameHeader((ByteBuf)input, (int)0, (byte)-1, (Http2Flags)new Http2Flags(), (int)1);
            Http2Exception ex = (Http2Exception)Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    DefaultHttp2FrameReaderTest.this.frameReader.readFrame(DefaultHttp2FrameReaderTest.this.ctx, input, DefaultHttp2FrameReaderTest.this.listener);
                }
            });
            Assertions.assertFalse((boolean)(ex instanceof Http2Exception.StreamException));
        }
        finally {
            input.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void failedWhenContinuationFrameStreamIdMismatch() throws Http2Exception {
        final ByteBuf input = Unpooled.buffer();
        try {
            Http2Headers headers = new DefaultHttp2Headers().authority((CharSequence)"foo").method((CharSequence)"get").path((CharSequence)"/").scheme((CharSequence)"https");
            this.writeHeaderFrame(input, 1, headers, new Http2Flags().endOfHeaders(false).endOfStream(true));
            this.writeContinuationFrame(input, 3, (Http2Headers)new DefaultHttp2Headers().add((Object)"foo", (Object)"bar"), new Http2Flags().endOfHeaders(true));
            Http2Exception ex = (Http2Exception)Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    DefaultHttp2FrameReaderTest.this.frameReader.readFrame(DefaultHttp2FrameReaderTest.this.ctx, input, DefaultHttp2FrameReaderTest.this.listener);
                }
            });
            Assertions.assertFalse((boolean)(ex instanceof Http2Exception.StreamException));
        }
        finally {
            input.release();
        }
    }

    @Test
    public void failedWhenContinuationFrameNotFollowHeaderFrame() throws Http2Exception {
        final ByteBuf input = Unpooled.buffer();
        try {
            this.writeContinuationFrame(input, 1, (Http2Headers)new DefaultHttp2Headers().add((Object)"foo", (Object)"bar"), new Http2Flags().endOfHeaders(true));
            Http2Exception ex = (Http2Exception)Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    DefaultHttp2FrameReaderTest.this.frameReader.readFrame(DefaultHttp2FrameReaderTest.this.ctx, input, DefaultHttp2FrameReaderTest.this.listener);
                }
            });
            Assertions.assertFalse((boolean)(ex instanceof Http2Exception.StreamException));
        }
        finally {
            input.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void failedWhenHeaderFrameDependsOnItself() throws Http2Exception {
        final ByteBuf input = Unpooled.buffer();
        try {
            Http2Headers headers = new DefaultHttp2Headers().authority((CharSequence)"foo").method((CharSequence)"get").path((CharSequence)"/").scheme((CharSequence)"https");
            this.writeHeaderFramePriorityPresent(input, 1, headers, new Http2Flags().endOfHeaders(true).endOfStream(true).priorityPresent(true), 1, 10);
            Http2Exception ex = (Http2Exception)Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    DefaultHttp2FrameReaderTest.this.frameReader.readFrame(DefaultHttp2FrameReaderTest.this.ctx, input, DefaultHttp2FrameReaderTest.this.listener);
                }
            });
            Assertions.assertFalse((boolean)(ex instanceof Http2Exception.StreamException));
        }
        finally {
            input.release();
        }
    }

    @Test
    public void failedHeadersValidationThrowsConnectionError() throws Http2Exception {
        final ByteBuf input = Unpooled.buffer();
        try {
            Http2CodecUtil.writeFrameHeader((ByteBuf)input, (int)0, (byte)1, (Http2Flags)new Http2Flags().paddingPresent(true), (int)1);
            Http2Exception ex = (Http2Exception)Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    DefaultHttp2FrameReaderTest.this.frameReader.readFrame(DefaultHttp2FrameReaderTest.this.ctx, input, DefaultHttp2FrameReaderTest.this.listener);
                }
            });
            Assertions.assertFalse((boolean)(ex instanceof Http2Exception.StreamException));
            Assertions.assertEquals((Object)Http2Error.FRAME_SIZE_ERROR, (Object)ex.error());
        }
        finally {
            input.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readHeaderAndData() throws Http2Exception {
        ByteBuf input = Unpooled.buffer();
        ByteBuf dataPayload = Unpooled.buffer();
        try {
            Http2Headers headers = new DefaultHttp2Headers().authority((CharSequence)"foo").method((CharSequence)"get").path((CharSequence)"/").scheme((CharSequence)"https");
            dataPayload.writeByte(1);
            this.writeHeaderFrameWithData(input, 1, headers, dataPayload);
            this.frameReader.readFrame(this.ctx, input, this.listener);
            ((Http2FrameListener)Mockito.verify((Object)this.listener)).onHeadersRead(this.ctx, 1, headers, 0, false);
            ((Http2FrameListener)Mockito.verify((Object)this.listener)).onDataRead(this.ctx, 1, dataPayload.slice(0, 1), 0, true);
        }
        finally {
            input.release();
            dataPayload.release();
        }
    }

    @Test
    public void failedWhenDataFrameNotAssociateWithStream() throws Http2Exception {
        final ByteBuf input = Unpooled.buffer();
        ByteBuf payload = Unpooled.buffer();
        try {
            payload.writeByte(1);
            Http2CodecUtil.writeFrameHeader((ByteBuf)input, (int)payload.readableBytes(), (byte)0, (Http2Flags)new Http2Flags().endOfStream(true), (int)0);
            input.writeBytes(payload);
            Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    DefaultHttp2FrameReaderTest.this.frameReader.readFrame(DefaultHttp2FrameReaderTest.this.ctx, input, DefaultHttp2FrameReaderTest.this.listener);
                }
            });
        }
        finally {
            payload.release();
            input.release();
        }
    }

    @Test
    public void readPriorityFrame() throws Http2Exception {
        ByteBuf input = Unpooled.buffer();
        try {
            DefaultHttp2FrameReaderTest.writePriorityFrame(input, 1, 0, 10);
            this.frameReader.readFrame(this.ctx, input, this.listener);
        }
        finally {
            input.release();
        }
    }

    @Test
    public void failedWhenPriorityFrameDependsOnItself() throws Http2Exception {
        final ByteBuf input = Unpooled.buffer();
        try {
            DefaultHttp2FrameReaderTest.writePriorityFrame(input, 1, 1, 10);
            Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    DefaultHttp2FrameReaderTest.this.frameReader.readFrame(DefaultHttp2FrameReaderTest.this.ctx, input, DefaultHttp2FrameReaderTest.this.listener);
                }
            });
        }
        finally {
            input.release();
        }
    }

    @Test
    public void failedWhenConnectionWindowUpdateFrameWithZeroDelta() throws Http2Exception {
        final ByteBuf input = Unpooled.buffer();
        try {
            Http2CodecUtil.writeFrameHeader((ByteBuf)input, (int)4, (byte)8, (Http2Flags)new Http2Flags(), (int)0);
            input.writeInt(0);
            Http2Exception ex = (Http2Exception)Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    DefaultHttp2FrameReaderTest.this.frameReader.readFrame(DefaultHttp2FrameReaderTest.this.ctx, input, DefaultHttp2FrameReaderTest.this.listener);
                }
            });
            Assertions.assertFalse((boolean)(ex instanceof Http2Exception.StreamException));
        }
        finally {
            input.release();
        }
    }

    @Test
    public void failedWhenStreamWindowUpdateFrameWithZeroDelta() throws Http2Exception {
        final ByteBuf input = Unpooled.buffer();
        try {
            Http2CodecUtil.writeFrameHeader((ByteBuf)input, (int)4, (byte)8, (Http2Flags)new Http2Flags(), (int)1);
            input.writeInt(0);
            Http2Exception ex = (Http2Exception)Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    DefaultHttp2FrameReaderTest.this.frameReader.readFrame(DefaultHttp2FrameReaderTest.this.ctx, input, DefaultHttp2FrameReaderTest.this.listener);
                }
            });
            Assertions.assertInstanceOf(Http2Exception.StreamException.class, (Object)((Object)ex));
        }
        finally {
            input.release();
        }
    }

    @Test
    public void readSettingsFrame() throws Http2Exception {
        ByteBuf input = Unpooled.buffer();
        try {
            Http2CodecUtil.writeFrameHeader((ByteBuf)input, (int)6, (byte)4, (Http2Flags)new Http2Flags(), (int)0);
            input.writeShort(6);
            input.writeInt(1024);
            this.frameReader.readFrame(this.ctx, input, this.listener);
            this.listener.onSettingsRead(this.ctx, new Http2Settings().maxHeaderListSize(1024L));
        }
        finally {
            input.release();
        }
    }

    @Test
    public void readAckSettingsFrame() throws Http2Exception {
        ByteBuf input = Unpooled.buffer();
        try {
            Http2CodecUtil.writeFrameHeader((ByteBuf)input, (int)0, (byte)4, (Http2Flags)new Http2Flags().ack(true), (int)0);
            this.frameReader.readFrame(this.ctx, input, this.listener);
            this.listener.onSettingsAckRead(this.ctx);
        }
        finally {
            input.release();
        }
    }

    @Test
    public void failedWhenSettingsFrameOnNonZeroStream() throws Http2Exception {
        final ByteBuf input = Unpooled.buffer();
        try {
            Http2CodecUtil.writeFrameHeader((ByteBuf)input, (int)6, (byte)4, (Http2Flags)new Http2Flags(), (int)1);
            input.writeShort(6);
            input.writeInt(1024);
            Http2Exception ex = (Http2Exception)Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    DefaultHttp2FrameReaderTest.this.frameReader.readFrame(DefaultHttp2FrameReaderTest.this.ctx, input, DefaultHttp2FrameReaderTest.this.listener);
                }
            });
            Assertions.assertFalse((boolean)(ex instanceof Http2Exception.StreamException));
        }
        finally {
            input.release();
        }
    }

    @Test
    public void failedWhenAckSettingsFrameWithPayload() throws Http2Exception {
        final ByteBuf input = Unpooled.buffer();
        try {
            Http2CodecUtil.writeFrameHeader((ByteBuf)input, (int)1, (byte)4, (Http2Flags)new Http2Flags().ack(true), (int)0);
            input.writeByte(1);
            Http2Exception ex = (Http2Exception)Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    DefaultHttp2FrameReaderTest.this.frameReader.readFrame(DefaultHttp2FrameReaderTest.this.ctx, input, DefaultHttp2FrameReaderTest.this.listener);
                }
            });
            Assertions.assertFalse((boolean)(ex instanceof Http2Exception.StreamException));
        }
        finally {
            input.release();
        }
    }

    @Test
    public void failedWhenSettingsFrameWithWrongPayloadLength() throws Http2Exception {
        final ByteBuf input = Unpooled.buffer();
        try {
            Http2CodecUtil.writeFrameHeader((ByteBuf)input, (int)8, (byte)4, (Http2Flags)new Http2Flags(), (int)0);
            input.writeInt(6);
            input.writeInt(1024);
            Http2Exception ex = (Http2Exception)Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    DefaultHttp2FrameReaderTest.this.frameReader.readFrame(DefaultHttp2FrameReaderTest.this.ctx, input, DefaultHttp2FrameReaderTest.this.listener);
                }
            });
            Assertions.assertFalse((boolean)(ex instanceof Http2Exception.StreamException));
        }
        finally {
            input.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void verifyValidRequestAfterMalformedPacketCausesStreamException() throws Http2Exception {
        final ByteBuf input = Unpooled.buffer();
        int priorityStreamId = 3;
        int headerStreamId = 5;
        try {
            Http2CodecUtil.writeFrameHeader((ByteBuf)input, (int)4, (byte)2, (Http2Flags)new Http2Flags(), (int)priorityStreamId);
            input.writeByte(-128);
            input.writeByte(0);
            input.writeByte(0);
            input.writeByte(127);
            Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    block2: {
                        try {
                            DefaultHttp2FrameReaderTest.this.frameReader.readFrame(DefaultHttp2FrameReaderTest.this.ctx, input, DefaultHttp2FrameReaderTest.this.listener);
                        }
                        catch (Exception e) {
                            if (!(e instanceof Http2Exception) || !Http2Exception.isStreamError((Http2Exception)((Http2Exception)((Object)e)))) break block2;
                            throw e;
                        }
                    }
                }
            });
            Http2Headers headers = new DefaultHttp2Headers().authority((CharSequence)"foo").method((CharSequence)"get").path((CharSequence)"/").scheme((CharSequence)"https");
            Http2Flags flags = new Http2Flags().endOfHeaders(true).endOfStream(true);
            this.writeHeaderFrame(input, headerStreamId, headers, flags);
            this.frameReader.readFrame(this.ctx, input, this.listener);
            ((Http2FrameListener)Mockito.verify((Object)this.listener)).onHeadersRead(this.ctx, 5, headers, 0, true);
        }
        finally {
            input.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeaderFrame(ByteBuf output, int streamId, Http2Headers headers, Http2Flags flags) throws Http2Exception {
        ByteBuf headerBlock = Unpooled.buffer();
        try {
            this.hpackEncoder.encodeHeaders(streamId, headerBlock, headers, Http2HeadersEncoder.NEVER_SENSITIVE);
            Http2CodecUtil.writeFrameHeader((ByteBuf)output, (int)headerBlock.readableBytes(), (byte)1, (Http2Flags)flags, (int)streamId);
            output.writeBytes(headerBlock, headerBlock.readableBytes());
        }
        finally {
            headerBlock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeaderFrameWithData(ByteBuf output, int streamId, Http2Headers headers, ByteBuf dataPayload) throws Http2Exception {
        ByteBuf headerBlock = Unpooled.buffer();
        try {
            this.hpackEncoder.encodeHeaders(streamId, headerBlock, headers, Http2HeadersEncoder.NEVER_SENSITIVE);
            Http2CodecUtil.writeFrameHeader((ByteBuf)output, (int)headerBlock.readableBytes(), (byte)1, (Http2Flags)new Http2Flags().endOfHeaders(true), (int)streamId);
            output.writeBytes(headerBlock, headerBlock.readableBytes());
            Http2CodecUtil.writeFrameHeader((ByteBuf)output, (int)dataPayload.readableBytes(), (byte)0, (Http2Flags)new Http2Flags().endOfStream(true), (int)streamId);
            output.writeBytes(dataPayload);
        }
        finally {
            headerBlock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeaderFramePriorityPresent(ByteBuf output, int streamId, Http2Headers headers, Http2Flags flags, int streamDependency, int weight) throws Http2Exception {
        ByteBuf headerBlock = Unpooled.buffer();
        try {
            headerBlock.writeInt(streamDependency);
            headerBlock.writeByte(weight - 1);
            this.hpackEncoder.encodeHeaders(streamId, headerBlock, headers, Http2HeadersEncoder.NEVER_SENSITIVE);
            Http2CodecUtil.writeFrameHeader((ByteBuf)output, (int)headerBlock.readableBytes(), (byte)1, (Http2Flags)flags, (int)streamId);
            output.writeBytes(headerBlock, headerBlock.readableBytes());
        }
        finally {
            headerBlock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeContinuationFrame(ByteBuf output, int streamId, Http2Headers headers, Http2Flags flags) throws Http2Exception {
        ByteBuf headerBlock = Unpooled.buffer();
        try {
            this.hpackEncoder.encodeHeaders(streamId, headerBlock, headers, Http2HeadersEncoder.NEVER_SENSITIVE);
            Http2CodecUtil.writeFrameHeader((ByteBuf)output, (int)headerBlock.readableBytes(), (byte)9, (Http2Flags)flags, (int)streamId);
            output.writeBytes(headerBlock, headerBlock.readableBytes());
        }
        finally {
            headerBlock.release();
        }
    }

    private static void writePriorityFrame(ByteBuf output, int streamId, int streamDependency, int weight) {
        Http2CodecUtil.writeFrameHeader((ByteBuf)output, (int)5, (byte)2, (Http2Flags)new Http2Flags(), (int)streamId);
        output.writeInt(streamDependency);
        output.writeByte(weight - 1);
    }
}

