/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.openapi.tasks;

import io.micronaut.gradle.openapi.tasks.AbstractOpenApiWorkAction;
import io.micronaut.openapi.generator.MicronautCodeGeneratorBuilder;
import java.util.List;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;

public abstract class OpenApiClientWorkAction
extends AbstractOpenApiWorkAction<ClientParameters> {
    @Override
    protected void configureBuilder(MicronautCodeGeneratorBuilder builder) {
        ClientParameters parameters = (ClientParameters)this.getParameters();
        if ("kotlin".equalsIgnoreCase((String)parameters.getLang().get())) {
            builder.forKotlinClient(spec -> {
                spec.withAuthorization(((Boolean)parameters.getUseAuth().get()).booleanValue()).withAdditionalClientTypeAnnotations((List)parameters.getAdditionalClientTypeAnnotations().getOrElse(List.of())).withGeneratedAnnotation(((Boolean)parameters.getGeneratedAnnotation().get()).booleanValue()).withFluxForArrays(((Boolean)parameters.getFluxForArrays().get()).booleanValue()).withKsp(((Boolean)parameters.getKsp().get()).booleanValue());
                if (parameters.getClientId().isPresent()) {
                    spec.withClientId((String)parameters.getClientId().get());
                }
                if (parameters.getClientPath().isPresent()) {
                    spec.withClientPath(((Boolean)parameters.getClientPath().get()).booleanValue());
                }
                if (parameters.getBasePathSeparator().isPresent()) {
                    spec.withBasePathSeparator((String)parameters.getBasePathSeparator().get());
                }
                if (parameters.getAuthorizationFilterPattern().isPresent()) {
                    spec.withAuthorizationFilterPattern((String)parameters.getAuthorizationFilterPattern().get());
                }
                if (parameters.getCoroutines().isPresent()) {
                    spec.withCoroutines(((Boolean)parameters.getCoroutines().get()).booleanValue());
                }
            });
        } else {
            builder.forJavaClient(spec -> {
                spec.withAuthorization(((Boolean)parameters.getUseAuth().get()).booleanValue()).withAdditionalClientTypeAnnotations((List)parameters.getAdditionalClientTypeAnnotations().getOrElse(List.of())).withLombok(((Boolean)parameters.getLombok().get()).booleanValue()).withGeneratedAnnotation(((Boolean)parameters.getGeneratedAnnotation().get()).booleanValue()).withFluxForArrays(((Boolean)parameters.getFluxForArrays().get()).booleanValue());
                if (parameters.getClientId().isPresent()) {
                    spec.withClientId((String)parameters.getClientId().get());
                }
                if (parameters.getClientPath().isPresent()) {
                    spec.withClientPath(((Boolean)parameters.getClientPath().get()).booleanValue());
                }
                if (parameters.getBasePathSeparator().isPresent()) {
                    spec.withBasePathSeparator((String)parameters.getBasePathSeparator().get());
                }
                if (parameters.getAuthorizationFilterPattern().isPresent()) {
                    spec.withAuthorizationFilterPattern((String)parameters.getAuthorizationFilterPattern().get());
                }
            });
        }
    }

    protected static interface ClientParameters
    extends AbstractOpenApiWorkAction.OpenApiParameters {
        public Property<String> getClientId();

        public Property<Boolean> getClientPath();

        public Property<Boolean> getUseAuth();

        public Property<String> getAuthorizationFilterPattern();

        public Property<String> getBasePathSeparator();

        public ListProperty<String> getAdditionalClientTypeAnnotations();
    }
}

