/*
 * Decompiled with CFR 0.152.
 */
package io.logmatic.android;

import android.util.Log;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.logmatic.android.LogmaticAppender;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Logger {
    public static final String TAG = "logmatic";
    private final String name;
    private final LogmaticAppender appender;
    private Set<Map.Entry<String, JsonElement>> extraFields;
    private boolean timestamping;
    private boolean legacyLogging;
    private static final String ISO_8601 = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
    private static final Gson gson = new GsonBuilder().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    public Logger(String name, LogmaticAppender appender, boolean timestamping, boolean legacyLogging, Set<Map.Entry<String, JsonElement>> extraFields) {
        this.name = name;
        this.appender = appender;
        this.timestamping = timestamping;
        this.legacyLogging = legacyLogging;
        this.extraFields = extraFields;
    }

    public void v(String message) {
        this.internalLog(2, message);
    }

    public void v(String message, Object context) {
        this.internalLog(2, message, context);
    }

    public void d(String message) {
        this.internalLog(3, message);
    }

    public void d(String message, Object context) {
        this.internalLog(3, message, context);
    }

    public void i(String message) {
        this.internalLog(4, message);
    }

    public void i(String message, Object context) {
        this.internalLog(4, message, context);
    }

    public void w(String message) {
        this.internalLog(3, message);
    }

    public void w(String message, Object context) {
        this.internalLog(3, message, context);
    }

    public void e(String message) {
        this.internalLog(6, message);
    }

    public void e(String message, Object context) {
        this.internalLog(6, message, context);
    }

    public void wtf(String message) {
        this.internalLog(6, message);
    }

    public void wtf(String message, Object context) {
        this.internalLog(6, message, context);
    }

    public void addField(String key, String value) {
        this.extraFields.add(new AbstractMap.SimpleEntry<String, JsonElement>(key, gson.toJsonTree((Object)value)));
    }

    public void addField(String key, Long value) {
        this.extraFields.add(new AbstractMap.SimpleEntry<String, JsonElement>(key, gson.toJsonTree((Object)value)));
    }

    public void addField(String key, Integer value) {
        this.extraFields.add(new AbstractMap.SimpleEntry<String, JsonElement>(key, gson.toJsonTree((Object)value)));
    }

    public void addField(String key, Float value) {
        this.extraFields.add(new AbstractMap.SimpleEntry<String, JsonElement>(key, gson.toJsonTree((Object)value)));
    }

    public void addField(String key, Double value) {
        this.extraFields.add(new AbstractMap.SimpleEntry<String, JsonElement>(key, gson.toJsonTree((Object)value)));
    }

    public void addField(String key, Boolean value) {
        this.extraFields.add(new AbstractMap.SimpleEntry<String, JsonElement>(key, gson.toJsonTree((Object)value)));
    }

    public void addField(String key, Date value) {
        this.extraFields.add(new AbstractMap.SimpleEntry<String, JsonElement>(key, gson.toJsonTree((Object)value.getTime())));
    }

    private void internalLog(int level, String message) {
        this.internalLog(level, message, null);
    }

    private void internalLog(int level, String message, Object context) {
        if (this.legacyLogging) {
            Log.println((int)level, (String)this.name, (String)message);
        }
        JsonObject event = new JsonObject();
        try {
            JsonElement root;
            if (context != null && (root = gson.toJsonTree(context)).isJsonObject()) {
                event = root.getAsJsonObject();
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
        for (Map.Entry<String, JsonElement> e : this.extraFields) {
            event.add(e.getKey(), e.getValue());
        }
        event.addProperty("message", message);
        event.addProperty("severity", this.getLevelAsString(level));
        event.addProperty("appname", this.name);
        if (this.timestamping) {
            event.addProperty("date", simpleDateFormat.format(new Date()));
        }
        this.appender.append(gson.toJson((JsonElement)event));
    }

    private String getLevelAsString(int level) {
        switch (level) {
            case 6: {
                return "ERROR";
            }
            case 5: {
                return "WARN";
            }
            case 4: {
                return "INFO";
            }
            case 3: {
                return "DEBUG";
            }
            case 2: {
                return "TRACE";
            }
        }
        return "DEBUG";
    }

    public LogmaticAppender getAppender() {
        return this.appender;
    }
}

