/*
 * Decompiled with CFR 0.152.
 */
package io.logmatic.android;

import android.os.AsyncTask;
import android.util.Log;
import io.logmatic.android.endpoint.Endpoint;
import java.util.Deque;
import java.util.LinkedList;

public class EndpointManager
extends AsyncTask<Deque<String>, Integer, Void> {
    private static final long RECONNECTION_WAIT = 300L;
    private static final int MAX_ATTEMPT = 3;
    private static final int MAX_EVENTS_PER_BULK = 1000;
    private static final int MAX_BYTES_PER_BULK = 102400;
    private Endpoint endpoint;

    public EndpointManager(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void shutdown() {
        this.endpoint.closeConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void doInBackground(Deque<String> ... sources) {
        block5: for (Deque<String> source : sources) {
            try {
                for (int attempt = 0; attempt <= 3; ++attempt) {
                    int minOfEventsToSend = source.size();
                    int numberOfEventsSent = 0;
                    boolean withoutFailure = true;
                    Log.v((String)"logmatic", (String)("new attempt, sending " + minOfEventsToSend + " events at minimum"));
                    Log.v((String)"logmatic", (String)"opening a new connection to Logmatic.io");
                    if (this.endpoint.openConnection()) {
                        int j = 0;
                        while (numberOfEventsSent < minOfEventsToSend && withoutFailure) {
                            String element;
                            LinkedList<String> bulk = new LinkedList<String>();
                            for (int totalOfBytes = 0; bulk.size() < 1000 && totalOfBytes < 102400 && (element = source.pollFirst()) != null; totalOfBytes += element.length()) {
                                bulk.add(element);
                            }
                            StringBuilder payload = new StringBuilder();
                            for (String element2 : bulk) {
                                payload.append(element2);
                            }
                            withoutFailure = this.endpoint.send(payload.toString());
                            this.endpoint.flush();
                            if (!withoutFailure) {
                                for (int i = bulk.size() - 1; i >= 0; --i) {
                                    source.offerFirst((String)bulk.get(i));
                                    bulk.remove(i);
                                }
                                Log.v((String)"logmatic", (String)("Bulk[ " + j + " ] failed,  rollback!"));
                                break;
                            }
                            Log.v((String)"logmatic", (String)("Bulk[ " + j + " ] sent,  events: " + bulk.size() + "/" + (numberOfEventsSent += bulk.size())));
                            ++j;
                        }
                        if (withoutFailure) {
                            continue block5;
                        }
                    }
                    Log.v((String)"logmatic", (String)("attempt " + attempt + " failed, waiting for a new connection"));
                    this.endpoint.closeConnection();
                    Thread.sleep(300L);
                }
            }
            catch (Exception e) {
                Log.e((String)((Object)((Object)this)).getClass().getName(), (String)e.getMessage(), (Throwable)e);
            }
            finally {
                this.endpoint.closeConnection();
            }
        }
        Log.v((String)"logmatic", (String)"Sending loop finished");
        return null;
    }
}

