/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.boot.requestmapping;

import io.leopard.boot.requestmapping.ContextPathSwitchgear;
import io.leopard.boot.requestmapping.RequestMappingInfoCombiner;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

@Component
public class ContextPathRequestMappingInfoCombiner
implements RequestMappingInfoCombiner {
    @Value(value="${leopard.context-path:}")
    private String contextPath;
    @Autowired(required=false)
    private List<ContextPathSwitchgear> contextPathSwitchgears;

    @Override
    public RequestMappingInfo combine(RequestMappingInfo.BuilderConfiguration options, RequestMappingInfo info, Method method, Class<?> handlerType) {
        boolean isEnableContextPath = this.isEnableContextPath(method, handlerType);
        if (!isEnableContextPath) {
            return null;
        }
        RequestMappingInfo context = RequestMappingInfo.paths((String[])new String[]{this.contextPath}).options(options).build();
        return context.combine(info);
    }

    protected boolean isEnableContextPath(Method method, Class<?> handlerType) {
        if (StringUtils.isEmpty((Object)this.contextPath)) {
            return false;
        }
        if (this.contextPathSwitchgears != null) {
            for (ContextPathSwitchgear switchgear : this.contextPathSwitchgears) {
                Boolean enable = switchgear.isEnableContextPath(method, handlerType);
                if (enable == null) continue;
                return enable;
            }
        }
        return true;
    }
}

