/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.credentials;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.util.KubeConfig;
import io.kubernetes.client.util.credentials.AccessTokenAuthentication;
import io.kubernetes.client.util.credentials.Authentication;
import io.kubernetes.client.util.credentials.ClientCertificateAuthentication;
import io.kubernetes.client.util.credentials.DummyAuthentication;
import io.kubernetes.client.util.credentials.RefreshAuthentication;
import io.kubernetes.client.util.credentials.UsernamePasswordAuthentication;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class KubeconfigAuthentication
implements Authentication {
    private final Authentication delegateAuthentication;
    private Duration tokenRefreshPeriod;

    public KubeconfigAuthentication(KubeConfig config, Duration tokenRefreshPeriod) throws IOException {
        byte[] clientCert = config.getDataOrFileRelative(config.getClientCertificateData(), config.getClientCertificateFile());
        byte[] clientKey = config.getDataOrFileRelative(config.getClientKeyData(), config.getClientKeyFile());
        if (clientCert != null && clientKey != null) {
            this.delegateAuthentication = new ClientCertificateAuthentication(clientCert, clientKey);
            return;
        }
        String userName = config.getUsername();
        String userPassword = config.getPassword();
        if (StringUtils.isNotEmpty((CharSequence)userName) && StringUtils.isNotEmpty((CharSequence)userPassword)) {
            this.delegateAuthentication = new UsernamePasswordAuthentication(userName, userPassword);
            return;
        }
        Map<String, String> credentials = config.getCredentials();
        if (credentials != null) {
            if (StringUtils.isNotEmpty((CharSequence)credentials.get("token"))) {
                this.delegateAuthentication = tokenRefreshPeriod == null ? new AccessTokenAuthentication(credentials.get("token")) : new RefreshAuthentication(() -> config.getCredentials().get("token"), tokenRefreshPeriod);
                return;
            }
            if (StringUtils.isNotEmpty((CharSequence)credentials.get("clientCertificateData")) && StringUtils.isNotEmpty((CharSequence)credentials.get("clientKeyData"))) {
                this.delegateAuthentication = new ClientCertificateAuthentication(credentials.get("clientCertificateData").getBytes(StandardCharsets.UTF_8), credentials.get("clientKeyData").getBytes(StandardCharsets.UTF_8));
                return;
            }
        }
        this.delegateAuthentication = new DummyAuthentication();
    }

    @Override
    public void provide(ApiClient client) {
        this.delegateAuthentication.provide(client);
    }

    public Authentication getDelegateAuthentication() {
        return this.delegateAuthentication;
    }
}

