/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.monitoring.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Most recent observed status of the ThanosRuler cluster. Read-only. Not included when requesting from the apiserver, only from the ThanosRuler Operator API itself. More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#spec-and-status")
public class V1ThanosRulerStatus {
    public static final String SERIALIZED_NAME_AVAILABLE_REPLICAS = "availableReplicas";
    @SerializedName(value="availableReplicas")
    private Integer availableReplicas;
    public static final String SERIALIZED_NAME_PAUSED = "paused";
    @SerializedName(value="paused")
    private Boolean paused;
    public static final String SERIALIZED_NAME_REPLICAS = "replicas";
    @SerializedName(value="replicas")
    private Integer replicas;
    public static final String SERIALIZED_NAME_UNAVAILABLE_REPLICAS = "unavailableReplicas";
    @SerializedName(value="unavailableReplicas")
    private Integer unavailableReplicas;
    public static final String SERIALIZED_NAME_UPDATED_REPLICAS = "updatedReplicas";
    @SerializedName(value="updatedReplicas")
    private Integer updatedReplicas;

    public V1ThanosRulerStatus availableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return this;
    }

    @ApiModelProperty(required=true, value="Total number of available pods (ready for at least minReadySeconds) targeted by this ThanosRuler deployment.")
    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    public void setAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
    }

    public V1ThanosRulerStatus paused(Boolean paused) {
        this.paused = paused;
        return this;
    }

    @ApiModelProperty(required=true, value="Represents whether any actions on the underlying managed objects are being performed. Only delete actions will be performed.")
    public Boolean getPaused() {
        return this.paused;
    }

    public void setPaused(Boolean paused) {
        this.paused = paused;
    }

    public V1ThanosRulerStatus replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @ApiModelProperty(required=true, value="Total number of non-terminated pods targeted by this ThanosRuler deployment (their labels match the selector).")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public V1ThanosRulerStatus unavailableReplicas(Integer unavailableReplicas) {
        this.unavailableReplicas = unavailableReplicas;
        return this;
    }

    @ApiModelProperty(required=true, value="Total number of unavailable pods targeted by this ThanosRuler deployment.")
    public Integer getUnavailableReplicas() {
        return this.unavailableReplicas;
    }

    public void setUnavailableReplicas(Integer unavailableReplicas) {
        this.unavailableReplicas = unavailableReplicas;
    }

    public V1ThanosRulerStatus updatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
        return this;
    }

    @ApiModelProperty(required=true, value="Total number of non-terminated pods targeted by this ThanosRuler deployment that have the desired version spec.")
    public Integer getUpdatedReplicas() {
        return this.updatedReplicas;
    }

    public void setUpdatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ThanosRulerStatus v1ThanosRulerStatus = (V1ThanosRulerStatus)o;
        return Objects.equals(this.availableReplicas, v1ThanosRulerStatus.availableReplicas) && Objects.equals(this.paused, v1ThanosRulerStatus.paused) && Objects.equals(this.replicas, v1ThanosRulerStatus.replicas) && Objects.equals(this.unavailableReplicas, v1ThanosRulerStatus.unavailableReplicas) && Objects.equals(this.updatedReplicas, v1ThanosRulerStatus.updatedReplicas);
    }

    public int hashCode() {
        return Objects.hash(this.availableReplicas, this.paused, this.replicas, this.unavailableReplicas, this.updatedReplicas);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ThanosRulerStatus {\n");
        sb.append("    availableReplicas: ").append(this.toIndentedString(this.availableReplicas)).append("\n");
        sb.append("    paused: ").append(this.toIndentedString(this.paused)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    unavailableReplicas: ").append(this.toIndentedString(this.unavailableReplicas)).append("\n");
        sb.append("    updatedReplicas: ").append(this.toIndentedString(this.updatedReplicas)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

