/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.monitoring.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="EmptyDir represents a temporary directory that shares a pod's lifetime. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir")
public class V1ThanosRulerSpecEmptyDir {
    public static final String SERIALIZED_NAME_MEDIUM = "medium";
    @SerializedName(value="medium")
    private String medium;
    public static final String SERIALIZED_NAME_SIZE_LIMIT = "sizeLimit";
    @SerializedName(value="sizeLimit")
    private String sizeLimit;

    public V1ThanosRulerSpecEmptyDir medium(String medium) {
        this.medium = medium;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="What type of storage medium should back this directory. The default is \"\" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir")
    public String getMedium() {
        return this.medium;
    }

    public void setMedium(String medium) {
        this.medium = medium;
    }

    public V1ThanosRulerSpecEmptyDir sizeLimit(String sizeLimit) {
        this.sizeLimit = sizeLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: http://kubernetes.io/docs/user-guide/volumes#emptydir")
    public String getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(String sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ThanosRulerSpecEmptyDir v1ThanosRulerSpecEmptyDir = (V1ThanosRulerSpecEmptyDir)o;
        return Objects.equals(this.medium, v1ThanosRulerSpecEmptyDir.medium) && Objects.equals(this.sizeLimit, v1ThanosRulerSpecEmptyDir.sizeLimit);
    }

    public int hashCode() {
        return Objects.hash(this.medium, this.sizeLimit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ThanosRulerSpecEmptyDir {\n");
        sb.append("    medium: ").append(this.toIndentedString(this.medium)).append("\n");
        sb.append("    sizeLimit: ").append(this.toIndentedString(this.sizeLimit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

