/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cert.manager.models.V1beta1OrderStatusAuthorizations;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class V1beta1OrderStatus {
    public static final String SERIALIZED_NAME_AUTHORIZATIONS = "authorizations";
    @SerializedName(value="authorizations")
    private List<V1beta1OrderStatusAuthorizations> authorizations = null;
    public static final String SERIALIZED_NAME_CERTIFICATE = "certificate";
    @SerializedName(value="certificate")
    private byte[] certificate;
    public static final String SERIALIZED_NAME_FAILURE_TIME = "failureTime";
    @SerializedName(value="failureTime")
    private DateTime failureTime;
    public static final String SERIALIZED_NAME_FINALIZE_U_R_L = "finalizeURL";
    @SerializedName(value="finalizeURL")
    private String finalizeURL;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private String reason;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;

    public V1beta1OrderStatus authorizations(List<V1beta1OrderStatusAuthorizations> authorizations) {
        this.authorizations = authorizations;
        return this;
    }

    public V1beta1OrderStatus addAuthorizationsItem(V1beta1OrderStatusAuthorizations authorizationsItem) {
        if (this.authorizations == null) {
            this.authorizations = new ArrayList<V1beta1OrderStatusAuthorizations>();
        }
        this.authorizations.add(authorizationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Authorizations contains data returned from the ACME server on what authorizations must be completed in order to validate the DNS names specified on the Order.")
    public List<V1beta1OrderStatusAuthorizations> getAuthorizations() {
        return this.authorizations;
    }

    public void setAuthorizations(List<V1beta1OrderStatusAuthorizations> authorizations) {
        this.authorizations = authorizations;
    }

    public V1beta1OrderStatus certificate(byte[] certificate) {
        this.certificate = certificate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Certificate is a copy of the PEM encoded certificate for this Order. This field will be populated after the order has been successfully finalized with the ACME server, and the order has transitioned to the 'valid' state.")
    public byte[] getCertificate() {
        return this.certificate;
    }

    public void setCertificate(byte[] certificate) {
        this.certificate = certificate;
    }

    public V1beta1OrderStatus failureTime(DateTime failureTime) {
        this.failureTime = failureTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="FailureTime stores the time that this order failed. This is used to influence garbage collection and back-off.")
    public DateTime getFailureTime() {
        return this.failureTime;
    }

    public void setFailureTime(DateTime failureTime) {
        this.failureTime = failureTime;
    }

    public V1beta1OrderStatus finalizeURL(String finalizeURL) {
        this.finalizeURL = finalizeURL;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="FinalizeURL of the Order. This is used to obtain certificates for this order once it has been completed.")
    public String getFinalizeURL() {
        return this.finalizeURL;
    }

    public void setFinalizeURL(String finalizeURL) {
        this.finalizeURL = finalizeURL;
    }

    public V1beta1OrderStatus reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Reason optionally provides more information about a why the order is in the current state.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public V1beta1OrderStatus state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="State contains the current state of this Order resource. States 'success' and 'expired' are 'final'")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public V1beta1OrderStatus url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL of the Order. This will initially be empty when the resource is first created. The Order controller will populate this field when the Order is first processed. This field will be immutable after it is initially set.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1OrderStatus v1beta1OrderStatus = (V1beta1OrderStatus)o;
        return Objects.equals(this.authorizations, v1beta1OrderStatus.authorizations) && Arrays.equals(this.certificate, v1beta1OrderStatus.certificate) && Objects.equals(this.failureTime, v1beta1OrderStatus.failureTime) && Objects.equals(this.finalizeURL, v1beta1OrderStatus.finalizeURL) && Objects.equals(this.reason, v1beta1OrderStatus.reason) && Objects.equals((Object)this.state, (Object)v1beta1OrderStatus.state) && Objects.equals(this.url, v1beta1OrderStatus.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorizations, Arrays.hashCode(this.certificate), this.failureTime, this.finalizeURL, this.reason, this.state, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1OrderStatus {\n");
        sb.append("    authorizations: ").append(this.toIndentedString(this.authorizations)).append("\n");
        sb.append("    certificate: ").append(this.toIndentedString(this.certificate)).append("\n");
        sb.append("    failureTime: ").append(this.toIndentedString(this.failureTime)).append("\n");
        sb.append("    finalizeURL: ").append(this.toIndentedString(this.finalizeURL)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        VALID("valid"),
        READY("ready"),
        PENDING("pending"),
        PROCESSING("processing"),
        INVALID("invalid"),
        EXPIRED("expired"),
        ERRORED("errored");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }
}

