/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.annotations.SerializedName;
import io.cert.manager.models.V1beta1OrderSpecIssuerRef;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class V1beta1OrderSpec {
    public static final String SERIALIZED_NAME_COMMON_NAME = "commonName";
    @SerializedName(value="commonName")
    private String commonName;
    public static final String SERIALIZED_NAME_DNS_NAMES = "dnsNames";
    @SerializedName(value="dnsNames")
    private List<String> dnsNames = new ArrayList<String>();
    public static final String SERIALIZED_NAME_ISSUER_REF = "issuerRef";
    @SerializedName(value="issuerRef")
    private V1beta1OrderSpecIssuerRef issuerRef;
    public static final String SERIALIZED_NAME_REQUEST = "request";
    @SerializedName(value="request")
    private byte[] request;

    public V1beta1OrderSpec commonName(String commonName) {
        this.commonName = commonName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CommonName is the common name as specified on the DER encoded CSR. If specified, this value must also be present in `dnsNames`. This field must match the corresponding field on the DER encoded CSR.")
    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public V1beta1OrderSpec dnsNames(List<String> dnsNames) {
        this.dnsNames = dnsNames;
        return this;
    }

    public V1beta1OrderSpec addDnsNamesItem(String dnsNamesItem) {
        this.dnsNames.add(dnsNamesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="DNSNames is a list of DNS names that should be included as part of the Order validation process. This field must match the corresponding field on the DER encoded CSR.")
    public List<String> getDnsNames() {
        return this.dnsNames;
    }

    public void setDnsNames(List<String> dnsNames) {
        this.dnsNames = dnsNames;
    }

    public V1beta1OrderSpec issuerRef(V1beta1OrderSpecIssuerRef issuerRef) {
        this.issuerRef = issuerRef;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1beta1OrderSpecIssuerRef getIssuerRef() {
        return this.issuerRef;
    }

    public void setIssuerRef(V1beta1OrderSpecIssuerRef issuerRef) {
        this.issuerRef = issuerRef;
    }

    public V1beta1OrderSpec request(byte[] request) {
        this.request = request;
        return this;
    }

    @ApiModelProperty(required=true, value="Certificate signing request bytes in DER encoding. This will be used when finalizing the order. This field must be set on the order.")
    public byte[] getRequest() {
        return this.request;
    }

    public void setRequest(byte[] request) {
        this.request = request;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1OrderSpec v1beta1OrderSpec = (V1beta1OrderSpec)o;
        return Objects.equals(this.commonName, v1beta1OrderSpec.commonName) && Objects.equals(this.dnsNames, v1beta1OrderSpec.dnsNames) && Objects.equals(this.issuerRef, v1beta1OrderSpec.issuerRef) && Arrays.equals(this.request, v1beta1OrderSpec.request);
    }

    public int hashCode() {
        return Objects.hash(this.commonName, this.dnsNames, this.issuerRef, Arrays.hashCode(this.request));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1OrderSpec {\n");
        sb.append("    commonName: ").append(this.toIndentedString(this.commonName)).append("\n");
        sb.append("    dnsNames: ").append(this.toIndentedString(this.dnsNames)).append("\n");
        sb.append("    issuerRef: ").append(this.toIndentedString(this.issuerRef)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

