/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.annotations.SerializedName;
import io.cert.manager.models.V1alpha2IssuerSpecVenafiTppCredentialsRef;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="TPP specifies Trust Protection Platform configuration settings. Only one of TPP or Cloud may be specified.")
public class V1alpha2IssuerSpecVenafiTpp {
    public static final String SERIALIZED_NAME_CA_BUNDLE = "caBundle";
    @SerializedName(value="caBundle")
    private byte[] caBundle;
    public static final String SERIALIZED_NAME_CREDENTIALS_REF = "credentialsRef";
    @SerializedName(value="credentialsRef")
    private V1alpha2IssuerSpecVenafiTppCredentialsRef credentialsRef;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;

    public V1alpha2IssuerSpecVenafiTpp caBundle(byte[] caBundle) {
        this.caBundle = caBundle;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CABundle is a PEM encoded TLS certificate to use to verify connections to the TPP instance. If specified, system roots will not be used and the issuing CA for the TPP instance must be verifiable using the provided root. If not specified, the connection will be verified using the cert-manager system root certificates.")
    public byte[] getCaBundle() {
        return this.caBundle;
    }

    public void setCaBundle(byte[] caBundle) {
        this.caBundle = caBundle;
    }

    public V1alpha2IssuerSpecVenafiTpp credentialsRef(V1alpha2IssuerSpecVenafiTppCredentialsRef credentialsRef) {
        this.credentialsRef = credentialsRef;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1alpha2IssuerSpecVenafiTppCredentialsRef getCredentialsRef() {
        return this.credentialsRef;
    }

    public void setCredentialsRef(V1alpha2IssuerSpecVenafiTppCredentialsRef credentialsRef) {
        this.credentialsRef = credentialsRef;
    }

    public V1alpha2IssuerSpecVenafiTpp url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(required=true, value="URL is the base URL for the vedsdk endpoint of the Venafi TPP instance, for example: \"https://tpp.example.com/vedsdk\".")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2IssuerSpecVenafiTpp v1alpha2IssuerSpecVenafiTpp = (V1alpha2IssuerSpecVenafiTpp)o;
        return Arrays.equals(this.caBundle, v1alpha2IssuerSpecVenafiTpp.caBundle) && Objects.equals(this.credentialsRef, v1alpha2IssuerSpecVenafiTpp.credentialsRef) && Objects.equals(this.url, v1alpha2IssuerSpecVenafiTpp.url);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.caBundle), this.credentialsRef, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2IssuerSpecVenafiTpp {\n");
        sb.append("    caBundle: ").append(this.toIndentedString(this.caBundle)).append("\n");
        sb.append("    credentialsRef: ").append(this.toIndentedString(this.credentialsRef)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

