/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.annotations.SerializedName;
import io.cert.manager.models.V1alpha2IssuerSpecVaultAuthKubernetesSecretRef;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Kubernetes authenticates with Vault by passing the ServiceAccount token stored in the named Secret resource to the Vault server.")
public class V1alpha2IssuerSpecVaultAuthKubernetes {
    public static final String SERIALIZED_NAME_MOUNT_PATH = "mountPath";
    @SerializedName(value="mountPath")
    private String mountPath;
    public static final String SERIALIZED_NAME_ROLE = "role";
    @SerializedName(value="role")
    private String role;
    public static final String SERIALIZED_NAME_SECRET_REF = "secretRef";
    @SerializedName(value="secretRef")
    private V1alpha2IssuerSpecVaultAuthKubernetesSecretRef secretRef;

    public V1alpha2IssuerSpecVaultAuthKubernetes mountPath(String mountPath) {
        this.mountPath = mountPath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Vault mountPath here is the mount path to use when authenticating with Vault. For example, setting a value to `/v1/auth/foo`, will use the path `/v1/auth/foo/login` to authenticate with Vault. If unspecified, the default value \"/v1/auth/kubernetes\" will be used.")
    public String getMountPath() {
        return this.mountPath;
    }

    public void setMountPath(String mountPath) {
        this.mountPath = mountPath;
    }

    public V1alpha2IssuerSpecVaultAuthKubernetes role(String role) {
        this.role = role;
        return this;
    }

    @ApiModelProperty(required=true, value="A required field containing the Vault Role to assume. A Role binds a Kubernetes ServiceAccount with a set of Vault policies.")
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public V1alpha2IssuerSpecVaultAuthKubernetes secretRef(V1alpha2IssuerSpecVaultAuthKubernetesSecretRef secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1alpha2IssuerSpecVaultAuthKubernetesSecretRef getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(V1alpha2IssuerSpecVaultAuthKubernetesSecretRef secretRef) {
        this.secretRef = secretRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2IssuerSpecVaultAuthKubernetes v1alpha2IssuerSpecVaultAuthKubernetes = (V1alpha2IssuerSpecVaultAuthKubernetes)o;
        return Objects.equals(this.mountPath, v1alpha2IssuerSpecVaultAuthKubernetes.mountPath) && Objects.equals(this.role, v1alpha2IssuerSpecVaultAuthKubernetes.role) && Objects.equals(this.secretRef, v1alpha2IssuerSpecVaultAuthKubernetes.secretRef);
    }

    public int hashCode() {
        return Objects.hash(this.mountPath, this.role, this.secretRef);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2IssuerSpecVaultAuthKubernetes {\n");
        sb.append("    mountPath: ").append(this.toIndentedString(this.mountPath)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    secretRef: ").append(this.toIndentedString(this.secretRef)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

