/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.FlowcontrolV1Subject;
import io.kubernetes.client.openapi.models.V1NonResourcePolicyRule;
import io.kubernetes.client.openapi.models.V1ResourcePolicyRule;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="PolicyRulesWithSubjects prescribes a test that applies to a request to an apiserver. The test considers the subject making the request, the verb being requested, and the resource to be acted upon. This PolicyRulesWithSubjects matches a request if and only if both (a) at least one member of subjects matches the request and (b) at least one member of resourceRules or nonResourceRules matches the request.")
public class V1PolicyRulesWithSubjects {
    public static final String SERIALIZED_NAME_NON_RESOURCE_RULES = "nonResourceRules";
    @SerializedName(value="nonResourceRules")
    @Nullable
    private List<V1NonResourcePolicyRule> nonResourceRules = new ArrayList<V1NonResourcePolicyRule>();
    public static final String SERIALIZED_NAME_RESOURCE_RULES = "resourceRules";
    @SerializedName(value="resourceRules")
    @Nullable
    private List<V1ResourcePolicyRule> resourceRules = new ArrayList<V1ResourcePolicyRule>();
    public static final String SERIALIZED_NAME_SUBJECTS = "subjects";
    @SerializedName(value="subjects")
    @Nonnull
    private List<FlowcontrolV1Subject> subjects = new ArrayList<FlowcontrolV1Subject>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1PolicyRulesWithSubjects nonResourceRules(@Nullable List<V1NonResourcePolicyRule> nonResourceRules) {
        this.nonResourceRules = nonResourceRules;
        return this;
    }

    public V1PolicyRulesWithSubjects addNonResourceRulesItem(V1NonResourcePolicyRule nonResourceRulesItem) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList<V1NonResourcePolicyRule>();
        }
        this.nonResourceRules.add(nonResourceRulesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`nonResourceRules` is a list of NonResourcePolicyRules that identify matching requests according to their verb and the target non-resource URL.")
    public List<V1NonResourcePolicyRule> getNonResourceRules() {
        return this.nonResourceRules;
    }

    public void setNonResourceRules(@Nullable List<V1NonResourcePolicyRule> nonResourceRules) {
        this.nonResourceRules = nonResourceRules;
    }

    public V1PolicyRulesWithSubjects resourceRules(@Nullable List<V1ResourcePolicyRule> resourceRules) {
        this.resourceRules = resourceRules;
        return this;
    }

    public V1PolicyRulesWithSubjects addResourceRulesItem(V1ResourcePolicyRule resourceRulesItem) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList<V1ResourcePolicyRule>();
        }
        this.resourceRules.add(resourceRulesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`resourceRules` is a slice of ResourcePolicyRules that identify matching requests according to their verb and the target resource. At least one of `resourceRules` and `nonResourceRules` has to be non-empty.")
    public List<V1ResourcePolicyRule> getResourceRules() {
        return this.resourceRules;
    }

    public void setResourceRules(@Nullable List<V1ResourcePolicyRule> resourceRules) {
        this.resourceRules = resourceRules;
    }

    public V1PolicyRulesWithSubjects subjects(@Nonnull List<FlowcontrolV1Subject> subjects) {
        this.subjects = subjects;
        return this;
    }

    public V1PolicyRulesWithSubjects addSubjectsItem(FlowcontrolV1Subject subjectsItem) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<FlowcontrolV1Subject>();
        }
        this.subjects.add(subjectsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="subjects is the list of normal user, serviceaccount, or group that this rule cares about. There must be at least one member in this slice. A slice that includes both the system:authenticated and system:unauthenticated user groups matches every request. Required.")
    public List<FlowcontrolV1Subject> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(@Nonnull List<FlowcontrolV1Subject> subjects) {
        this.subjects = subjects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PolicyRulesWithSubjects v1PolicyRulesWithSubjects = (V1PolicyRulesWithSubjects)o;
        return Objects.equals(this.nonResourceRules, v1PolicyRulesWithSubjects.nonResourceRules) && Objects.equals(this.resourceRules, v1PolicyRulesWithSubjects.resourceRules) && Objects.equals(this.subjects, v1PolicyRulesWithSubjects.subjects);
    }

    public int hashCode() {
        return Objects.hash(this.nonResourceRules, this.resourceRules, this.subjects);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PolicyRulesWithSubjects {\n");
        sb.append("    nonResourceRules: ").append(this.toIndentedString(this.nonResourceRules)).append("\n");
        sb.append("    resourceRules: ").append(this.toIndentedString(this.resourceRules)).append("\n");
        sb.append("    subjects: ").append(this.toIndentedString(this.subjects)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayresourceRules;
        int i;
        JsonArray jsonArraynonResourceRules;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1PolicyRulesWithSubjects is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1PolicyRulesWithSubjects` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_NON_RESOURCE_RULES) != null && !jsonObj.get(SERIALIZED_NAME_NON_RESOURCE_RULES).isJsonNull() && (jsonArraynonResourceRules = jsonObj.getAsJsonArray(SERIALIZED_NAME_NON_RESOURCE_RULES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_NON_RESOURCE_RULES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `nonResourceRules` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NON_RESOURCE_RULES).toString()));
            }
            for (i = 0; i < jsonArraynonResourceRules.size(); ++i) {
                V1NonResourcePolicyRule.validateJsonElement(jsonArraynonResourceRules.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_RULES) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_RULES).isJsonNull() && (jsonArrayresourceRules = jsonObj.getAsJsonArray(SERIALIZED_NAME_RESOURCE_RULES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RESOURCE_RULES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `resourceRules` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_RULES).toString()));
            }
            for (i = 0; i < jsonArrayresourceRules.size(); ++i) {
                V1ResourcePolicyRule.validateJsonElement(jsonArrayresourceRules.get(i));
            }
        }
        if (!jsonObj.get(SERIALIZED_NAME_SUBJECTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `subjects` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUBJECTS).toString()));
        }
        JsonArray jsonArraysubjects = jsonObj.getAsJsonArray(SERIALIZED_NAME_SUBJECTS);
        for (i = 0; i < jsonArraysubjects.size(); ++i) {
            FlowcontrolV1Subject.validateJsonElement(jsonArraysubjects.get(i));
        }
    }

    public static V1PolicyRulesWithSubjects fromJson(String jsonString) throws IOException {
        return (V1PolicyRulesWithSubjects)JSON.getGson().fromJson(jsonString, V1PolicyRulesWithSubjects.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NON_RESOURCE_RULES);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_RULES);
        openapiFields.add(SERIALIZED_NAME_SUBJECTS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SUBJECTS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1PolicyRulesWithSubjects.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1PolicyRulesWithSubjects.class));
            return new TypeAdapter<V1PolicyRulesWithSubjects>(){

                public void write(JsonWriter out, V1PolicyRulesWithSubjects value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1PolicyRulesWithSubjects read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1PolicyRulesWithSubjects.validateJsonElement(jsonElement);
                    return (V1PolicyRulesWithSubjects)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

