/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1beta1DeviceClaimConfiguration;
import io.kubernetes.client.openapi.models.V1beta1DeviceConstraint;
import io.kubernetes.client.openapi.models.V1beta1DeviceRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="DeviceClaim defines how to request devices with a ResourceClaim.")
public class V1beta1DeviceClaim {
    public static final String SERIALIZED_NAME_CONFIG = "config";
    @SerializedName(value="config")
    private List<V1beta1DeviceClaimConfiguration> config = new ArrayList<V1beta1DeviceClaimConfiguration>();
    public static final String SERIALIZED_NAME_CONSTRAINTS = "constraints";
    @SerializedName(value="constraints")
    private List<V1beta1DeviceConstraint> constraints = new ArrayList<V1beta1DeviceConstraint>();
    public static final String SERIALIZED_NAME_REQUESTS = "requests";
    @SerializedName(value="requests")
    private List<V1beta1DeviceRequest> requests = new ArrayList<V1beta1DeviceRequest>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1beta1DeviceClaim config(List<V1beta1DeviceClaimConfiguration> config) {
        this.config = config;
        return this;
    }

    public V1beta1DeviceClaim addConfigItem(V1beta1DeviceClaimConfiguration configItem) {
        if (this.config == null) {
            this.config = new ArrayList<V1beta1DeviceClaimConfiguration>();
        }
        this.config.add(configItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.")
    public List<V1beta1DeviceClaimConfiguration> getConfig() {
        return this.config;
    }

    public void setConfig(List<V1beta1DeviceClaimConfiguration> config) {
        this.config = config;
    }

    public V1beta1DeviceClaim constraints(List<V1beta1DeviceConstraint> constraints) {
        this.constraints = constraints;
        return this;
    }

    public V1beta1DeviceClaim addConstraintsItem(V1beta1DeviceConstraint constraintsItem) {
        if (this.constraints == null) {
            this.constraints = new ArrayList<V1beta1DeviceConstraint>();
        }
        this.constraints.add(constraintsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="These constraints must be satisfied by the set of devices that get allocated for the claim.")
    public List<V1beta1DeviceConstraint> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List<V1beta1DeviceConstraint> constraints) {
        this.constraints = constraints;
    }

    public V1beta1DeviceClaim requests(List<V1beta1DeviceRequest> requests) {
        this.requests = requests;
        return this;
    }

    public V1beta1DeviceClaim addRequestsItem(V1beta1DeviceRequest requestsItem) {
        if (this.requests == null) {
            this.requests = new ArrayList<V1beta1DeviceRequest>();
        }
        this.requests.add(requestsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.")
    public List<V1beta1DeviceRequest> getRequests() {
        return this.requests;
    }

    public void setRequests(List<V1beta1DeviceRequest> requests) {
        this.requests = requests;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1DeviceClaim v1beta1DeviceClaim = (V1beta1DeviceClaim)o;
        return Objects.equals(this.config, v1beta1DeviceClaim.config) && Objects.equals(this.constraints, v1beta1DeviceClaim.constraints) && Objects.equals(this.requests, v1beta1DeviceClaim.requests);
    }

    public int hashCode() {
        return Objects.hash(this.config, this.constraints, this.requests);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1DeviceClaim {\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    constraints: ").append(this.toIndentedString(this.constraints)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayrequests;
        JsonArray jsonArrayconstraints;
        int i;
        JsonArray jsonArrayconfig;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1beta1DeviceClaim is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1beta1DeviceClaim` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_CONFIG).isJsonNull() && (jsonArrayconfig = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONFIG)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONFIG).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `config` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONFIG).toString()));
            }
            for (i = 0; i < jsonArrayconfig.size(); ++i) {
                V1beta1DeviceClaimConfiguration.validateJsonElement(jsonArrayconfig.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_CONSTRAINTS) != null && !jsonObj.get(SERIALIZED_NAME_CONSTRAINTS).isJsonNull() && (jsonArrayconstraints = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONSTRAINTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONSTRAINTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `constraints` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONSTRAINTS).toString()));
            }
            for (i = 0; i < jsonArrayconstraints.size(); ++i) {
                V1beta1DeviceConstraint.validateJsonElement(jsonArrayconstraints.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUESTS) != null && !jsonObj.get(SERIALIZED_NAME_REQUESTS).isJsonNull() && (jsonArrayrequests = jsonObj.getAsJsonArray(SERIALIZED_NAME_REQUESTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_REQUESTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `requests` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUESTS).toString()));
            }
            for (i = 0; i < jsonArrayrequests.size(); ++i) {
                V1beta1DeviceRequest.validateJsonElement(jsonArrayrequests.get(i));
            }
        }
    }

    public static V1beta1DeviceClaim fromJson(String jsonString) throws IOException {
        return (V1beta1DeviceClaim)JSON.getGson().fromJson(jsonString, V1beta1DeviceClaim.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONFIG);
        openapiFields.add(SERIALIZED_NAME_CONSTRAINTS);
        openapiFields.add(SERIALIZED_NAME_REQUESTS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1beta1DeviceClaim.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1beta1DeviceClaim.class));
            return new TypeAdapter<V1beta1DeviceClaim>(){

                public void write(JsonWriter out, V1beta1DeviceClaim value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1beta1DeviceClaim read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1beta1DeviceClaim.validateJsonElement(jsonElement);
                    return (V1beta1DeviceClaim)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

