/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V2MetricTarget;
import java.util.Objects;

public class V2MetricTargetFluent<A extends V2MetricTargetFluent<A>>
extends BaseFluent<A> {
    private Integer averageUtilization;
    private Quantity averageValue;
    private String type;
    private Quantity value;

    public V2MetricTargetFluent() {
    }

    public V2MetricTargetFluent(V2MetricTarget instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V2MetricTarget instance) {
        V2MetricTarget v2MetricTarget = instance = instance != null ? instance : new V2MetricTarget();
        if (instance != null) {
            this.withAverageUtilization(instance.getAverageUtilization());
            this.withAverageValue(instance.getAverageValue());
            this.withType(instance.getType());
            this.withValue(instance.getValue());
        }
    }

    public Integer getAverageUtilization() {
        return this.averageUtilization;
    }

    public A withAverageUtilization(Integer averageUtilization) {
        this.averageUtilization = averageUtilization;
        return (A)this;
    }

    public boolean hasAverageUtilization() {
        return this.averageUtilization != null;
    }

    public Quantity getAverageValue() {
        return this.averageValue;
    }

    public A withAverageValue(Quantity averageValue) {
        this.averageValue = averageValue;
        return (A)this;
    }

    public boolean hasAverageValue() {
        return this.averageValue != null;
    }

    public A withNewAverageValue(String value) {
        return this.withAverageValue(new Quantity(value));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public Quantity getValue() {
        return this.value;
    }

    public A withValue(Quantity value) {
        this.value = value;
        return (A)this;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public A withNewValue(String value) {
        return this.withValue(new Quantity(value));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V2MetricTargetFluent that = (V2MetricTargetFluent)o;
        if (!Objects.equals(this.averageUtilization, that.averageUtilization)) {
            return false;
        }
        if (!Objects.equals(this.averageValue, that.averageValue)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.averageUtilization, this.averageValue, this.type, this.value, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.averageUtilization != null) {
            sb.append("averageUtilization:");
            sb.append(this.averageUtilization + ",");
        }
        if (this.averageValue != null) {
            sb.append("averageValue:");
            sb.append(String.valueOf(this.averageValue) + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.value != null) {
            sb.append("value:");
            sb.append(this.value);
        }
        sb.append("}");
        return sb.toString();
    }
}

