/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1NetworkPolicyIngressRule;
import io.kubernetes.client.openapi.models.V1NetworkPolicyPeer;
import io.kubernetes.client.openapi.models.V1NetworkPolicyPeerBuilder;
import io.kubernetes.client.openapi.models.V1NetworkPolicyPeerFluent;
import io.kubernetes.client.openapi.models.V1NetworkPolicyPort;
import io.kubernetes.client.openapi.models.V1NetworkPolicyPortBuilder;
import io.kubernetes.client.openapi.models.V1NetworkPolicyPortFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1NetworkPolicyIngressRuleFluent<A extends V1NetworkPolicyIngressRuleFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1NetworkPolicyPeerBuilder> from;
    private ArrayList<V1NetworkPolicyPortBuilder> ports;

    public V1NetworkPolicyIngressRuleFluent() {
    }

    public V1NetworkPolicyIngressRuleFluent(V1NetworkPolicyIngressRule instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1NetworkPolicyIngressRule instance) {
        V1NetworkPolicyIngressRule v1NetworkPolicyIngressRule = instance = instance != null ? instance : new V1NetworkPolicyIngressRule();
        if (instance != null) {
            this.withFrom(instance.getFrom());
            this.withPorts(instance.getPorts());
        }
    }

    public A addToFrom(int index, V1NetworkPolicyPeer item) {
        if (this.from == null) {
            this.from = new ArrayList();
        }
        V1NetworkPolicyPeerBuilder builder = new V1NetworkPolicyPeerBuilder(item);
        if (index < 0 || index >= this.from.size()) {
            this._visitables.get("from").add(builder);
            this.from.add(builder);
        } else {
            this._visitables.get("from").add(builder);
            this.from.add(index, builder);
        }
        return (A)this;
    }

    public A setToFrom(int index, V1NetworkPolicyPeer item) {
        if (this.from == null) {
            this.from = new ArrayList();
        }
        V1NetworkPolicyPeerBuilder builder = new V1NetworkPolicyPeerBuilder(item);
        if (index < 0 || index >= this.from.size()) {
            this._visitables.get("from").add(builder);
            this.from.add(builder);
        } else {
            this._visitables.get("from").add(builder);
            this.from.set(index, builder);
        }
        return (A)this;
    }

    public A addToFrom(V1NetworkPolicyPeer ... items) {
        if (this.from == null) {
            this.from = new ArrayList();
        }
        for (V1NetworkPolicyPeer item : items) {
            V1NetworkPolicyPeerBuilder builder = new V1NetworkPolicyPeerBuilder(item);
            this._visitables.get("from").add(builder);
            this.from.add(builder);
        }
        return (A)this;
    }

    public A addAllToFrom(Collection<V1NetworkPolicyPeer> items) {
        if (this.from == null) {
            this.from = new ArrayList();
        }
        for (V1NetworkPolicyPeer item : items) {
            V1NetworkPolicyPeerBuilder builder = new V1NetworkPolicyPeerBuilder(item);
            this._visitables.get("from").add(builder);
            this.from.add(builder);
        }
        return (A)this;
    }

    public A removeFromFrom(V1NetworkPolicyPeer ... items) {
        if (this.from == null) {
            return (A)this;
        }
        for (V1NetworkPolicyPeer item : items) {
            V1NetworkPolicyPeerBuilder builder = new V1NetworkPolicyPeerBuilder(item);
            this._visitables.get("from").remove(builder);
            this.from.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromFrom(Collection<V1NetworkPolicyPeer> items) {
        if (this.from == null) {
            return (A)this;
        }
        for (V1NetworkPolicyPeer item : items) {
            V1NetworkPolicyPeerBuilder builder = new V1NetworkPolicyPeerBuilder(item);
            this._visitables.get("from").remove(builder);
            this.from.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromFrom(Predicate<V1NetworkPolicyPeerBuilder> predicate) {
        if (this.from == null) {
            return (A)this;
        }
        Iterator<V1NetworkPolicyPeerBuilder> each = this.from.iterator();
        Object visitables = this._visitables.get("from");
        while (each.hasNext()) {
            V1NetworkPolicyPeerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1NetworkPolicyPeer> buildFrom() {
        return this.from != null ? V1NetworkPolicyIngressRuleFluent.build(this.from) : null;
    }

    public V1NetworkPolicyPeer buildFrom(int index) {
        return this.from.get(index).build();
    }

    public V1NetworkPolicyPeer buildFirstFrom() {
        return this.from.get(0).build();
    }

    public V1NetworkPolicyPeer buildLastFrom() {
        return this.from.get(this.from.size() - 1).build();
    }

    public V1NetworkPolicyPeer buildMatchingFrom(Predicate<V1NetworkPolicyPeerBuilder> predicate) {
        for (V1NetworkPolicyPeerBuilder item : this.from) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingFrom(Predicate<V1NetworkPolicyPeerBuilder> predicate) {
        for (V1NetworkPolicyPeerBuilder item : this.from) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFrom(List<V1NetworkPolicyPeer> from) {
        if (this.from != null) {
            this._visitables.get("from").clear();
        }
        if (from != null) {
            this.from = new ArrayList();
            for (V1NetworkPolicyPeer item : from) {
                this.addToFrom(item);
            }
        } else {
            this.from = null;
        }
        return (A)this;
    }

    public A withFrom(V1NetworkPolicyPeer ... from) {
        if (this.from != null) {
            this.from.clear();
            this._visitables.remove("from");
        }
        if (from != null) {
            for (V1NetworkPolicyPeer item : from) {
                this.addToFrom(item);
            }
        }
        return (A)this;
    }

    public boolean hasFrom() {
        return this.from != null && !this.from.isEmpty();
    }

    public FromNested<A> addNewFrom() {
        return new FromNested(-1, null);
    }

    public FromNested<A> addNewFromLike(V1NetworkPolicyPeer item) {
        return new FromNested(-1, item);
    }

    public FromNested<A> setNewFromLike(int index, V1NetworkPolicyPeer item) {
        return new FromNested(index, item);
    }

    public FromNested<A> editFrom(int index) {
        if (this.from.size() <= index) {
            throw new RuntimeException("Can't edit from. Index exceeds size.");
        }
        return this.setNewFromLike(index, this.buildFrom(index));
    }

    public FromNested<A> editFirstFrom() {
        if (this.from.size() == 0) {
            throw new RuntimeException("Can't edit first from. The list is empty.");
        }
        return this.setNewFromLike(0, this.buildFrom(0));
    }

    public FromNested<A> editLastFrom() {
        int index = this.from.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last from. The list is empty.");
        }
        return this.setNewFromLike(index, this.buildFrom(index));
    }

    public FromNested<A> editMatchingFrom(Predicate<V1NetworkPolicyPeerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.from.size(); ++i) {
            if (!predicate.test(this.from.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching from. No match found.");
        }
        return this.setNewFromLike(index, this.buildFrom(index));
    }

    public A addToPorts(int index, V1NetworkPolicyPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        V1NetworkPolicyPortBuilder builder = new V1NetworkPolicyPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").add(builder);
            this.ports.add(index, builder);
        }
        return (A)this;
    }

    public A setToPorts(int index, V1NetworkPolicyPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        V1NetworkPolicyPortBuilder builder = new V1NetworkPolicyPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").add(builder);
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    public A addToPorts(V1NetworkPolicyPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (V1NetworkPolicyPort item : items) {
            V1NetworkPolicyPortBuilder builder = new V1NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    public A addAllToPorts(Collection<V1NetworkPolicyPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (V1NetworkPolicyPort item : items) {
            V1NetworkPolicyPortBuilder builder = new V1NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    public A removeFromPorts(V1NetworkPolicyPort ... items) {
        if (this.ports == null) {
            return (A)this;
        }
        for (V1NetworkPolicyPort item : items) {
            V1NetworkPolicyPortBuilder builder = new V1NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromPorts(Collection<V1NetworkPolicyPort> items) {
        if (this.ports == null) {
            return (A)this;
        }
        for (V1NetworkPolicyPort item : items) {
            V1NetworkPolicyPortBuilder builder = new V1NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPorts(Predicate<V1NetworkPolicyPortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<V1NetworkPolicyPortBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            V1NetworkPolicyPortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1NetworkPolicyPort> buildPorts() {
        return this.ports != null ? V1NetworkPolicyIngressRuleFluent.build(this.ports) : null;
    }

    public V1NetworkPolicyPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    public V1NetworkPolicyPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    public V1NetworkPolicyPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    public V1NetworkPolicyPort buildMatchingPort(Predicate<V1NetworkPolicyPortBuilder> predicate) {
        for (V1NetworkPolicyPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPort(Predicate<V1NetworkPolicyPortBuilder> predicate) {
        for (V1NetworkPolicyPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPorts(List<V1NetworkPolicyPort> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").clear();
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (V1NetworkPolicyPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    public A withPorts(V1NetworkPolicyPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
            this._visitables.remove("ports");
        }
        if (ports != null) {
            for (V1NetworkPolicyPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    public boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    public PortsNested<A> addNewPort() {
        return new PortsNested(-1, null);
    }

    public PortsNested<A> addNewPortLike(V1NetworkPolicyPort item) {
        return new PortsNested(-1, item);
    }

    public PortsNested<A> setNewPortLike(int index, V1NetworkPolicyPort item) {
        return new PortsNested(index, item);
    }

    public PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    public PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editMatchingPort(Predicate<V1NetworkPolicyPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1NetworkPolicyIngressRuleFluent that = (V1NetworkPolicyIngressRuleFluent)o;
        if (!Objects.equals(this.from, that.from)) {
            return false;
        }
        return Objects.equals(this.ports, that.ports);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.from, this.ports, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.from != null && !this.from.isEmpty()) {
            sb.append("from:");
            sb.append(String.valueOf(this.from) + ",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(this.ports);
        }
        sb.append("}");
        return sb.toString();
    }

    public class FromNested<N>
    extends V1NetworkPolicyPeerFluent<FromNested<N>>
    implements Nested<N> {
        V1NetworkPolicyPeerBuilder builder;
        int index;

        FromNested(int index, V1NetworkPolicyPeer item) {
            this.index = index;
            this.builder = new V1NetworkPolicyPeerBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1NetworkPolicyIngressRuleFluent.this.setToFrom(this.index, this.builder.build());
        }

        public N endFrom() {
            return this.and();
        }
    }

    public class PortsNested<N>
    extends V1NetworkPolicyPortFluent<PortsNested<N>>
    implements Nested<N> {
        V1NetworkPolicyPortBuilder builder;
        int index;

        PortsNested(int index, V1NetworkPolicyPort item) {
            this.index = index;
            this.builder = new V1NetworkPolicyPortBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1NetworkPolicyIngressRuleFluent.this.setToPorts(this.index, this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }
}

