/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1PodDNSConfig;
import io.kubernetes.client.openapi.models.V1PodDNSConfigOption;
import io.kubernetes.client.openapi.models.V1PodDNSConfigOptionBuilder;
import io.kubernetes.client.openapi.models.V1PodDNSConfigOptionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1PodDNSConfigFluent<A extends V1PodDNSConfigFluent<A>>
extends BaseFluent<A> {
    private List<String> nameservers;
    private ArrayList<V1PodDNSConfigOptionBuilder> options;
    private List<String> searches;

    public V1PodDNSConfigFluent() {
    }

    public V1PodDNSConfigFluent(V1PodDNSConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1PodDNSConfig instance) {
        V1PodDNSConfig v1PodDNSConfig = instance = instance != null ? instance : new V1PodDNSConfig();
        if (instance != null) {
            this.withNameservers(instance.getNameservers());
            this.withOptions(instance.getOptions());
            this.withSearches(instance.getSearches());
        }
    }

    public A addToNameservers(int index, String item) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        this.nameservers.add(index, item);
        return (A)this;
    }

    public A setToNameservers(int index, String item) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        this.nameservers.set(index, item);
        return (A)this;
    }

    public A addToNameservers(String ... items) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameservers.add(item);
        }
        return (A)this;
    }

    public A addAllToNameservers(Collection<String> items) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameservers.add(item);
        }
        return (A)this;
    }

    public A removeFromNameservers(String ... items) {
        if (this.nameservers == null) {
            return (A)this;
        }
        for (String item : items) {
            this.nameservers.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromNameservers(Collection<String> items) {
        if (this.nameservers == null) {
            return (A)this;
        }
        for (String item : items) {
            this.nameservers.remove(item);
        }
        return (A)this;
    }

    public List<String> getNameservers() {
        return this.nameservers;
    }

    public String getNameserver(int index) {
        return this.nameservers.get(index);
    }

    public String getFirstNameserver() {
        return this.nameservers.get(0);
    }

    public String getLastNameserver() {
        return this.nameservers.get(this.nameservers.size() - 1);
    }

    public String getMatchingNameserver(Predicate<String> predicate) {
        for (String item : this.nameservers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingNameserver(Predicate<String> predicate) {
        for (String item : this.nameservers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNameservers(List<String> nameservers) {
        if (nameservers != null) {
            this.nameservers = new ArrayList<String>();
            for (String item : nameservers) {
                this.addToNameservers(item);
            }
        } else {
            this.nameservers = null;
        }
        return (A)this;
    }

    public A withNameservers(String ... nameservers) {
        if (this.nameservers != null) {
            this.nameservers.clear();
            this._visitables.remove("nameservers");
        }
        if (nameservers != null) {
            for (String item : nameservers) {
                this.addToNameservers(item);
            }
        }
        return (A)this;
    }

    public boolean hasNameservers() {
        return this.nameservers != null && !this.nameservers.isEmpty();
    }

    public A addToOptions(int index, V1PodDNSConfigOption item) {
        if (this.options == null) {
            this.options = new ArrayList();
        }
        V1PodDNSConfigOptionBuilder builder = new V1PodDNSConfigOptionBuilder(item);
        if (index < 0 || index >= this.options.size()) {
            this._visitables.get("options").add(builder);
            this.options.add(builder);
        } else {
            this._visitables.get("options").add(index, builder);
            this.options.add(index, builder);
        }
        return (A)this;
    }

    public A setToOptions(int index, V1PodDNSConfigOption item) {
        if (this.options == null) {
            this.options = new ArrayList();
        }
        V1PodDNSConfigOptionBuilder builder = new V1PodDNSConfigOptionBuilder(item);
        if (index < 0 || index >= this.options.size()) {
            this._visitables.get("options").add(builder);
            this.options.add(builder);
        } else {
            this._visitables.get("options").set(index, builder);
            this.options.set(index, builder);
        }
        return (A)this;
    }

    public A addToOptions(V1PodDNSConfigOption ... items) {
        if (this.options == null) {
            this.options = new ArrayList();
        }
        for (V1PodDNSConfigOption item : items) {
            V1PodDNSConfigOptionBuilder builder = new V1PodDNSConfigOptionBuilder(item);
            this._visitables.get("options").add(builder);
            this.options.add(builder);
        }
        return (A)this;
    }

    public A addAllToOptions(Collection<V1PodDNSConfigOption> items) {
        if (this.options == null) {
            this.options = new ArrayList();
        }
        for (V1PodDNSConfigOption item : items) {
            V1PodDNSConfigOptionBuilder builder = new V1PodDNSConfigOptionBuilder(item);
            this._visitables.get("options").add(builder);
            this.options.add(builder);
        }
        return (A)this;
    }

    public A removeFromOptions(V1PodDNSConfigOption ... items) {
        if (this.options == null) {
            return (A)this;
        }
        for (V1PodDNSConfigOption item : items) {
            V1PodDNSConfigOptionBuilder builder = new V1PodDNSConfigOptionBuilder(item);
            this._visitables.get("options").remove(builder);
            this.options.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromOptions(Collection<V1PodDNSConfigOption> items) {
        if (this.options == null) {
            return (A)this;
        }
        for (V1PodDNSConfigOption item : items) {
            V1PodDNSConfigOptionBuilder builder = new V1PodDNSConfigOptionBuilder(item);
            this._visitables.get("options").remove(builder);
            this.options.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromOptions(Predicate<V1PodDNSConfigOptionBuilder> predicate) {
        if (this.options == null) {
            return (A)this;
        }
        Iterator<V1PodDNSConfigOptionBuilder> each = this.options.iterator();
        Object visitables = this._visitables.get("options");
        while (each.hasNext()) {
            V1PodDNSConfigOptionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1PodDNSConfigOption> buildOptions() {
        return this.options != null ? V1PodDNSConfigFluent.build(this.options) : null;
    }

    public V1PodDNSConfigOption buildOption(int index) {
        return this.options.get(index).build();
    }

    public V1PodDNSConfigOption buildFirstOption() {
        return this.options.get(0).build();
    }

    public V1PodDNSConfigOption buildLastOption() {
        return this.options.get(this.options.size() - 1).build();
    }

    public V1PodDNSConfigOption buildMatchingOption(Predicate<V1PodDNSConfigOptionBuilder> predicate) {
        for (V1PodDNSConfigOptionBuilder item : this.options) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingOption(Predicate<V1PodDNSConfigOptionBuilder> predicate) {
        for (V1PodDNSConfigOptionBuilder item : this.options) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOptions(List<V1PodDNSConfigOption> options) {
        if (this.options != null) {
            this._visitables.get("options").clear();
        }
        if (options != null) {
            this.options = new ArrayList();
            for (V1PodDNSConfigOption item : options) {
                this.addToOptions(item);
            }
        } else {
            this.options = null;
        }
        return (A)this;
    }

    public A withOptions(V1PodDNSConfigOption ... options) {
        if (this.options != null) {
            this.options.clear();
            this._visitables.remove("options");
        }
        if (options != null) {
            for (V1PodDNSConfigOption item : options) {
                this.addToOptions(item);
            }
        }
        return (A)this;
    }

    public boolean hasOptions() {
        return this.options != null && !this.options.isEmpty();
    }

    public OptionsNested<A> addNewOption() {
        return new OptionsNested(-1, null);
    }

    public OptionsNested<A> addNewOptionLike(V1PodDNSConfigOption item) {
        return new OptionsNested(-1, item);
    }

    public OptionsNested<A> setNewOptionLike(int index, V1PodDNSConfigOption item) {
        return new OptionsNested(index, item);
    }

    public OptionsNested<A> editOption(int index) {
        if (this.options.size() <= index) {
            throw new RuntimeException("Can't edit options. Index exceeds size.");
        }
        return this.setNewOptionLike(index, this.buildOption(index));
    }

    public OptionsNested<A> editFirstOption() {
        if (this.options.size() == 0) {
            throw new RuntimeException("Can't edit first options. The list is empty.");
        }
        return this.setNewOptionLike(0, this.buildOption(0));
    }

    public OptionsNested<A> editLastOption() {
        int index = this.options.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last options. The list is empty.");
        }
        return this.setNewOptionLike(index, this.buildOption(index));
    }

    public OptionsNested<A> editMatchingOption(Predicate<V1PodDNSConfigOptionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.options.size(); ++i) {
            if (!predicate.test(this.options.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching options. No match found.");
        }
        return this.setNewOptionLike(index, this.buildOption(index));
    }

    public A addToSearches(int index, String item) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        this.searches.add(index, item);
        return (A)this;
    }

    public A setToSearches(int index, String item) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        this.searches.set(index, item);
        return (A)this;
    }

    public A addToSearches(String ... items) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        for (String item : items) {
            this.searches.add(item);
        }
        return (A)this;
    }

    public A addAllToSearches(Collection<String> items) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        for (String item : items) {
            this.searches.add(item);
        }
        return (A)this;
    }

    public A removeFromSearches(String ... items) {
        if (this.searches == null) {
            return (A)this;
        }
        for (String item : items) {
            this.searches.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromSearches(Collection<String> items) {
        if (this.searches == null) {
            return (A)this;
        }
        for (String item : items) {
            this.searches.remove(item);
        }
        return (A)this;
    }

    public List<String> getSearches() {
        return this.searches;
    }

    public String getSearch(int index) {
        return this.searches.get(index);
    }

    public String getFirstSearch() {
        return this.searches.get(0);
    }

    public String getLastSearch() {
        return this.searches.get(this.searches.size() - 1);
    }

    public String getMatchingSearch(Predicate<String> predicate) {
        for (String item : this.searches) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSearch(Predicate<String> predicate) {
        for (String item : this.searches) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSearches(List<String> searches) {
        if (searches != null) {
            this.searches = new ArrayList<String>();
            for (String item : searches) {
                this.addToSearches(item);
            }
        } else {
            this.searches = null;
        }
        return (A)this;
    }

    public A withSearches(String ... searches) {
        if (this.searches != null) {
            this.searches.clear();
            this._visitables.remove("searches");
        }
        if (searches != null) {
            for (String item : searches) {
                this.addToSearches(item);
            }
        }
        return (A)this;
    }

    public boolean hasSearches() {
        return this.searches != null && !this.searches.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1PodDNSConfigFluent that = (V1PodDNSConfigFluent)o;
        if (!Objects.equals(this.nameservers, that.nameservers)) {
            return false;
        }
        if (!Objects.equals(this.options, that.options)) {
            return false;
        }
        return Objects.equals(this.searches, that.searches);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nameservers, this.options, this.searches, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nameservers != null && !this.nameservers.isEmpty()) {
            sb.append("nameservers:");
            sb.append(this.nameservers + ",");
        }
        if (this.options != null && !this.options.isEmpty()) {
            sb.append("options:");
            sb.append(this.options + ",");
        }
        if (this.searches != null && !this.searches.isEmpty()) {
            sb.append("searches:");
            sb.append(this.searches);
        }
        sb.append("}");
        return sb.toString();
    }

    public class OptionsNested<N>
    extends V1PodDNSConfigOptionFluent<OptionsNested<N>>
    implements Nested<N> {
        V1PodDNSConfigOptionBuilder builder;
        int index;

        OptionsNested(int index, V1PodDNSConfigOption item) {
            this.index = index;
            this.builder = new V1PodDNSConfigOptionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodDNSConfigFluent.this.setToOptions(this.index, this.builder.build());
        }

        public N endOption() {
            return this.and();
        }
    }
}

