/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1IngressBackend;
import io.kubernetes.client.openapi.models.V1IngressServiceBackend;
import io.kubernetes.client.openapi.models.V1IngressServiceBackendBuilder;
import io.kubernetes.client.openapi.models.V1IngressServiceBackendFluent;
import io.kubernetes.client.openapi.models.V1TypedLocalObjectReference;
import io.kubernetes.client.openapi.models.V1TypedLocalObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V1TypedLocalObjectReferenceFluent;
import java.util.Objects;
import java.util.Optional;

public class V1IngressBackendFluent<A extends V1IngressBackendFluent<A>>
extends BaseFluent<A> {
    private V1TypedLocalObjectReferenceBuilder resource;
    private V1IngressServiceBackendBuilder service;

    public V1IngressBackendFluent() {
    }

    public V1IngressBackendFluent(V1IngressBackend instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1IngressBackend instance) {
        V1IngressBackend v1IngressBackend = instance = instance != null ? instance : new V1IngressBackend();
        if (instance != null) {
            this.withResource(instance.getResource());
            this.withService(instance.getService());
        }
    }

    public V1TypedLocalObjectReference buildResource() {
        return this.resource != null ? this.resource.build() : null;
    }

    public A withResource(V1TypedLocalObjectReference resource) {
        this._visitables.remove("resource");
        if (resource != null) {
            this.resource = new V1TypedLocalObjectReferenceBuilder(resource);
            this._visitables.get("resource").add(this.resource);
        } else {
            this.resource = null;
            this._visitables.get("resource").remove(this.resource);
        }
        return (A)this;
    }

    public boolean hasResource() {
        return this.resource != null;
    }

    public ResourceNested<A> withNewResource() {
        return new ResourceNested(null);
    }

    public ResourceNested<A> withNewResourceLike(V1TypedLocalObjectReference item) {
        return new ResourceNested(item);
    }

    public ResourceNested<A> editResource() {
        return this.withNewResourceLike(Optional.ofNullable(this.buildResource()).orElse(null));
    }

    public ResourceNested<A> editOrNewResource() {
        return this.withNewResourceLike(Optional.ofNullable(this.buildResource()).orElse(new V1TypedLocalObjectReferenceBuilder().build()));
    }

    public ResourceNested<A> editOrNewResourceLike(V1TypedLocalObjectReference item) {
        return this.withNewResourceLike(Optional.ofNullable(this.buildResource()).orElse(item));
    }

    public V1IngressServiceBackend buildService() {
        return this.service != null ? this.service.build() : null;
    }

    public A withService(V1IngressServiceBackend service) {
        this._visitables.remove("service");
        if (service != null) {
            this.service = new V1IngressServiceBackendBuilder(service);
            this._visitables.get("service").add(this.service);
        } else {
            this.service = null;
            this._visitables.get("service").remove(this.service);
        }
        return (A)this;
    }

    public boolean hasService() {
        return this.service != null;
    }

    public ServiceNested<A> withNewService() {
        return new ServiceNested(null);
    }

    public ServiceNested<A> withNewServiceLike(V1IngressServiceBackend item) {
        return new ServiceNested(item);
    }

    public ServiceNested<A> editService() {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(null));
    }

    public ServiceNested<A> editOrNewService() {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(new V1IngressServiceBackendBuilder().build()));
    }

    public ServiceNested<A> editOrNewServiceLike(V1IngressServiceBackend item) {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1IngressBackendFluent that = (V1IngressBackendFluent)o;
        if (!Objects.equals(this.resource, that.resource)) {
            return false;
        }
        return Objects.equals(this.service, that.service);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.resource, this.service, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resource != null) {
            sb.append("resource:");
            sb.append(this.resource + ",");
        }
        if (this.service != null) {
            sb.append("service:");
            sb.append(this.service);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResourceNested<N>
    extends V1TypedLocalObjectReferenceFluent<ResourceNested<N>>
    implements Nested<N> {
        V1TypedLocalObjectReferenceBuilder builder;

        ResourceNested(V1TypedLocalObjectReference item) {
            this.builder = new V1TypedLocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1IngressBackendFluent.this.withResource(this.builder.build());
        }

        public N endResource() {
            return this.and();
        }
    }

    public class ServiceNested<N>
    extends V1IngressServiceBackendFluent<ServiceNested<N>>
    implements Nested<N> {
        V1IngressServiceBackendBuilder builder;

        ServiceNested(V1IngressServiceBackend item) {
            this.builder = new V1IngressServiceBackendBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1IngressBackendFluent.this.withService(this.builder.build());
        }

        public N endService() {
            return this.and();
        }
    }
}

