/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1beta3LimitResponse;
import io.kubernetes.client.openapi.models.V1beta3LimitResponseBuilder;
import io.kubernetes.client.openapi.models.V1beta3LimitResponseFluentImpl;
import io.kubernetes.client.openapi.models.V1beta3LimitedPriorityLevelConfiguration;
import io.kubernetes.client.openapi.models.V1beta3LimitedPriorityLevelConfigurationFluent;
import java.util.Objects;

public class V1beta3LimitedPriorityLevelConfigurationFluentImpl<A extends V1beta3LimitedPriorityLevelConfigurationFluent<A>>
extends BaseFluent<A>
implements V1beta3LimitedPriorityLevelConfigurationFluent<A> {
    private Integer borrowingLimitPercent;
    private Integer lendablePercent;
    private V1beta3LimitResponseBuilder limitResponse;
    private Integer nominalConcurrencyShares;

    public V1beta3LimitedPriorityLevelConfigurationFluentImpl() {
    }

    public V1beta3LimitedPriorityLevelConfigurationFluentImpl(V1beta3LimitedPriorityLevelConfiguration instance) {
        if (instance != null) {
            this.withBorrowingLimitPercent(instance.getBorrowingLimitPercent());
            this.withLendablePercent(instance.getLendablePercent());
            this.withLimitResponse(instance.getLimitResponse());
            this.withNominalConcurrencyShares(instance.getNominalConcurrencyShares());
        }
    }

    @Override
    public Integer getBorrowingLimitPercent() {
        return this.borrowingLimitPercent;
    }

    @Override
    public A withBorrowingLimitPercent(Integer borrowingLimitPercent) {
        this.borrowingLimitPercent = borrowingLimitPercent;
        return (A)this;
    }

    @Override
    public Boolean hasBorrowingLimitPercent() {
        return this.borrowingLimitPercent != null;
    }

    @Override
    public Integer getLendablePercent() {
        return this.lendablePercent;
    }

    @Override
    public A withLendablePercent(Integer lendablePercent) {
        this.lendablePercent = lendablePercent;
        return (A)this;
    }

    @Override
    public Boolean hasLendablePercent() {
        return this.lendablePercent != null;
    }

    @Override
    @Deprecated
    public V1beta3LimitResponse getLimitResponse() {
        return this.limitResponse != null ? this.limitResponse.build() : null;
    }

    @Override
    public V1beta3LimitResponse buildLimitResponse() {
        return this.limitResponse != null ? this.limitResponse.build() : null;
    }

    @Override
    public A withLimitResponse(V1beta3LimitResponse limitResponse) {
        this._visitables.get("limitResponse").remove(this.limitResponse);
        if (limitResponse != null) {
            this.limitResponse = new V1beta3LimitResponseBuilder(limitResponse);
            this._visitables.get("limitResponse").add(this.limitResponse);
        } else {
            this.limitResponse = null;
            this._visitables.get("limitResponse").remove(this.limitResponse);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLimitResponse() {
        return this.limitResponse != null;
    }

    @Override
    public V1beta3LimitedPriorityLevelConfigurationFluent.LimitResponseNested<A> withNewLimitResponse() {
        return new LimitResponseNestedImpl();
    }

    @Override
    public V1beta3LimitedPriorityLevelConfigurationFluent.LimitResponseNested<A> withNewLimitResponseLike(V1beta3LimitResponse item) {
        return new LimitResponseNestedImpl(item);
    }

    @Override
    public V1beta3LimitedPriorityLevelConfigurationFluent.LimitResponseNested<A> editLimitResponse() {
        return this.withNewLimitResponseLike(this.getLimitResponse());
    }

    @Override
    public V1beta3LimitedPriorityLevelConfigurationFluent.LimitResponseNested<A> editOrNewLimitResponse() {
        return this.withNewLimitResponseLike(this.getLimitResponse() != null ? this.getLimitResponse() : new V1beta3LimitResponseBuilder().build());
    }

    @Override
    public V1beta3LimitedPriorityLevelConfigurationFluent.LimitResponseNested<A> editOrNewLimitResponseLike(V1beta3LimitResponse item) {
        return this.withNewLimitResponseLike(this.getLimitResponse() != null ? this.getLimitResponse() : item);
    }

    @Override
    public Integer getNominalConcurrencyShares() {
        return this.nominalConcurrencyShares;
    }

    @Override
    public A withNominalConcurrencyShares(Integer nominalConcurrencyShares) {
        this.nominalConcurrencyShares = nominalConcurrencyShares;
        return (A)this;
    }

    @Override
    public Boolean hasNominalConcurrencyShares() {
        return this.nominalConcurrencyShares != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1beta3LimitedPriorityLevelConfigurationFluentImpl that = (V1beta3LimitedPriorityLevelConfigurationFluentImpl)o;
        if (!Objects.equals(this.borrowingLimitPercent, that.borrowingLimitPercent)) {
            return false;
        }
        if (!Objects.equals(this.lendablePercent, that.lendablePercent)) {
            return false;
        }
        if (!Objects.equals(this.limitResponse, that.limitResponse)) {
            return false;
        }
        return Objects.equals(this.nominalConcurrencyShares, that.nominalConcurrencyShares);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.borrowingLimitPercent, this.lendablePercent, this.limitResponse, this.nominalConcurrencyShares, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.borrowingLimitPercent != null) {
            sb.append("borrowingLimitPercent:");
            sb.append(this.borrowingLimitPercent + ",");
        }
        if (this.lendablePercent != null) {
            sb.append("lendablePercent:");
            sb.append(this.lendablePercent + ",");
        }
        if (this.limitResponse != null) {
            sb.append("limitResponse:");
            sb.append(this.limitResponse + ",");
        }
        if (this.nominalConcurrencyShares != null) {
            sb.append("nominalConcurrencyShares:");
            sb.append(this.nominalConcurrencyShares);
        }
        sb.append("}");
        return sb.toString();
    }

    class LimitResponseNestedImpl<N>
    extends V1beta3LimitResponseFluentImpl<V1beta3LimitedPriorityLevelConfigurationFluent.LimitResponseNested<N>>
    implements V1beta3LimitedPriorityLevelConfigurationFluent.LimitResponseNested<N>,
    Nested<N> {
        V1beta3LimitResponseBuilder builder;

        LimitResponseNestedImpl(V1beta3LimitResponse item) {
            this.builder = new V1beta3LimitResponseBuilder(this, item);
        }

        LimitResponseNestedImpl() {
            this.builder = new V1beta3LimitResponseBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta3LimitedPriorityLevelConfigurationFluentImpl.this.withLimitResponse(this.builder.build());
        }

        @Override
        public N endLimitResponse() {
            return this.and();
        }
    }
}

