/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1APIGroup;
import io.kubernetes.client.openapi.models.V1APIGroupBuilder;
import io.kubernetes.client.openapi.models.V1APIGroupFluentImpl;
import io.kubernetes.client.openapi.models.V1APIGroupList;
import io.kubernetes.client.openapi.models.V1APIGroupListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1APIGroupListFluentImpl<A extends V1APIGroupListFluent<A>>
extends BaseFluent<A>
implements V1APIGroupListFluent<A> {
    private String apiVersion;
    private ArrayList<V1APIGroupBuilder> groups;
    private String kind;

    public V1APIGroupListFluentImpl() {
    }

    public V1APIGroupListFluentImpl(V1APIGroupList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withGroups(instance.getGroups());
        this.withKind(instance.getKind());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToGroups(Integer index, V1APIGroup item) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        V1APIGroupBuilder builder = new V1APIGroupBuilder(item);
        this._visitables.get("groups").add(index >= 0 ? index.intValue() : this._visitables.get("groups").size(), builder);
        this.groups.add(index >= 0 ? index.intValue() : this.groups.size(), builder);
        return (A)this;
    }

    @Override
    public A setToGroups(Integer index, V1APIGroup item) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        V1APIGroupBuilder builder = new V1APIGroupBuilder(item);
        if (index < 0 || index >= this._visitables.get("groups").size()) {
            this._visitables.get("groups").add(builder);
        } else {
            this._visitables.get("groups").set(index, builder);
        }
        if (index < 0 || index >= this.groups.size()) {
            this.groups.add(builder);
        } else {
            this.groups.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToGroups(V1APIGroup ... items) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        for (V1APIGroup item : items) {
            V1APIGroupBuilder builder = new V1APIGroupBuilder(item);
            this._visitables.get("groups").add(builder);
            this.groups.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToGroups(Collection<V1APIGroup> items) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        for (V1APIGroup item : items) {
            V1APIGroupBuilder builder = new V1APIGroupBuilder(item);
            this._visitables.get("groups").add(builder);
            this.groups.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroups(V1APIGroup ... items) {
        for (V1APIGroup item : items) {
            V1APIGroupBuilder builder = new V1APIGroupBuilder(item);
            this._visitables.get("groups").remove(builder);
            if (this.groups == null) continue;
            this.groups.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGroups(Collection<V1APIGroup> items) {
        for (V1APIGroup item : items) {
            V1APIGroupBuilder builder = new V1APIGroupBuilder(item);
            this._visitables.get("groups").remove(builder);
            if (this.groups == null) continue;
            this.groups.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromGroups(Predicate<V1APIGroupBuilder> predicate) {
        if (this.groups == null) {
            return (A)this;
        }
        Iterator<V1APIGroupBuilder> each = this.groups.iterator();
        Object visitables = this._visitables.get("groups");
        while (each.hasNext()) {
            V1APIGroupBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1APIGroup> getGroups() {
        return this.groups != null ? V1APIGroupListFluentImpl.build(this.groups) : null;
    }

    @Override
    public List<V1APIGroup> buildGroups() {
        return this.groups != null ? V1APIGroupListFluentImpl.build(this.groups) : null;
    }

    @Override
    public V1APIGroup buildGroup(Integer index) {
        return this.groups.get(index).build();
    }

    @Override
    public V1APIGroup buildFirstGroup() {
        return this.groups.get(0).build();
    }

    @Override
    public V1APIGroup buildLastGroup() {
        return this.groups.get(this.groups.size() - 1).build();
    }

    @Override
    public V1APIGroup buildMatchingGroup(Predicate<V1APIGroupBuilder> predicate) {
        for (V1APIGroupBuilder item : this.groups) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingGroup(Predicate<V1APIGroupBuilder> predicate) {
        for (V1APIGroupBuilder item : this.groups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withGroups(List<V1APIGroup> groups) {
        if (this.groups != null) {
            this._visitables.get("groups").removeAll(this.groups);
        }
        if (groups != null) {
            this.groups = new ArrayList();
            for (V1APIGroup item : groups) {
                this.addToGroups(item);
            }
        } else {
            this.groups = null;
        }
        return (A)this;
    }

    @Override
    public A withGroups(V1APIGroup ... groups) {
        if (this.groups != null) {
            this.groups.clear();
        }
        if (groups != null) {
            for (V1APIGroup item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    @Override
    public V1APIGroupListFluent.GroupsNested<A> addNewGroup() {
        return new GroupsNestedImpl();
    }

    @Override
    public V1APIGroupListFluent.GroupsNested<A> addNewGroupLike(V1APIGroup item) {
        return new GroupsNestedImpl(-1, item);
    }

    @Override
    public V1APIGroupListFluent.GroupsNested<A> setNewGroupLike(Integer index, V1APIGroup item) {
        return new GroupsNestedImpl(index, item);
    }

    @Override
    public V1APIGroupListFluent.GroupsNested<A> editGroup(Integer index) {
        if (this.groups.size() <= index) {
            throw new RuntimeException("Can't edit groups. Index exceeds size.");
        }
        return this.setNewGroupLike(index, this.buildGroup(index));
    }

    @Override
    public V1APIGroupListFluent.GroupsNested<A> editFirstGroup() {
        if (this.groups.size() == 0) {
            throw new RuntimeException("Can't edit first groups. The list is empty.");
        }
        return this.setNewGroupLike(0, this.buildGroup(0));
    }

    @Override
    public V1APIGroupListFluent.GroupsNested<A> editLastGroup() {
        int index = this.groups.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last groups. The list is empty.");
        }
        return this.setNewGroupLike(index, this.buildGroup(index));
    }

    @Override
    public V1APIGroupListFluent.GroupsNested<A> editMatchingGroup(Predicate<V1APIGroupBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.groups.size(); ++i) {
            if (!predicate.test(this.groups.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching groups. No match found.");
        }
        return this.setNewGroupLike(index, this.buildGroup(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1APIGroupListFluentImpl that = (V1APIGroupListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        return !(this.kind != null ? !this.kind.equals(that.kind) : that.kind != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.groups, this.kind, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.groups != null && !this.groups.isEmpty()) {
            sb.append("groups:");
            sb.append(this.groups + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
        }
        sb.append("}");
        return sb.toString();
    }

    class GroupsNestedImpl<N>
    extends V1APIGroupFluentImpl<V1APIGroupListFluent.GroupsNested<N>>
    implements V1APIGroupListFluent.GroupsNested<N>,
    Nested<N> {
        V1APIGroupBuilder builder;
        Integer index;

        GroupsNestedImpl(Integer index, V1APIGroup item) {
            this.index = index;
            this.builder = new V1APIGroupBuilder(this, item);
        }

        GroupsNestedImpl() {
            this.index = -1;
            this.builder = new V1APIGroupBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1APIGroupListFluentImpl.this.setToGroups(this.index, this.builder.build());
        }

        @Override
        public N endGroup() {
            return this.and();
        }
    }
}

