/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.http1;

import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMethod;
import io.ktor.http.RequestConnectionPoint;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000f\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u0019\u001a\u00020\n8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001a\u0010\fR\u0014\u0010\u001d\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\fR\u0014\u0010\u001f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\f\u00a8\u0006!"}, d2={"Lio/ktor/server/netty/http1/NettyConnectionPoint;", "Lio/ktor/http/RequestConnectionPoint;", "request", "Lio/netty/handler/codec/http/HttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "(Lio/netty/handler/codec/http/HttpRequest;Lio/netty/channel/ChannelHandlerContext;)V", "getContext", "()Lio/netty/channel/ChannelHandlerContext;", "host", "", "getHost", "()Ljava/lang/String;", "method", "Lio/ktor/http/HttpMethod;", "getMethod", "()Lio/ktor/http/HttpMethod;", "port", "", "getPort", "()I", "remoteHost", "getRemoteHost", "getRequest", "()Lio/netty/handler/codec/http/HttpRequest;", "scheme", "getScheme", "scheme$delegate", "Lkotlin/Lazy;", "uri", "getUri", "version", "getVersion", "ktor-server-netty"})
public final class NettyConnectionPoint
implements RequestConnectionPoint {
    @NotNull
    private final Lazy scheme$delegate;
    @NotNull
    private final HttpRequest request;
    @NotNull
    private final ChannelHandlerContext context;

    @NotNull
    public String getVersion() {
        String string = this.request.protocolVersion().text();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"request.protocolVersion().text()");
        return string;
    }

    @NotNull
    public String getUri() {
        String string = this.request.uri();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"request.uri()");
        return string;
    }

    @NotNull
    public HttpMethod getMethod() {
        String string = this.request.method().name();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"request.method().name()");
        return HttpMethod.Companion.parse(string);
    }

    @NotNull
    public String getScheme() {
        Lazy lazy = this.scheme$delegate;
        NettyConnectionPoint nettyConnectionPoint = this;
        Object var3_3 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @NotNull
    public String getHost() {
        String string;
        String string2 = this.request.headers().get(HttpHeaders.INSTANCE.getHost());
        if (string2 == null || (string2 = StringsKt.substringBefore$default((String)string2, (String)":", null, (int)2, null)) == null) {
            SocketAddress socketAddress = this.context.channel().localAddress();
            if (!(socketAddress instanceof InetSocketAddress)) {
                socketAddress = null;
            }
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            if (inetSocketAddress != null) {
                InetSocketAddress inetSocketAddress2 = inetSocketAddress;
                boolean bl = false;
                boolean bl2 = false;
                InetSocketAddress it = inetSocketAddress2;
                boolean bl3 = false;
                string2 = it.getHostName();
                if (string2 == null) {
                    InetAddress inetAddress = it.getAddress();
                    Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress, (String)"it.address");
                    string2 = inetAddress.getHostAddress();
                }
            } else {
                string2 = string = null;
            }
        }
        if (string2 == null) {
            string = "localhost";
        }
        return string;
    }

    public int getPort() {
        SocketAddress socketAddress = this.context.channel().localAddress();
        if (!(socketAddress instanceof InetSocketAddress)) {
            socketAddress = null;
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        return inetSocketAddress != null ? inetSocketAddress.getPort() : 80;
    }

    @NotNull
    public String getRemoteHost() {
        Object object;
        block6: {
            block5: {
                SocketAddress socketAddress = this.context.channel().remoteAddress();
                if (!(socketAddress instanceof InetSocketAddress)) {
                    socketAddress = null;
                }
                if ((object = (InetSocketAddress)socketAddress) == null) break block5;
                InetSocketAddress inetSocketAddress = object;
                boolean bl = false;
                boolean bl2 = false;
                InetSocketAddress it = inetSocketAddress;
                boolean bl3 = false;
                Object object2 = it.getHostName();
                if (object2 == null) {
                    InetAddress inetAddress = it.getAddress();
                    Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress, (String)"it.address");
                    object2 = object = inetAddress.getHostAddress();
                }
                if (object2 != null) break block6;
            }
            object = "unknown";
        }
        return object;
    }

    @NotNull
    public final HttpRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final ChannelHandlerContext getContext() {
        return this.context;
    }

    public NettyConnectionPoint(@NotNull HttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.request = request;
        this.context = context;
        this.scheme$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NettyConnectionPoint this$0;

            @NotNull
            public final String invoke() {
                return this.this$0.getContext().pipeline().context("ssl") == null ? "http" : "https";
            }
            {
                this.this$0 = nettyConnectionPoint;
                super(0);
            }
        }));
    }
}

