/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import io.ktor.application.ApplicationEnvironment;
import io.ktor.config.ApplicationConfig;
import io.ktor.config.HoconApplicationConfig;
import io.ktor.config.HoconApplicationConfigKt;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.ApplicationEngineEnvironmentBuilder;
import io.ktor.server.engine.ApplicationEngineEnvironmentKt;
import io.ktor.server.engine.BaseApplicationEngine;
import io.ktor.server.engine.EngineConnectorBuilder;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineSSLConnectorBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\u001a\u0019\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\"\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\f*\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"commandLineEnvironment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "args", "", "", "([Ljava/lang/String;)Lio/ktor/server/engine/ApplicationEngineEnvironment;", "loadCommonConfiguration", "", "Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "deploymentConfig", "Lio/ktor/config/ApplicationConfig;", "splitPair", "Lkotlin/Pair;", "ch", "", "ktor-server-host-common"})
public final class CommandLineKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ApplicationEngineEnvironment commandLineEnvironment(@NotNull String[] args) {
        Object it;
        void $receiver$iv$iv;
        File file;
        String it2;
        Object it$iv$iv;
        String it3;
        String $receiver$iv$iv2;
        String[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        String[] stringArray = $receiver$iv = args;
        Collection destination$iv$iv = new ArrayList();
        for (Iterator element$iv$iv$iv : $receiver$iv$iv2) {
            Pair<String, String> pair;
            Iterator element$iv$iv = element$iv$iv$iv;
            it3 = element$iv$iv;
            if (CommandLineKt.splitPair(it3, '=') == null) continue;
            it$iv$iv = pair;
            destination$iv$iv.add(it$iv$iv);
        }
        Map argsMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        String string = (String)argsMap.get("-jar");
        URL jar = string != null ? (StringsKt.startsWith$default((String)(it2 = ($receiver$iv$iv2 = string)), (String)"file:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it2, (String)"jrt:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it2, (String)"jar:", (boolean)false, (int)2, null) ? new URI(it2).toURL() : new File(it2).toURI().toURL()) : null;
        String string2 = (String)argsMap.get("-config");
        if (string2 != null) {
            String it4 = it2 = string2;
            file = new File(it4);
        } else {
            file = null;
        }
        File configFile = file;
        Map $receiver$iv2 = argsMap;
        Map result$iv = new LinkedHashMap();
        Map map = $receiver$iv2;
        for (Map.Entry entry$iv : map.entrySet()) {
            it3 = (String)entry$iv.getKey();
            if (!StringsKt.startsWith$default((String)it3, (String)"-P:", (boolean)false, (int)2, null)) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        $receiver$iv2 = result$iv;
        result$iv = $receiver$iv2;
        Object destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv2.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void it5;
            Map.Entry $i$a$1$filterKeys = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv2;
            String string3 = StringsKt.removePrefix((String)((String)it5.getKey()), (CharSequence)"-P:");
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            String $i$a$1$let = string3;
            Map $i$a$1$forEach = map2;
            Object $i$f$forEach = it$iv$iv.getValue();
            $i$a$1$forEach.put($i$a$1$let, $i$f$forEach);
        }
        Map commandLineMap = destination$iv$iv2;
        Config environmentConfig = ConfigFactory.systemProperties().withOnlyPath("ktor");
        File file2 = configFile;
        if (file2 == null || (file2 = ConfigFactory.parseFile((File)(it = (destination$iv$iv2 = file2)))) == null) {
            file2 = ConfigFactory.load();
        }
        File fileConfig = file2;
        Config argConfig = ConfigFactory.parseMap((Map)commandLineMap, (String)"Command-line options");
        Config combinedConfig = argConfig.withFallback((ConfigMergeable)fileConfig).withFallback((ConfigMergeable)environmentConfig).resolve();
        String applicationIdPath = "ktor.application.id";
        String hostConfigPath = "ktor.deployment.host";
        String hostPortPath = "ktor.deployment.port";
        String hostWatchPaths = "ktor.deployment.watch";
        String hostSslPortPath = "ktor.deployment.sslPort";
        String hostSslKeyStore = "ktor.security.ssl.keyStore";
        String hostSslKeyAlias = "ktor.security.ssl.keyAlias";
        String hostSslKeyStorePassword = "ktor.security.ssl.keyStorePassword";
        String hostSslPrivateKeyPassword = "ktor.security.ssl.privateKeyPassword";
        Config config = combinedConfig;
        Intrinsics.checkExpressionValueIsNotNull((Object)config, (String)"combinedConfig");
        String string4 = HoconApplicationConfigKt.tryGetString((Config)config, (String)applicationIdPath);
        if (string4 == null) {
            string4 = "Application";
        }
        String applicationId = string4;
        Logger appLog = LoggerFactory.getLogger((String)applicationId);
        if (configFile != null && !configFile.exists()) {
            appLog.error("Configuration file '" + configFile + "' specified as command line argument was not found");
            appLog.warn("Will attempt to start without loading configuration\u2026");
        }
        ApplicationEngineEnvironment environment2 = ApplicationEngineEnvironmentKt.applicationEngineEnvironment((Function1<? super ApplicationEngineEnvironmentBuilder, Unit>)((Function1)new Function1<ApplicationEngineEnvironmentBuilder, Unit>(appLog, jar, combinedConfig, argsMap, hostConfigPath, hostPortPath, hostSslPortPath, hostSslKeyStore, hostSslKeyStorePassword, hostSslPrivateKeyPassword, hostSslKeyAlias, hostWatchPaths){
            final /* synthetic */ Logger $appLog;
            final /* synthetic */ URL $jar;
            final /* synthetic */ Config $combinedConfig;
            final /* synthetic */ Map $argsMap;
            final /* synthetic */ String $hostConfigPath;
            final /* synthetic */ String $hostPortPath;
            final /* synthetic */ String $hostSslPortPath;
            final /* synthetic */ String $hostSslKeyStore;
            final /* synthetic */ String $hostSslKeyStorePassword;
            final /* synthetic */ String $hostSslPrivateKeyPassword;
            final /* synthetic */ String $hostSslKeyAlias;
            final /* synthetic */ String $hostWatchPaths;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ApplicationEngineEnvironmentBuilder $receiver) {
                block26: {
                    Object object;
                    Object object2;
                    String string;
                    String string2;
                    String string3;
                    String sslPort;
                    String string4;
                    String port;
                    String string5;
                    String string6;
                    String host;
                    String string7;
                    ClassLoader classLoader;
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    Logger logger = this.$appLog;
                    Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"appLog");
                    $receiver.setLog(logger);
                    ApplicationEngineEnvironmentBuilder applicationEngineEnvironmentBuilder = $receiver;
                    URL uRL = this.$jar;
                    if (uRL != null) {
                        URL uRL2 = uRL;
                        ApplicationEngineEnvironmentBuilder applicationEngineEnvironmentBuilder2 = applicationEngineEnvironmentBuilder;
                        URL it = uRL2;
                        URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{this.$jar}, ApplicationEnvironment.class.getClassLoader());
                        applicationEngineEnvironmentBuilder = applicationEngineEnvironmentBuilder2;
                        classLoader = uRLClassLoader;
                    } else {
                        ClassLoader classLoader2 = ApplicationEnvironment.class.getClassLoader();
                        classLoader = classLoader2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"ApplicationEnvironment::class.java.classLoader");
                    }
                    applicationEngineEnvironmentBuilder.setClassLoader(classLoader);
                    Config config = this.$combinedConfig;
                    Intrinsics.checkExpressionValueIsNotNull((Object)config, (String)"combinedConfig");
                    $receiver.setConfig((ApplicationConfig)new HoconApplicationConfig(config));
                    ConfigValue contentHiddenValue = ConfigValueFactory.fromAnyRef((Object)"***", (String)"Content hidden");
                    $receiver.getLog().trace(this.$combinedConfig.getObject("ktor").withoutKey("security").withValue("security", contentHiddenValue).render());
                    String string8 = (String)this.$argsMap.get("-host");
                    if (string8 == null) {
                        Config config2 = this.$combinedConfig;
                        Intrinsics.checkExpressionValueIsNotNull((Object)config2, (String)"combinedConfig");
                        string8 = string7 = HoconApplicationConfigKt.tryGetString((Config)config2, (String)this.$hostConfigPath);
                    }
                    if (string8 == null) {
                        string7 = host = "0.0.0.0";
                    }
                    if ((string6 = (String)this.$argsMap.get("-port")) == null) {
                        Config config3 = this.$combinedConfig;
                        Intrinsics.checkExpressionValueIsNotNull((Object)config3, (String)"combinedConfig");
                        string6 = string5 = HoconApplicationConfigKt.tryGetString((Config)config3, (String)this.$hostPortPath);
                    }
                    if (string6 == null) {
                        string5 = port = "80";
                    }
                    if ((string4 = (String)this.$argsMap.get("-sslPort")) == null) {
                        Config config4 = this.$combinedConfig;
                        Intrinsics.checkExpressionValueIsNotNull((Object)config4, (String)"combinedConfig");
                        string4 = sslPort = HoconApplicationConfigKt.tryGetString((Config)config4, (String)this.$hostSslPortPath);
                    }
                    if ((string3 = (String)this.$argsMap.get("-sslKeyStore")) == null) {
                        Config config5 = this.$combinedConfig;
                        Intrinsics.checkExpressionValueIsNotNull((Object)config5, (String)"combinedConfig");
                        string3 = HoconApplicationConfigKt.tryGetString((Config)config5, (String)this.$hostSslKeyStore);
                    }
                    String sslKeyStorePath = string3;
                    Config config6 = this.$combinedConfig;
                    Intrinsics.checkExpressionValueIsNotNull((Object)config6, (String)"combinedConfig");
                    String string9 = HoconApplicationConfigKt.tryGetString((Config)config6, (String)this.$hostSslKeyStorePassword);
                    if (string9 != null) {
                        String string10;
                        String string11 = string10 = string9;
                        if (string11 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        string2 = ((Object)StringsKt.trim((CharSequence)string11)).toString();
                    } else {
                        string2 = null;
                    }
                    String sslKeyStorePassword = string2;
                    Config config7 = this.$combinedConfig;
                    Intrinsics.checkExpressionValueIsNotNull((Object)config7, (String)"combinedConfig");
                    String string12 = HoconApplicationConfigKt.tryGetString((Config)config7, (String)this.$hostSslPrivateKeyPassword);
                    if (string12 != null) {
                        String string13;
                        String string14 = string13 = string12;
                        if (string14 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        string = ((Object)StringsKt.trim((CharSequence)string14)).toString();
                    } else {
                        string = null;
                    }
                    String sslPrivateKeyPassword = string;
                    Config config8 = this.$combinedConfig;
                    Intrinsics.checkExpressionValueIsNotNull((Object)config8, (String)"combinedConfig");
                    String string15 = HoconApplicationConfigKt.tryGetString((Config)config8, (String)this.$hostSslKeyAlias);
                    if (string15 == null) {
                        string15 = "mykey";
                    }
                    String sslKeyAlias = string15;
                    ApplicationEngineEnvironmentBuilder $receiver$iv = $receiver;
                    Object object3 = new EngineConnectorBuilder(null, 1, null);
                    List<EngineConnectorConfig> list = $receiver$iv.getConnectors();
                    Object $receiver2 = object3;
                    ((EngineConnectorBuilder)$receiver2).setHost(host);
                    Object object4 = port;
                    Object object5 = $receiver2;
                    int n = Integer.parseInt((String)object4);
                    ((EngineConnectorBuilder)object5).setPort(n);
                    $receiver2 = object3;
                    list.add((EngineConnectorConfig)$receiver2);
                    if (sslPort != null) {
                        void $receiver$iv2;
                        void privateKeyPassword$iv;
                        void keyStorePassword$iv;
                        void keyStore$iv;
                        Object object6;
                        Object object7;
                        Object object8;
                        Object object9;
                        if (sslKeyStorePath == null) {
                            throw (Throwable)new IllegalArgumentException("SSL requires keystore: use -sslKeyStore=path or " + this.$hostSslKeyStore + " config");
                        }
                        if (sslKeyStorePassword == null) {
                            throw (Throwable)new IllegalArgumentException("SSL requires keystore password: use " + this.$hostSslKeyStorePassword + " config");
                        }
                        if (sslPrivateKeyPassword == null) {
                            throw (Throwable)new IllegalArgumentException("SSL requires certificate password: use " + this.$hostSslPrivateKeyPassword + " config");
                        }
                        object3 = new File(sslKeyStorePath);
                        Object file = object3;
                        Object keyStoreFile = ((File)file).exists() || ((File)file).isAbsolute() ? file : new File(".", sslKeyStorePath).getAbsoluteFile();
                        $receiver2 = file = KeyStore.getInstance("JKS");
                        object4 = new FileInputStream((File)keyStoreFile);
                        object5 = null;
                        try {
                            FileInputStream it = (FileInputStream)object4;
                            object9 = sslKeyStorePassword;
                            InputStream $i$f$connector = it;
                            object8 = $receiver2;
                            char[] cArray = ((String)object9).toCharArray();
                            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                            object7 = cArray;
                            ((KeyStore)object8).load($i$f$connector, (char[])object7);
                            object6 = Unit.INSTANCE;
                        }
                        catch (Throwable throwable) {
                            object5 = throwable;
                            throw throwable;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object4, (Throwable)object5);
                        }
                        object4 = sslPrivateKeyPassword;
                        String string16 = sslKeyAlias;
                        Object object10 = $receiver2;
                        char[] cArray = ((String)object4).toCharArray();
                        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                        Object object11 = cArray;
                        boolean bl = ((KeyStore)object10).getKey(string16, (char[])object11) == null;
                        Object keyStore = file;
                        file = $receiver;
                        Object object12 = keyStore;
                        Intrinsics.checkExpressionValueIsNotNull((Object)object12, (String)"keyStore");
                        $receiver2 = object12;
                        Function0 function0 = (Function0)new Function0<char[]>(sslKeyStorePassword){
                            final /* synthetic */ String $sslKeyStorePassword;

                            @NotNull
                            public final char[] invoke() {
                                String string;
                                String string2 = string = this.$sslKeyStorePassword;
                                if (string2 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                }
                                char[] cArray = string2.toCharArray();
                                Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                                return cArray;
                            }
                            {
                                this.$sslKeyStorePassword = string;
                                super(0);
                            }
                        };
                        object5 = (Function0)new Function0<char[]>(sslPrivateKeyPassword){
                            final /* synthetic */ String $sslPrivateKeyPassword;

                            @NotNull
                            public final char[] invoke() {
                                String string;
                                String string2 = string = this.$sslPrivateKeyPassword;
                                if (string2 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                }
                                char[] cArray = string2.toCharArray();
                                Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                                return cArray;
                            }
                            {
                                this.$sslPrivateKeyPassword = string;
                                super(0);
                            }
                        };
                        object6 = new EngineSSLConnectorBuilder((KeyStore)keyStore$iv, sslKeyAlias, (Function0<char[]>)keyStorePassword$iv, (Function0<char[]>)privateKeyPassword$iv);
                        object9 = $receiver$iv2.getConnectors();
                        Object $receiver3 = object6;
                        ((EngineConnectorBuilder)$receiver3).setHost(host);
                        object8 = sslPort;
                        object7 = $receiver3;
                        int n2 = Integer.parseInt((String)object8);
                        ((EngineConnectorBuilder)object7).setPort(n2);
                        ((EngineSSLConnectorBuilder)$receiver3).setKeyStorePath((File)keyStoreFile);
                        object11 = object6;
                        object9.add(object11);
                    }
                    if ((object2 = (String)this.$argsMap.get("-watch")) == null || (object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)) == null) {
                        Config config9 = this.$combinedConfig;
                        Intrinsics.checkExpressionValueIsNotNull((Object)config9, (String)"combinedConfig");
                        object2 = HoconApplicationConfigKt.tryGetStringList((Config)config9, (String)this.$hostWatchPaths);
                    }
                    if (object2 == null) break block26;
                    Object it = object = object2;
                    $receiver.setWatchPaths((List<String>)it);
                }
            }
            {
                this.$appLog = logger;
                this.$jar = uRL;
                this.$combinedConfig = config;
                this.$argsMap = map;
                this.$hostConfigPath = string;
                this.$hostPortPath = string2;
                this.$hostSslPortPath = string3;
                this.$hostSslKeyStore = string4;
                this.$hostSslKeyStorePassword = string5;
                this.$hostSslPrivateKeyPassword = string6;
                this.$hostSslKeyAlias = string7;
                this.$hostWatchPaths = string8;
                super(1);
            }
        }));
        return environment2;
    }

    private static final Pair<String, String> splitPair(@NotNull String $receiver, char ch) {
        Pair pair;
        int n;
        int idx = n = StringsKt.indexOf$default((CharSequence)$receiver, (char)ch, (int)0, (boolean)false, (int)6, null);
        switch (idx) {
            case -1: {
                pair = null;
                break;
            }
            default: {
                pair = new Pair((Object)StringsKt.take((String)$receiver, (int)idx), (Object)StringsKt.drop((String)$receiver, (int)(idx + 1)));
            }
        }
        return pair;
    }

    public static final void loadCommonConfiguration(@NotNull BaseApplicationEngine.Configuration $receiver, @NotNull ApplicationConfig deploymentConfig) {
        block2: {
            int n;
            Object object;
            Object object2;
            int it;
            int n2;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)deploymentConfig, (String)"deploymentConfig");
            Object object3 = deploymentConfig.propertyOrNull("callGroupSize");
            if (object3 != null && (object3 = object3.getString()) != null) {
                Object object4 = object3;
                it = n2 = Integer.parseInt((String)object4);
                $receiver.setCallGroupSize(it);
            }
            if ((object2 = deploymentConfig.propertyOrNull("connectionGroupSize")) != null && (object2 = object2.getString()) != null) {
                Object object5 = object2;
                it = n2 = Integer.parseInt((String)object5);
                $receiver.setConnectionGroupSize(it);
            }
            if ((object = deploymentConfig.propertyOrNull("workerGroupSize")) == null || (object = object.getString()) == null) break block2;
            Object object6 = object;
            it = n = Integer.parseInt((String)object6);
            $receiver.setWorkerGroupSize(it);
        }
    }
}

