/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.application.ApplicationCall;
import io.ktor.features.OriginConnectionPointKt;
import io.ktor.http.ContentType;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.LinkHeader;
import io.ktor.http.LinkHeaderKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.request.ApplicationRequest;
import io.ktor.response.ApplicationResponse;
import io.ktor.response.ApplicationResponsePropertiesKt;
import io.ktor.response.ApplicationSendPipeline;
import io.ktor.response.ResponseCookies;
import io.ktor.response.ResponseHeaders;
import io.ktor.response.ResponsePushBuilder;
import io.ktor.server.engine.BaseApplicationResponse;
import io.ktor.server.engine.LongKt;
import io.ktor.util.cio.ByteBufferPoolKt;
import io.ktor.util.cio.ChannelWriteException;
import io.ktor.util.cio.ReadersKt;
import io.ktor.util.pipeline.Pipeline;
import io.ktor.util.pipeline.PipelineContext;
import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.experimental.Continuation;
import kotlin.coroutines.experimental.CoroutineContext;
import kotlin.coroutines.experimental.intrinsics.IntrinsicsKt;
import kotlin.coroutines.experimental.jvm.internal.CoroutineImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlinx.coroutines.experimental.BuildersKt;
import kotlinx.coroutines.experimental.Unconfined;
import kotlinx.coroutines.experimental.io.ByteReadChannel;
import kotlinx.coroutines.experimental.io.ByteReadChannelJVMKt;
import kotlinx.coroutines.experimental.io.ByteWriteChannel;
import kotlinx.coroutines.experimental.io.ByteWriteChannelKt;
import kotlinx.coroutines.experimental.io.ClosedWriteChannelException;
import kotlinx.io.pool.ObjectPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u00002\u00020\u0001:\u0004@ABCB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0004J\u0018\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0016J\u0019\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(J\u0019\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J\u0019\u0010-\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020.H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/J\u0019\u00100\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101J\u0019\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u000204H\u00a4@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105J\u0019\u00106\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u000207H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00108J\u0011\u00109\u001a\u00020:H\u00a4@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J\u0010\u0010<\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\u0006H$J\n\u0010>\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010>\u001a\u00020\u001b2\u0006\u0010?\u001a\u00020\u0006H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\t\u00a8\u0006D"}, d2={"Lio/ktor/server/engine/BaseApplicationResponse;", "Lio/ktor/response/ApplicationResponse;", "call", "Lio/ktor/application/ApplicationCall;", "(Lio/ktor/application/ApplicationCall;)V", "_status", "Lio/ktor/http/HttpStatusCode;", "bufferPool", "Lkotlinx/io/pool/ObjectPool;", "Ljava/nio/ByteBuffer;", "getBufferPool", "()Lkotlinx/io/pool/ObjectPool;", "getCall", "()Lio/ktor/application/ApplicationCall;", "cookies", "Lio/ktor/response/ResponseCookies;", "getCookies", "()Lio/ktor/response/ResponseCookies;", "cookies$delegate", "Lkotlin/Lazy;", "pipeline", "Lio/ktor/response/ApplicationSendPipeline;", "getPipeline", "()Lio/ktor/response/ApplicationSendPipeline;", "responded", "", "commitHeaders", "", "content", "Lio/ktor/http/content/OutgoingContent;", "ensureLength", "expected", "", "actual", "push", "builder", "Lio/ktor/response/ResponsePushBuilder;", "respondFromBytes", "bytes", "", "([BLkotlin/coroutines/experimental/Continuation;)Ljava/lang/Object;", "respondFromChannel", "readChannel", "Lkotlinx/coroutines/experimental/io/ByteReadChannel;", "(Lkotlinx/coroutines/experimental/io/ByteReadChannel;Lkotlin/coroutines/experimental/Continuation;)Ljava/lang/Object;", "respondNoContent", "Lio/ktor/http/content/OutgoingContent$NoContent;", "(Lio/ktor/http/content/OutgoingContent$NoContent;Lkotlin/coroutines/experimental/Continuation;)Ljava/lang/Object;", "respondOutgoingContent", "(Lio/ktor/http/content/OutgoingContent;Lkotlin/coroutines/experimental/Continuation;)Ljava/lang/Object;", "respondUpgrade", "upgrade", "Lio/ktor/http/content/OutgoingContent$ProtocolUpgrade;", "(Lio/ktor/http/content/OutgoingContent$ProtocolUpgrade;Lkotlin/coroutines/experimental/Continuation;)Ljava/lang/Object;", "respondWriteChannelContent", "Lio/ktor/http/content/OutgoingContent$WriteChannelContent;", "(Lio/ktor/http/content/OutgoingContent$WriteChannelContent;Lkotlin/coroutines/experimental/Continuation;)Ljava/lang/Object;", "responseChannel", "Lkotlinx/coroutines/experimental/io/ByteWriteChannel;", "(Lkotlin/coroutines/experimental/Continuation;)Ljava/lang/Object;", "setStatus", "statusCode", "status", "value", "BodyLengthIsTooLong", "BodyLengthIsTooSmall", "InvalidHeaderForContent", "ResponseAlreadySentException", "ktor-server-host-common"})
public abstract class BaseApplicationResponse
implements ApplicationResponse {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private HttpStatusCode _status;
    @NotNull
    private final Lazy cookies$delegate;
    private boolean responded;
    @NotNull
    private final ApplicationSendPipeline pipeline;
    @NotNull
    private final ApplicationCall call;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BaseApplicationResponse.class), "cookies", "getCookies()Lio/ktor/response/ResponseCookies;"))};
    }

    @NotNull
    public ResponseCookies getCookies() {
        Lazy lazy = this.cookies$delegate;
        BaseApplicationResponse baseApplicationResponse = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (ResponseCookies)lazy.getValue();
    }

    @Nullable
    public HttpStatusCode status() {
        return this._status;
    }

    public void status(@NotNull HttpStatusCode value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this._status = value;
        this.setStatus(value);
    }

    @NotNull
    public final ApplicationSendPipeline getPipeline() {
        return this.pipeline;
    }

    /*
     * WARNING - void declaration
     */
    protected final void commitHeaders(@NotNull OutgoingContent content) {
        void transferEncodingSet;
        HttpStatusCode httpStatusCode;
        HttpStatusCode httpStatusCode2;
        HttpStatusCode it;
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        this.responded = true;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        HttpStatusCode httpStatusCode3 = content.getStatus();
        if (httpStatusCode3 != null) {
            HttpStatusCode httpStatusCode4;
            it = httpStatusCode4 = httpStatusCode3;
            this.status(it);
            httpStatusCode2 = Unit.INSTANCE;
        } else {
            httpStatusCode2 = httpStatusCode = this.status();
        }
        if (httpStatusCode2 == null) {
            this.status(HttpStatusCode.Companion.getOK());
            httpStatusCode = Unit.INSTANCE;
        }
        content.getHeaders().forEach((Function2)new Function2<String, List<? extends String>, Unit>(this, (Ref.BooleanRef)transferEncodingSet, content){
            final /* synthetic */ BaseApplicationResponse this$0;
            final /* synthetic */ Ref.BooleanRef $transferEncodingSet;
            final /* synthetic */ OutgoingContent $content;

            public final void invoke(@NotNull String name, @NotNull List<String> values) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                Intrinsics.checkParameterIsNotNull(values, (String)"values");
                String string = name;
                if (Intrinsics.areEqual((Object)string, (Object)HttpHeaders.INSTANCE.getTransferEncoding())) {
                    this.$transferEncodingSet.element = true;
                } else if (Intrinsics.areEqual((Object)string, (Object)HttpHeaders.INSTANCE.getUpgrade())) {
                    if (!(this.$content instanceof OutgoingContent.ProtocolUpgrade)) {
                        throw (Throwable)new InvalidHeaderForContent(HttpHeaders.INSTANCE.getUpgrade(), "non-upgrading response");
                    }
                    for (String value : values) {
                        this.this$0.getHeaders().append(name, value, false);
                    }
                    return;
                }
                for (String value : values) {
                    ResponseHeaders.append$default((ResponseHeaders)this.this$0.getHeaders(), (String)name, (String)value, (boolean)false, (int)4, null);
                }
            }
            {
                this.this$0 = baseApplicationResponse;
                this.$transferEncodingSet = booleanRef;
                this.$content = outgoingContent;
                super(2);
            }
        });
        Long contentLength = content.getContentLength();
        if (contentLength != null) {
            this.getHeaders().append(HttpHeaders.INSTANCE.getContentLength(), LongKt.toStringFast(contentLength), false);
        } else if (!transferEncodingSet.element && !((it = content) instanceof OutgoingContent.ProtocolUpgrade)) {
            if (it instanceof OutgoingContent.NoContent) {
                this.getHeaders().append(HttpHeaders.INSTANCE.getContentLength(), "0", false);
            } else {
                this.getHeaders().append(HttpHeaders.INSTANCE.getTransferEncoding(), "chunked", false);
            }
        }
        ContentType contentType = content.getContentType();
        if (contentType != null) {
            HttpStatusCode it2 = it = contentType;
            this.getHeaders().append(HttpHeaders.INSTANCE.getContentType(), it2.toString(), false);
        }
        String connection = this.getCall().getRequest().getHeaders().get(HttpHeaders.INSTANCE.getConnection());
        if (connection != null) {
            if (StringsKt.equals((String)connection, (String)"close", (boolean)true)) {
                ApplicationResponsePropertiesKt.header((ApplicationResponse)this, (String)"Connection", (String)"close");
            } else if (StringsKt.equals((String)connection, (String)"keep-alive", (boolean)true)) {
                ApplicationResponsePropertiesKt.header((ApplicationResponse)this, (String)"Connection", (String)"keep-alive");
            }
        }
    }

    @Nullable
    protected Object respondOutgoingContent(@NotNull OutgoingContent outgoingContent, @NotNull Continuation<? super Unit> continuation) {
        return BaseApplicationResponse.respondOutgoingContent$suspendImpl(this, outgoingContent, continuation);
    }

    static /* synthetic */ Object respondOutgoingContent$suspendImpl(BaseApplicationResponse this_, OutgoingContent content, Continuation continuation) {
        OutgoingContent outgoingContent = content;
        if (outgoingContent instanceof OutgoingContent.ProtocolUpgrade) {
            this_.commitHeaders(content);
            return this_.respondUpgrade((OutgoingContent.ProtocolUpgrade)content, (Continuation<? super Unit>)continuation);
        }
        if (outgoingContent instanceof OutgoingContent.ByteArrayContent) {
            byte[] bytes = ((OutgoingContent.ByteArrayContent)content).bytes();
            this_.commitHeaders(content);
            return this_.respondFromBytes(bytes, (Continuation<? super Unit>)continuation);
        }
        if (outgoingContent instanceof OutgoingContent.WriteChannelContent) {
            this_.commitHeaders(content);
            return this_.respondWriteChannelContent((OutgoingContent.WriteChannelContent)content, (Continuation<? super Unit>)continuation);
        }
        if (outgoingContent instanceof OutgoingContent.ReadChannelContent) {
            ByteReadChannel readChannel = ((OutgoingContent.ReadChannelContent)content).readFrom();
            this_.commitHeaders(content);
            return this_.respondFromChannel(readChannel, (Continuation<? super Unit>)continuation);
        }
        if (outgoingContent instanceof OutgoingContent.NoContent) {
            this_.commitHeaders(content);
            return this_.respondNoContent((OutgoingContent.NoContent)content, (Continuation<? super Unit>)continuation);
        }
        throw new NoWhenBranchMatchedException();
    }

    @Nullable
    protected Object respondNoContent(@NotNull OutgoingContent.NoContent noContent, @NotNull Continuation<? super Unit> continuation) {
        return BaseApplicationResponse.respondNoContent$suspendImpl(this, noContent, continuation);
    }

    static /* synthetic */ Object respondNoContent$suspendImpl(BaseApplicationResponse this_, OutgoingContent.NoContent content, Continuation continuation) {
        return Unit.INSTANCE;
    }

    @Nullable
    protected Object respondWriteChannelContent(@NotNull OutgoingContent.WriteChannelContent writeChannelContent, @NotNull Continuation<? super Unit> continuation) {
        return BaseApplicationResponse.respondWriteChannelContent$suspendImpl(this, writeChannelContent, continuation);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object respondWriteChannelContent$suspendImpl(BaseApplicationResponse var0, OutgoingContent.WriteChannelContent var1_1, Continuation var2_2) {
        if (var2_2 instanceof respondWriteChannelContent.1 && (($continuation = var2_2).getLabel() & -2147483648) != 0) {
            v0 = $continuation;
            v0.setLabel(v0.getLabel() - -2147483648);
        } else {
            $continuation = new CoroutineImpl(var0, var2_2){
                /* synthetic */ Object data;
                /* synthetic */ Throwable exception;
                final /* synthetic */ BaseApplicationResponse this$0;
                Object L$0;
                Object L$1;

                @Nullable
                public final Object doResume(@Nullable Object data, @Nullable Throwable throwable) {
                    this.data = data;
                    this.exception = throwable;
                    this.label |= Integer.MIN_VALUE;
                    return BaseApplicationResponse.respondWriteChannelContent$suspendImpl(this.this$0, null, (Continuation)this);
                }

                final /* synthetic */ int getLabel() {
                    return this.label;
                }

                final /* synthetic */ void setLabel(int n) {
                    this.label = n;
                }
                {
                    this.this$0 = baseApplicationResponse;
                    super(0, continuation);
                }
            };
        }
        var3_4 = $continuation.data;
        var4_5 = $continuation.exception;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.getLabel()) {
            case 0: {
                v1 = var4_5;
                if (v1 != null) {
                    throw v1;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = content;
                $continuation.setLabel(1);
                v2 = this.responseChannel((Continuation<? super ByteWriteChannel>)$continuation);
                if (v2 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl28
            }
            case 1: {
                content = (OutgoingContent.WriteChannelContent)$continuation.L$1;
                this = (BaseApplicationResponse)$continuation.L$0;
                v3 = var4_5;
                if (v3 != null) {
                    throw v3;
                }
                v2 = var3_4;
lbl28:
                // 2 sources

                v4 = (ByteWriteChannel)v2;
                v5 = (Function2)new Function2<ByteWriteChannel, Continuation<? super Unit>, Object>(content, null){
                    private ByteWriteChannel p$;
                    final /* synthetic */ OutgoingContent.WriteChannelContent $content;

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object doResume(@Nullable Object object, @Nullable Throwable throwable) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Throwable throwable2 = throwable;
                                if (throwable2 != null) {
                                    throw throwable2;
                                }
                                ByteWriteChannel byteWriteChannel = this.p$;
                                this.label = 1;
                                Object object3 = this.$content.writeTo(byteWriteChannel, (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                Object object3;
                                try {
                                    void data;
                                    void throwable3;
                                    void v2 = throwable3;
                                    if (v2 != null) {
                                        throw v2;
                                    }
                                    object3 = data;
                                    return Unit.INSTANCE;
                                }
                                catch (ClosedWriteChannelException closed) {
                                    throw (Throwable)new ChannelWriteException(null, (Throwable)closed, 1, null);
                                }
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.$content = writeChannelContent;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull ByteWriteChannel $receiver, @NotNull Continuation<? super Unit> continuation) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
                        Function2<ByteWriteChannel, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        ByteWriteChannel byteWriteChannel = function2.p$ = $receiver;
                        return function2;
                    }

                    @Nullable
                    public final Object invoke(@NotNull ByteWriteChannel $receiver, @NotNull Continuation<? super Unit> continuation) {
                        return (this.create($receiver, continuation)).doResume(Unit.INSTANCE, null);
                    }
                };
                $continuation.L$0 = this;
                $continuation.L$1 = content;
                $continuation.setLabel(2);
                v6 = ReadersKt.use((ByteWriteChannel)v4, (Function2)v5, (Continuation)$continuation);
                if (v6 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl44
            }
            case 2: {
                content = (OutgoingContent.WriteChannelContent)$continuation.L$1;
                this = (BaseApplicationResponse)$continuation.L$0;
                v7 = var4_5;
                if (v7 != null) {
                    throw v7;
                }
                v6 = var3_4;
lbl44:
                // 2 sources

                return v6;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    protected Object respondFromBytes(@NotNull byte[] byArray, @NotNull Continuation<? super Unit> continuation) {
        return BaseApplicationResponse.respondFromBytes$suspendImpl(this, byArray, continuation);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object respondFromBytes$suspendImpl(BaseApplicationResponse var0, byte[] var1_1, Continuation var2_2) {
        if (var2_2 instanceof respondFromBytes.1 && (($continuation = var2_2).getLabel() & -2147483648) != 0) {
            v0 = $continuation;
            v0.setLabel(v0.getLabel() - -2147483648);
        } else {
            $continuation = new CoroutineImpl(var0, var2_2){
                /* synthetic */ Object data;
                /* synthetic */ Throwable exception;
                final /* synthetic */ BaseApplicationResponse this$0;
                Object L$0;
                Object L$1;

                @Nullable
                public final Object doResume(@Nullable Object data, @Nullable Throwable throwable) {
                    this.data = data;
                    this.exception = throwable;
                    this.label |= Integer.MIN_VALUE;
                    return BaseApplicationResponse.respondFromBytes$suspendImpl(this.this$0, null, (Continuation)this);
                }

                final /* synthetic */ int getLabel() {
                    return this.label;
                }

                final /* synthetic */ void setLabel(int n) {
                    this.label = n;
                }
                {
                    this.this$0 = baseApplicationResponse;
                    super(0, continuation);
                }
            };
        }
        var8_4 = $continuation.data;
        var9_5 = $continuation.exception;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.getLabel()) {
            case 0: {
                v1 = var9_5;
                if (v1 != null) {
                    throw v1;
                }
                v2 = this.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
                if (v2 != null) {
                    var3_7 = v2;
                    length = var3_8 = Long.parseLong(var3_7);
                    this.ensureLength(length, bytes.length);
                }
                $continuation.L$0 = this;
                $continuation.L$1 = bytes;
                $continuation.setLabel(1);
                v3 = this.responseChannel((Continuation<? super ByteWriteChannel>)$continuation);
                if (v3 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl34
            }
            case 1: {
                bytes = (byte[])$continuation.L$1;
                this = (BaseApplicationResponse)$continuation.L$0;
                v4 = var9_5;
                if (v4 != null) {
                    throw v4;
                }
                v3 = var8_4;
lbl34:
                // 2 sources

                v5 = (ByteWriteChannel)v3;
                v6 = (Function2)new Function2<ByteWriteChannel, Continuation<? super Unit>, Object>(bytes, null){
                    private ByteWriteChannel p$;
                    final /* synthetic */ byte[] $bytes;

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object doResume(@Nullable Object object, @Nullable Throwable throwable) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Throwable throwable2 = throwable;
                                if (throwable2 != null) {
                                    throw throwable2;
                                }
                                ByteWriteChannel byteWriteChannel = this.p$;
                                this.label = 1;
                                Object object3 = BuildersKt.withContext$default((CoroutineContext)((CoroutineContext)Unconfined.INSTANCE), null, (Function1)((Function1)new Function1<Continuation<? super Unit>, Object>(this, byteWriteChannel, null){
                                    final /* synthetic */ respondFromBytes.3 this$0;
                                    final /* synthetic */ ByteWriteChannel receiver$0;

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    @Nullable
                                    public final Object doResume(@Nullable Object object, @Nullable Throwable throwable) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                Throwable throwable2 = throwable;
                                                if (throwable2 != null) {
                                                    throw throwable2;
                                                }
                                                this.label = 1;
                                                Object object3 = ByteWriteChannelKt.writeFully((ByteWriteChannel)this.receiver$0, (byte[])this.this$0.$bytes, (Continuation)this);
                                                if (object3 != object2) return Unit.INSTANCE;
                                                return object2;
                                            }
                                            case 1: {
                                                void data;
                                                void throwable3;
                                                void v2 = throwable3;
                                                if (v2 != null) {
                                                    throw v2;
                                                }
                                                Object object3 = data;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.receiver$0 = byteWriteChannel;
                                        super(1, continuation);
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@NotNull Continuation<? super Unit> continuation) {
                                        Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
                                        Function1<Continuation<? super Unit>, Object> function1 = new /* invalid duplicate definition of identical inner class */;
                                        return function1;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull Continuation<? super Unit> continuation) {
                                        return (this.create(continuation)).doResume(Unit.INSTANCE, null);
                                    }
                                }), (Continuation)this, (int)2, null);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void data;
                                void throwable3;
                                void v2 = throwable3;
                                if (v2 != null) {
                                    throw v2;
                                }
                                Object object3 = data;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.$bytes = byArray;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull ByteWriteChannel $receiver, @NotNull Continuation<? super Unit> continuation) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
                        Function2<ByteWriteChannel, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        ByteWriteChannel byteWriteChannel = function2.p$ = $receiver;
                        return function2;
                    }

                    @Nullable
                    public final Object invoke(@NotNull ByteWriteChannel $receiver, @NotNull Continuation<? super Unit> continuation) {
                        return (this.create($receiver, continuation)).doResume(Unit.INSTANCE, null);
                    }
                };
                $continuation.L$0 = this;
                $continuation.L$1 = bytes;
                $continuation.setLabel(2);
                v7 = ReadersKt.use((ByteWriteChannel)v5, (Function2)v6, (Continuation)$continuation);
                if (v7 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl50
            }
            case 2: {
                bytes = (byte[])$continuation.L$1;
                this = (BaseApplicationResponse)$continuation.L$0;
                v8 = var9_5;
                if (v8 != null) {
                    throw v8;
                }
                v7 = var8_4;
lbl50:
                // 2 sources

                return v7;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    protected Object respondFromChannel(@NotNull ByteReadChannel byteReadChannel, @NotNull Continuation<? super Unit> continuation) {
        return BaseApplicationResponse.respondFromChannel$suspendImpl(this, byteReadChannel, continuation);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object respondFromChannel$suspendImpl(BaseApplicationResponse var0, ByteReadChannel var1_1, Continuation var2_2) {
        if (var2_2 instanceof respondFromChannel.1 && (($continuation = var2_2).getLabel() & -2147483648) != 0) {
            v0 = $continuation;
            v0.setLabel(v0.getLabel() - -2147483648);
        } else {
            $continuation = new CoroutineImpl(var0, var2_2){
                /* synthetic */ Object data;
                /* synthetic */ Throwable exception;
                final /* synthetic */ BaseApplicationResponse this$0;
                Object L$0;
                Object L$1;

                @Nullable
                public final Object doResume(@Nullable Object data, @Nullable Throwable throwable) {
                    this.data = data;
                    this.exception = throwable;
                    this.label |= Integer.MIN_VALUE;
                    return BaseApplicationResponse.respondFromChannel$suspendImpl(this.this$0, null, (Continuation)this);
                }

                final /* synthetic */ int getLabel() {
                    return this.label;
                }

                final /* synthetic */ void setLabel(int n) {
                    this.label = n;
                }
                {
                    this.this$0 = baseApplicationResponse;
                    super(0, continuation);
                }
            };
        }
        var3_4 = $continuation.data;
        var4_5 = $continuation.exception;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.getLabel()) {
            case 0: {
                v1 = var4_5;
                if (v1 != null) {
                    throw v1;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = readChannel;
                $continuation.setLabel(1);
                v2 = this.responseChannel((Continuation<? super ByteWriteChannel>)$continuation);
                if (v2 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl28
            }
            case 1: {
                readChannel = (ByteReadChannel)$continuation.L$1;
                this = (BaseApplicationResponse)$continuation.L$0;
                v3 = var4_5;
                if (v3 != null) {
                    throw v3;
                }
                v2 = var3_4;
lbl28:
                // 2 sources

                v4 = (ByteWriteChannel)v2;
                v5 = (Function2)new Function2<ByteWriteChannel, Continuation<? super Unit>, Object>(this, readChannel, null){
                    private ByteWriteChannel p$;
                    Object L$0;
                    long J$0;
                    final /* synthetic */ BaseApplicationResponse this$0;
                    final /* synthetic */ ByteReadChannel $readChannel;

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object doResume(@Nullable Object var1_1, @Nullable Throwable var2_2) {
                        var9_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                v0 = var2_2;
                                if (v0 != null) {
                                    throw v0;
                                }
                                var3_4 = this.p$;
                                v1 = this.this$0.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
                                if (v1 != null) {
                                    var5_5 = v1;
                                    v2 = Long.parseLong(var5_5);
                                } else {
                                    v2 = null;
                                }
                                length = v2;
                                this.L$0 = length;
                                this.label = 1;
                                v3 = BuildersKt.withContext$default((CoroutineContext)((CoroutineContext)Unconfined.INSTANCE), null, (Function1)((Function1)new Function1<Continuation<? super Long>, Object>(this, var3_4, length, null){
                                    final /* synthetic */ respondFromChannel.2 this$0;
                                    final /* synthetic */ ByteWriteChannel receiver$0;
                                    final /* synthetic */ Long $length;

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    @Nullable
                                    public final Object doResume(@Nullable Object object, @Nullable Throwable throwable) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                Throwable throwable2 = throwable;
                                                if (throwable2 != null) {
                                                    throw throwable2;
                                                }
                                                Long l = this.$length;
                                                this.label = 1;
                                                Object object3 = ByteReadChannelJVMKt.copyTo((ByteReadChannel)this.this$0.$readChannel, (ByteWriteChannel)this.receiver$0, (long)(l != null ? l : Long.MAX_VALUE), (Continuation)this);
                                                if (object3 != object2) return object3;
                                                return object2;
                                            }
                                            case 1: {
                                                void data;
                                                void throwable3;
                                                void v3 = throwable3;
                                                if (v3 != null) {
                                                    throw v3;
                                                }
                                                Object object3 = data;
                                                return object3;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.receiver$0 = byteWriteChannel;
                                        this.$length = l;
                                        super(1, continuation);
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@NotNull Continuation<? super Long> continuation) {
                                        Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
                                        Function1<Continuation<? super Long>, Object> function1 = new /* invalid duplicate definition of identical inner class */;
                                        return function1;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull Continuation<? super Long> continuation) {
                                        return (this.create(continuation)).doResume(Unit.INSTANCE, null);
                                    }
                                }), (Continuation)this, (int)2, null);
                                if (v3 == var9_3) {
                                    return var9_3;
                                }
                                ** GOTO lbl27
                            }
                            case 1: {
                                length = (Long)this.L$0;
                                v4 = throwable;
                                if (v4 != null) {
                                    throw v4;
                                }
                                v3 = data;
lbl27:
                                // 2 sources

                                copied = ((Number)v3).longValue();
                                v5 = length;
                                if (v5 == null) {
                                    return Unit.INSTANCE;
                                }
                                v5.longValue();
                                this.L$0 = length;
                                this.J$0 = copied;
                                this.label = 2;
                                v6 = this.$readChannel.discard(1L, (Continuation)this);
                                if (v6 == var9_3) {
                                    return var9_3;
                                }
                                ** GOTO lbl46
                            }
                            case 2: {
                                copied = this.J$0;
                                length = (Long)this.L$0;
                                v7 = throwable;
                                if (v7 != null) {
                                    throw v7;
                                }
                                v6 = data;
lbl46:
                                // 2 sources

                                discarded = ((Number)v6).longValue();
                                BaseApplicationResponse.access$ensureLength(this.this$0, length, copied + discarded);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = baseApplicationResponse;
                        this.$readChannel = byteReadChannel;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@NotNull ByteWriteChannel $receiver, @NotNull Continuation<? super Unit> continuation) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
                        Function2<ByteWriteChannel, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        ByteWriteChannel byteWriteChannel = function2.p$ = $receiver;
                        return function2;
                    }

                    @Nullable
                    public final Object invoke(@NotNull ByteWriteChannel $receiver, @NotNull Continuation<? super Unit> continuation) {
                        return (this.create($receiver, continuation)).doResume(Unit.INSTANCE, null);
                    }
                };
                $continuation.L$0 = this;
                $continuation.L$1 = readChannel;
                $continuation.setLabel(2);
                v6 = ReadersKt.use((ByteWriteChannel)v4, (Function2)v5, (Continuation)$continuation);
                if (v6 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl44
            }
            case 2: {
                readChannel = (ByteReadChannel)$continuation.L$1;
                this = (BaseApplicationResponse)$continuation.L$0;
                v7 = var4_5;
                if (v7 != null) {
                    throw v7;
                }
                v6 = var3_4;
lbl44:
                // 2 sources

                return v6;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void ensureLength(long expected, long actual) {
        if (expected < actual) {
            throw (Throwable)new BodyLengthIsTooLong(expected);
        }
        if (expected > actual) {
            throw (Throwable)new BodyLengthIsTooSmall(expected, actual);
        }
    }

    @Nullable
    protected abstract Object respondUpgrade(@NotNull OutgoingContent.ProtocolUpgrade var1, @NotNull Continuation<? super Unit> var2);

    @Nullable
    protected abstract Object responseChannel(@NotNull Continuation<? super ByteWriteChannel> var1);

    @NotNull
    protected ObjectPool<ByteBuffer> getBufferPool() {
        return (ObjectPool)ByteBufferPoolKt.getKtorDefaultPool();
    }

    protected abstract void setStatus(@NotNull HttpStatusCode var1);

    public void push(@NotNull ResponsePushBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        LinkHeaderKt.link((ApplicationResponse)this, (String)builder.getUrl().buildString(), (String[])new String[]{LinkHeader.Rel.INSTANCE.getPrefetch()});
    }

    @NotNull
    public ApplicationCall getCall() {
        return this.call;
    }

    public BaseApplicationResponse(@NotNull ApplicationCall call) {
        ApplicationSendPipeline applicationSendPipeline;
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        this.call = call;
        this.cookies$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ResponseCookies>(this){
            final /* synthetic */ BaseApplicationResponse this$0;

            @NotNull
            public final ResponseCookies invoke() {
                return new ResponseCookies((ApplicationResponse)this.this$0, Intrinsics.areEqual((Object)OriginConnectionPointKt.getOrigin((ApplicationRequest)this.this$0.getCall().getRequest()).getScheme(), (Object)"https"));
            }
            {
                this.this$0 = baseApplicationResponse;
                super(0);
            }
        }));
        ApplicationSendPipeline applicationSendPipeline2 = new ApplicationSendPipeline();
        BaseApplicationResponse baseApplicationResponse = this;
        ApplicationSendPipeline $receiver = applicationSendPipeline2;
        $receiver.merge((Pipeline)this.getCall().getApplication().getSendPipeline());
        $receiver.intercept(ApplicationSendPipeline.Phases.getEngine(), (Function3)new Function3<PipelineContext<Object, ? extends ApplicationCall>, Object, Continuation<? super Unit>, Object>(null, this){
            private PipelineContext p$;
            private Object p$0;
            Object L$0;
            final /* synthetic */ BaseApplicationResponse this$0;
            {
                this.this$0 = baseApplicationResponse;
                super(3, continuation);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object doResume(@Nullable Object object, @Nullable Throwable throwable) {
                block8: {
                    Object response2;
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            Throwable throwable2 = throwable;
                            if (throwable2 != null) {
                                throw throwable2;
                            }
                            PipelineContext pipelineContext = this.p$;
                            Object object3 = this.p$0;
                            if (BaseApplicationResponse.access$getResponded$p(this.this$0)) {
                                throw (Throwable)new ResponseAlreadySentException();
                            }
                            response2 = pipelineContext.getSubject();
                            if (!(response2 instanceof OutgoingContent)) break;
                            this.L$0 = response2;
                            this.label = 1;
                            Object object4 = this.this$0.respondOutgoingContent((OutgoingContent)response2, (Continuation<? super Unit>)this);
                            if (object4 == object2) {
                                Object object5 = object2;
                                return object5;
                            }
                            break block8;
                        }
                        case 1: {
                            void data;
                            void throwable3;
                            Object response2 = this.L$0;
                            void v2 = throwable3;
                            if (v2 != null) {
                                throw v2;
                            }
                            Object object4 = data;
                            break block8;
                        }
                    }
                    throw (Throwable)new IllegalArgumentException("Response pipeline couldn't transform '" + response2.getClass() + "' to the OutgoingContent");
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull PipelineContext<Object, ? extends ApplicationCall> $receiver, @NotNull Object it, @NotNull Continuation<? super Unit> continuation) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
                Function3<PipelineContext<Object, ? extends ApplicationCall>, Object, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.p$ = $receiver;
                function3.p$0 = it;
                Function3<PipelineContext<Object, ? extends ApplicationCall>, Object, Continuation<? super Unit>, Object> function32 = function3;
                return function32;
            }

            @Nullable
            public final Object invoke(@NotNull PipelineContext<Object, ? extends ApplicationCall> $receiver, @NotNull Object it, @NotNull Continuation<? super Unit> continuation) {
                return (this.create($receiver, it, continuation)).doResume(Unit.INSTANCE, null);
            }
        });
        baseApplicationResponse.pipeline = applicationSendPipeline = applicationSendPipeline2;
    }

    public static final /* synthetic */ void access$ensureLength(BaseApplicationResponse $this, long expected, long actual) {
        $this.ensureLength(expected, actual);
    }

    public static final /* synthetic */ boolean access$getResponded$p(BaseApplicationResponse $this) {
        return $this.responded;
    }

    public static final /* synthetic */ void access$setResponded$p(BaseApplicationResponse $this, boolean bl) {
        $this.responded = bl;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lio/ktor/server/engine/BaseApplicationResponse$ResponseAlreadySentException;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "()V", "ktor-server-host-common"})
    public static final class ResponseAlreadySentException
    extends IllegalStateException {
        public ResponseAlreadySentException() {
            super("Response has already been sent");
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/ktor/server/engine/BaseApplicationResponse$InvalidHeaderForContent;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "name", "", "content", "(Ljava/lang/String;Ljava/lang/String;)V", "ktor-server-host-common"})
    public static final class InvalidHeaderForContent
    extends IllegalStateException {
        public InvalidHeaderForContent(@NotNull String name, @NotNull String content) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            super("Header " + name + " is not allowed for " + content);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/ktor/server/engine/BaseApplicationResponse$BodyLengthIsTooSmall;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "expected", "", "actual", "(JJ)V", "ktor-server-host-common"})
    public static final class BodyLengthIsTooSmall
    extends IllegalStateException {
        public BodyLengthIsTooSmall(long expected, long actual) {
            super("Body.size is too small. Body: " + actual + ", Content-Length: " + expected);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/ktor/server/engine/BaseApplicationResponse$BodyLengthIsTooLong;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "expected", "", "(J)V", "ktor-server-host-common"})
    public static final class BodyLengthIsTooLong
    extends IllegalStateException {
        public BodyLengthIsTooLong(long expected) {
            super("Body.size is too long. Expected " + expected);
        }
    }
}

