/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.engine.okhttp;

import io.ktor.client.engine.okhttp.UnsupportedFrameTypeException;
import io.ktor.client.features.websocket.WebSocketException;
import io.ktor.http.cio.websocket.CloseReason;
import io.ktor.http.cio.websocket.DefaultWebSocketSession;
import io.ktor.http.cio.websocket.Frame;
import io.ktor.http.cio.websocket.FrameCommonKt;
import java.nio.charset.Charset;
import java.util.concurrent.CancellationException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.channels.ActorKt;
import kotlinx.coroutines.channels.ActorScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0011\u00106\u001a\u000207H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00108J \u00109\u001a\u0002072\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J \u0010@\u001a\u0002072\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J\"\u0010A\u001a\u0002072\u0006\u0010:\u001a\u00020;2\u0006\u0010B\u001a\u00020C2\b\u0010D\u001a\u0004\u0018\u00010(H\u0016J\u0018\u0010E\u001a\u0002072\u0006\u0010:\u001a\u00020;2\u0006\u0010F\u001a\u00020?H\u0016J\u0018\u0010E\u001a\u0002072\u0006\u0010:\u001a\u00020;2\u0006\u0010G\u001a\u00020HH\u0016J\u0018\u0010I\u001a\u0002072\u0006\u0010:\u001a\u00020;2\u0006\u0010D\u001a\u00020(H\u0016J\u0006\u0010J\u001a\u000207J\b\u0010K\u001a\u000207H\u0017R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R$\u0010\"\u001a\u00020!2\u0006\u0010\u001a\u001a\u00020!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000f0,X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R$\u0010/\u001a\u00020!2\u0006\u0010\u001a\u001a\u00020!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b0\u0010$\"\u0004\b1\u0010&R\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00103\u001a\u00020!2\u0006\u0010\u001a\u001a\u00020!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b4\u0010$\"\u0004\b5\u0010&\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006L"}, d2={"Lio/ktor/client/engine/okhttp/OkHttpWebsocketSession;", "Lio/ktor/http/cio/websocket/DefaultWebSocketSession;", "Lokhttp3/WebSocketListener;", "engine", "Lokhttp3/OkHttpClient;", "engineRequest", "Lokhttp3/Request;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lokhttp3/OkHttpClient;Lokhttp3/Request;Lkotlin/coroutines/CoroutineContext;)V", "_closeReason", "Lkotlinx/coroutines/CompletableDeferred;", "Lio/ktor/http/cio/websocket/CloseReason;", "_incoming", "Lkotlinx/coroutines/channels/Channel;", "Lio/ktor/http/cio/websocket/Frame;", "closeReason", "Lkotlinx/coroutines/Deferred;", "getCloseReason", "()Lkotlinx/coroutines/Deferred;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "incoming", "Lkotlinx/coroutines/channels/ReceiveChannel;", "getIncoming", "()Lkotlinx/coroutines/channels/ReceiveChannel;", "<anonymous parameter 0>", "", "masking", "getMasking", "()Z", "setMasking", "(Z)V", "", "maxFrameSize", "getMaxFrameSize", "()J", "setMaxFrameSize", "(J)V", "originResponse", "Lokhttp3/Response;", "getOriginResponse$ktor_client_okhttp", "()Lkotlinx/coroutines/CompletableDeferred;", "outgoing", "Lkotlinx/coroutines/channels/SendChannel;", "getOutgoing", "()Lkotlinx/coroutines/channels/SendChannel;", "pingIntervalMillis", "getPingIntervalMillis", "setPingIntervalMillis", "self", "timeoutMillis", "getTimeoutMillis", "setTimeoutMillis", "flush", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onClosed", "webSocket", "Lokhttp3/WebSocket;", "code", "", "reason", "", "onClosing", "onFailure", "t", "", "response", "onMessage", "text", "bytes", "Lokio/ByteString;", "onOpen", "start", "terminate", "ktor-client-okhttp"})
public final class OkHttpWebsocketSession
extends WebSocketListener
implements DefaultWebSocketSession {
    private final CompletableDeferred<OkHttpWebsocketSession> self;
    @NotNull
    private final CompletableDeferred<Response> originResponse;
    private final Channel<Frame> _incoming;
    private final CompletableDeferred<CloseReason> _closeReason;
    @NotNull
    private final SendChannel<Frame> outgoing;
    private final OkHttpClient engine;
    @NotNull
    private final CoroutineContext coroutineContext;

    @NotNull
    public final CompletableDeferred<Response> getOriginResponse$ktor_client_okhttp() {
        return this.originResponse;
    }

    public long getPingIntervalMillis() {
        return this.engine.pingIntervalMillis();
    }

    public void setPingIntervalMillis(long $noName_0) {
        throw (Throwable)new WebSocketException("OkHttp doesn't support dynamic ping interval. You could switch it in the engine configuration.");
    }

    public long getTimeoutMillis() {
        return this.engine.readTimeoutMillis();
    }

    public void setTimeoutMillis(long $noName_0) {
        throw (Throwable)new WebSocketException("Websocket timeout should be configured in OkHttpEngine.");
    }

    public boolean getMasking() {
        return true;
    }

    public void setMasking(boolean $noName_0) {
        throw (Throwable)new WebSocketException("Masking switch is not supported in OkHttp engine.");
    }

    public long getMaxFrameSize() {
        throw (Throwable)new WebSocketException("OkHttp websocket doesn't support max frame size.");
    }

    public void setMaxFrameSize(long $noName_0) {
        throw (Throwable)new WebSocketException("Websocket timeout should be configured in OkHttpEngine.");
    }

    @NotNull
    public ReceiveChannel<Frame> getIncoming() {
        return (ReceiveChannel)this._incoming;
    }

    @NotNull
    public Deferred<CloseReason> getCloseReason() {
        return (Deferred)this._closeReason;
    }

    @NotNull
    public SendChannel<Frame> getOutgoing() {
        return this.outgoing;
    }

    public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
        Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        super.onOpen(webSocket, response);
        this.originResponse.complete((Object)response);
    }

    public void onMessage(@NotNull WebSocket webSocket, @NotNull ByteString bytes) {
        Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        super.onMessage(webSocket, bytes);
        SendChannel sendChannel = (SendChannel)this._incoming;
        byte[] byArray = bytes.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"bytes.toByteArray()");
        ChannelsKt.sendBlocking((SendChannel)sendChannel, (Object)new Frame.Binary(true, byArray));
    }

    public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        super.onMessage(webSocket, text);
        String string = text;
        boolean bl = true;
        SendChannel sendChannel = (SendChannel)this._incoming;
        Charset charset = Charsets.UTF_8;
        boolean bl2 = false;
        byte[] byArray2 = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray3 = byArray = byArray2;
        boolean bl3 = bl;
        ChannelsKt.sendBlocking((SendChannel)sendChannel, (Object)new Frame.Text(bl3, byArray3));
    }

    public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
        Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
        super.onClosed(webSocket, code, reason);
        this._closeReason.complete((Object)new CloseReason((short)code, reason));
        SendChannel.DefaultImpls.close$default(this._incoming, null, (int)1, null);
        SendChannel<Frame> sendChannel = this.getOutgoing();
        StringBuilder stringBuilder = new StringBuilder().append("WebSocket session closed with code ");
        Object object = CloseReason.Codes.Companion.byCode((short)code);
        if (object == null || (object = object.toString()) == null) {
            object = code;
        }
        sendChannel.close((Throwable)new CancellationException(stringBuilder.append(object).append('.').toString()));
    }

    public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
        Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
        super.onClosing(webSocket, code, reason);
        this._closeReason.complete((Object)new CloseReason((short)code, reason));
        if (!this.getOutgoing().isClosedForSend()) {
            ChannelsKt.sendBlocking(this.getOutgoing(), (Object)new Frame.Close(new CloseReason((short)code, reason)));
        }
        SendChannel.DefaultImpls.close$default(this._incoming, null, (int)1, null);
    }

    public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
        Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
        super.onFailure(webSocket, t, response);
        this.originResponse.completeExceptionally(t);
        this._incoming.close(t);
        this.getOutgoing().close(t);
    }

    @Nullable
    public Object flush(@NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    public final void start() {
        this.self.complete((Object)this);
    }

    @Deprecated(message="Use cancel() instead.", replaceWith=@ReplaceWith(imports={"kotlinx.coroutines.cancel"}, expression="cancel()"))
    public void terminate() {
        JobKt.cancel$default((CoroutineContext)this.getCoroutineContext(), null, (int)1, null);
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    public OkHttpWebsocketSession(@NotNull OkHttpClient engine, @NotNull Request engineRequest, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkParameterIsNotNull((Object)engine, (String)"engine");
        Intrinsics.checkParameterIsNotNull((Object)engineRequest, (String)"engineRequest");
        Intrinsics.checkParameterIsNotNull((Object)coroutineContext, (String)"coroutineContext");
        this.engine = engine;
        this.coroutineContext = coroutineContext;
        this.self = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.originResponse = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this._incoming = ChannelKt.Channel$default((int)0, (int)1, null);
        this._closeReason = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.outgoing = ActorKt.actor$default((CoroutineScope)this, null, (int)0, null, null, (Function2)((Function2)new Function2<ActorScope<Frame>, Continuation<? super Unit>, Object>(this, engineRequest, null){
            private ActorScope p$;
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ OkHttpWebsocketSession this$0;
            final /* synthetic */ Request $engineRequest;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $this$actor = this.p$;
                        var10_4 /* !! */  = this.$engineRequest;
                        var9_5 = OkHttpWebsocketSession.access$getEngine$p(this.this$0);
                        this.L$0 = $this$actor;
                        this.L$1 = var9_5;
                        this.L$2 = var10_4 /* !! */ ;
                        this.label = 1;
                        v0 = OkHttpWebsocketSession.access$getSelf$p(this.this$0).await((Continuation)this);
                        if (v0 == var12_2) {
                            return var12_2;
                        }
                        ** GOTO lbl22
                    }
                    case 1: {
                        var10_4 /* !! */  = (Request)this.L$2;
                        var9_5 = (OkHttpClient)this.L$1;
                        $this$actor = (ActorScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl22:
                        // 2 sources

                        var11_6 = v0;
                        v1 = var9_5.newWebSocket(var10_4 /* !! */ , (WebSocketListener)var11_6);
                        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"engine.newWebSocket(engineRequest, self.await())");
                        websocket = v1;
                        try {
                            var5_8 = $this$actor.getChannel().iterator();
                        }
                        catch (Throwable var4_10) {
                            websocket.close((int)CloseReason.Codes.INTERNAL_ERROR.getCode(), "Client failure");
                            throw var4_10;
                        }
lbl34:
                        // 3 sources

                        while (true) {
                            this.L$0 = $this$actor;
                            this.L$1 = websocket;
                            this.L$2 = var5_8;
                            this.label = 2;
                            v2 = var5_8.hasNext((Continuation)this);
                            if (v2 == var12_2) {
                                return var12_2;
                            }
                            ** GOTO lbl50
                            break;
                        }
                    }
                    case 2: {
                        var5_8 = (ChannelIterator)this.L$2;
                        websocket = (WebSocket)this.L$1;
                        $this$actor = (ActorScope)this.L$0;
                        {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl50:
                            // 2 sources

                            if (!((Boolean)v2).booleanValue()) ** GOTO lbl77
                            frame = (Frame)var5_8.next();
                            var6_11 = frame;
                            if (!(var6_11 instanceof Frame.Binary)) ** GOTO lbl57
                            websocket.send(ByteString.of((byte[])frame.getData(), (int)0, (int)frame.getData().length));
                            ** GOTO lbl34
lbl57:
                            // 1 sources

                            if (var6_11 instanceof Frame.Text) {
                                var7_12 = frame.getData();
                                var9_5 = websocket;
                                var8_13 = false;
                                var10_4 /* !! */  = new String(var7_12, Charsets.UTF_8);
                                var9_5.send((String)var10_4 /* !! */ );
                                ** continue;
                            }
                            if (!(var6_11 instanceof Frame.Close)) ** GOTO lbl-1000
                            v3 = FrameCommonKt.readReason((Frame.Close)((Frame.Close)frame));
                            if (v3 == null) {
                                Intrinsics.throwNpe();
                            }
                            reason = v3;
                            websocket.close((int)reason.getCode(), reason.getMessage());
                            var8_14 = Unit.INSTANCE;
                        }
                        websocket.close((int)CloseReason.Codes.INTERNAL_ERROR.getCode(), "Client failure");
                        return var8_14;
lbl-1000:
                        // 1 sources

                        {
                            throw (Throwable)new UnsupportedFrameTypeException(frame);
                        }
lbl77:
                        // 1 sources

                        websocket.close((int)CloseReason.Codes.INTERNAL_ERROR.getCode(), "Client failure");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = okHttpWebsocketSession;
                this.$engineRequest = request;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<ActorScope<Frame>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                ActorScope actorScope = function2.p$ = (ActorScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)15, null);
    }

    @Nullable
    public Object send(@NotNull Frame frame, @NotNull Continuation<? super Unit> continuation) {
        return DefaultWebSocketSession.DefaultImpls.send((DefaultWebSocketSession)this, (Frame)frame, continuation);
    }

    public static final /* synthetic */ OkHttpClient access$getEngine$p(OkHttpWebsocketSession $this) {
        return $this.engine;
    }

    public static final /* synthetic */ CompletableDeferred access$getSelf$p(OkHttpWebsocketSession $this) {
        return $this.self;
    }
}

