/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.engine.apache;

import io.ktor.client.call.HttpClientCall;
import io.ktor.client.response.HttpResponse;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpProtocolVersion;
import io.ktor.http.HttpStatusCode;
import io.ktor.util.date.DateJvmKt;
import io.ktor.util.date.GMTDate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.experimental.CompletableDeferred;
import kotlinx.coroutines.experimental.io.ByteReadChannel;
import org.apache.http.Header;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B5\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010$\u001a\u00020\bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006%"}, d2={"Lio/ktor/client/engine/apache/ApacheHttpResponse;", "Lio/ktor/client/response/HttpResponse;", "call", "Lio/ktor/client/call/HttpClientCall;", "requestTime", "Lio/ktor/util/date/GMTDate;", "executionContext", "Lkotlinx/coroutines/experimental/CompletableDeferred;", "", "engineResponse", "Lorg/apache/http/HttpResponse;", "content", "Lkotlinx/coroutines/experimental/io/ByteReadChannel;", "(Lio/ktor/client/call/HttpClientCall;Lio/ktor/util/date/GMTDate;Lkotlinx/coroutines/experimental/CompletableDeferred;Lorg/apache/http/HttpResponse;Lkotlinx/coroutines/experimental/io/ByteReadChannel;)V", "getCall", "()Lio/ktor/client/call/HttpClientCall;", "getContent", "()Lkotlinx/coroutines/experimental/io/ByteReadChannel;", "getExecutionContext", "()Lkotlinx/coroutines/experimental/CompletableDeferred;", "headers", "Lio/ktor/http/Headers;", "getHeaders", "()Lio/ktor/http/Headers;", "getRequestTime", "()Lio/ktor/util/date/GMTDate;", "responseTime", "getResponseTime", "status", "Lio/ktor/http/HttpStatusCode;", "getStatus", "()Lio/ktor/http/HttpStatusCode;", "version", "Lio/ktor/http/HttpProtocolVersion;", "getVersion", "()Lio/ktor/http/HttpProtocolVersion;", "close", "ktor-client-apache"})
public final class ApacheHttpResponse
implements HttpResponse {
    @NotNull
    private final HttpStatusCode status;
    @NotNull
    private final HttpProtocolVersion version;
    @NotNull
    private final Headers headers;
    @NotNull
    private final GMTDate responseTime;
    @NotNull
    private final HttpClientCall call;
    @NotNull
    private final GMTDate requestTime;
    @NotNull
    private final CompletableDeferred<Unit> executionContext;
    private final org.apache.http.HttpResponse engineResponse;
    @NotNull
    private final ByteReadChannel content;

    @NotNull
    public HttpStatusCode getStatus() {
        return this.status;
    }

    @NotNull
    public HttpProtocolVersion getVersion() {
        return this.version;
    }

    @NotNull
    public Headers getHeaders() {
        return this.headers;
    }

    @NotNull
    public GMTDate getResponseTime() {
        return this.responseTime;
    }

    public void close() {
        this.getExecutionContext().complete((Object)Unit.INSTANCE);
    }

    @NotNull
    public HttpClientCall getCall() {
        return this.call;
    }

    @NotNull
    public GMTDate getRequestTime() {
        return this.requestTime;
    }

    @NotNull
    public CompletableDeferred<Unit> getExecutionContext() {
        return this.executionContext;
    }

    @NotNull
    public ByteReadChannel getContent() {
        return this.content;
    }

    public ApacheHttpResponse(@NotNull HttpClientCall call, @NotNull GMTDate requestTime, @NotNull CompletableDeferred<Unit> executionContext, @NotNull org.apache.http.HttpResponse engineResponse, @NotNull ByteReadChannel content) {
        HeadersBuilder headersBuilder;
        HttpProtocolVersion httpProtocolVersion;
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)requestTime, (String)"requestTime");
        Intrinsics.checkParameterIsNotNull(executionContext, (String)"executionContext");
        Intrinsics.checkParameterIsNotNull((Object)engineResponse, (String)"engineResponse");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        this.call = call;
        this.requestTime = requestTime;
        this.executionContext = executionContext;
        this.engineResponse = engineResponse;
        this.content = content;
        this.responseTime = DateJvmKt.GMTDate$default(null, (int)1, null);
        StatusLine statusLine = this.engineResponse.getStatusLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"engineResponse.statusLine");
        int code = statusLine.getStatusCode();
        this.status = HttpStatusCode.Companion.fromValue(code);
        ProtocolVersion protocolVersion = this.engineResponse.getProtocolVersion();
        ApacheHttpResponse apacheHttpResponse = this;
        ProtocolVersion $receiver = protocolVersion;
        String string = $receiver.getProtocol();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"protocol");
        apacheHttpResponse.version = httpProtocolVersion = HttpProtocolVersion.Companion.fromValue(string, $receiver.getMajor(), $receiver.getMinor());
        protocolVersion = Headers.Companion;
        apacheHttpResponse = this;
        HeadersBuilder $receiver2 = headersBuilder = new HeadersBuilder(0, 1, null);
        Header[] headerArray = this.engineResponse.getAllHeaders();
        Intrinsics.checkExpressionValueIsNotNull((Object)headerArray, (String)"engineResponse.allHeaders");
        Header[] $receiver$iv = headerArray;
        int n = $receiver$iv.length;
        for (int i = 0; i < n; ++i) {
            Header element$iv;
            Header headerLine;
            Header header = headerLine = (element$iv = $receiver$iv[i]);
            Intrinsics.checkExpressionValueIsNotNull((Object)header, (String)"headerLine");
            String string2 = header.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"headerLine.name");
            String string3 = headerLine.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"headerLine.value");
            $receiver2.append(string2, string3);
        }
        httpProtocolVersion = headersBuilder.build();
        apacheHttpResponse.headers = httpProtocolVersion;
    }
}

