/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.incrementals.maven;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="reincrementalify", requiresDirectInvocation=true, aggregator=true)
public class ReincrementalifyMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String version = this.project.getVersion();
        Properties properties = this.project.getProperties();
        String noop = "NOOP";
        String revision = properties.getProperty("revision", noop);
        String changelist = properties.getProperty("changelist", noop);
        if (noop.equals(revision) || noop.equals(changelist)) {
            throw new MojoExecutionException((Object)this, "Cannot use reincrementalify before incrementals is enabled", "Please use 'incrementals:incrementalify' to enable incrementals");
        }
        Matcher m = Pattern.compile("(.+)-SNAPSHOT").matcher(version);
        if (!m.matches()) {
            throw new MojoFailureException("Unexpected version: " + version);
        }
        properties.setProperty("dollar", "$");
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)"org.codehaus.mojo", (String)"versions-maven-plugin", (String)"2.5"), (String)"set", (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"newVersion", (String)"${dollar}{revision}${dollar}{changelist}"), MojoExecutor.element((String)"generateBackupPoms", (String)"false")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)"org.codehaus.mojo", (String)"versions-maven-plugin", (String)"2.5"), (String)"set-property", (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"property", (String)"revision"), MojoExecutor.element((String)"newVersion", (String)m.group(1)), MojoExecutor.element((String)"generateBackupPoms", (String)"false")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
    }
}

