/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import android.content.SharedPreferences;
import io.intercom.android.sdk.preview.IntercomPreviewPosition;

public class Prefs {
    private static final String PRESENTATION_MODE = "PresentationMode";

    public static void setPresentationMode(IntercomPreviewPosition mode, Context context) {
        SharedPreferences.Editor editor = Prefs.getPrefs("INTERCOM_SDK_PREFS", context).edit();
        if (mode == null) {
            editor.remove(PRESENTATION_MODE);
        } else {
            editor.putString(PRESENTATION_MODE, mode.toString());
        }
        editor.apply();
    }

    public static IntercomPreviewPosition getPresentationMode(Context context) {
        SharedPreferences settings = Prefs.getPrefs("INTERCOM_SDK_PREFS", context);
        String myEnumString = settings.getString(PRESENTATION_MODE, IntercomPreviewPosition.BOTTOM_LEFT.toString());
        return IntercomPreviewPosition.toPresentationModeEnum(myEnumString);
    }

    public static boolean isLeftAligned(Context context) {
        IntercomPreviewPosition presentationMode = Prefs.getPresentationMode(context);
        switch (presentationMode) {
            case BOTTOM_LEFT: {
                return true;
            }
            case TOP_LEFT: {
                return true;
            }
        }
        return false;
    }

    private static SharedPreferences getPrefs(String preferenceName, Context context) {
        return context.getSharedPreferences(preferenceName, 0);
    }
}

