/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import io.intercom.android.sdk.logger.Logger;
import java.util.List;
import java.util.Map;

public class AttributeValidator {
    private static final String CUSTOM_ATTRIBUTES = "custom_attributes";
    private static final String COMPANIES = "companies";

    public static boolean isValidAttributes(Map<String, Object> attributes) {
        return AttributeValidator.isValidMap(attributes);
    }

    private static boolean isValidMap(Map attributes) {
        for (Map.Entry object : attributes.entrySet()) {
            Map.Entry pair = object;
            if (pair.getKey() instanceof String) {
                if (CUSTOM_ATTRIBUTES.equals(pair.getKey())) {
                    if (AttributeValidator.isValidCustomAttributes(attributes)) continue;
                    return false;
                }
                if (COMPANIES.equals(pair.getKey())) {
                    if (AttributeValidator.isValidCompanyAttributes(attributes)) continue;
                    return false;
                }
                if (pair.getValue() instanceof Number || pair.getValue() instanceof Boolean || pair.getValue() instanceof String) continue;
                Logger.ERROR("The attribute " + pair.getValue() + " is not a number, string or boolean.");
                return false;
            }
            Logger.ERROR("The key " + pair.getKey() + " is not of type string.");
            return false;
        }
        return true;
    }

    private static boolean isValidCustomAttributes(Map attributes) {
        if (attributes.containsKey(CUSTOM_ATTRIBUTES)) {
            Object customAttributes = attributes.get(CUSTOM_ATTRIBUTES);
            if (customAttributes instanceof Map) {
                return AttributeValidator.isValidMap((Map)customAttributes);
            }
            Logger.ERROR("The custom_attribute key must contain a value that is of type Map.");
            return false;
        }
        return true;
    }

    private static boolean isValidCompanyAttributes(Map attributes) {
        if (attributes.containsKey(COMPANIES)) {
            Object companyObject = attributes.get(COMPANIES);
            if (companyObject instanceof List) {
                List companies = (List)companyObject;
                for (Object element : companies) {
                    if (element instanceof Map) {
                        if (AttributeValidator.isValidMap((Map)element)) continue;
                        return false;
                    }
                    Logger.ERROR("All company objects in the list must be of type Map.");
                    return false;
                }
            } else {
                Logger.ERROR("The companies key must contain a value that is of type List.");
                return false;
            }
        }
        return true;
    }
}

