/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import io.intercom.android.blocks.BlockType;
import io.intercom.android.blocks.Blocks;
import io.intercom.android.blocks.BlocksViewHolder;
import io.intercom.android.blocks.models.Block;
import io.intercom.android.blocks.models.BlockAttachment;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.LightWeightReply;
import io.intercom.android.sdk.blocks.ViewHolderGenerator;
import io.intercom.android.sdk.interfaces.LWRListener;
import io.intercom.android.sdk.interfaces.OnSmallAnnouncementInteractionListener;
import io.intercom.android.sdk.models.APIModels.Part;
import io.intercom.android.sdk.models.APIModels.Participant;
import io.intercom.android.sdk.models.Attachments;
import io.intercom.android.sdk.models.Events.CloseIAMEvent;
import io.intercom.android.sdk.models.Events.ReadEvent;
import io.intercom.android.sdk.models.LWR;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.ScreenUtils;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;

@TargetApi(value=15)
public class SmallAnnouncementFragment
extends Fragment
implements View.OnClickListener,
LWRListener {
    private static final String ARG_CONVERSATION_ID = "conversationArg";
    private static final String ARG_PART = "partArg";
    private static final int MAX_HEIGHT_DP = 190;
    private static final int LWR_HEIGHT_DP = 55;
    private OnSmallAnnouncementInteractionListener mListener;
    private Part smallAnnouncement;
    private BlocksViewHolder blocksAnnouncementViewHolder;
    private String conversationId;
    private List<Part> conversationParts;
    private ViewHolderGenerator generator;
    private Blocks blocks;
    private View rootView;
    private View touchInterceptor;

    public static SmallAnnouncementFragment newInstance(String conversationId, Part part) {
        SmallAnnouncementFragment fragment = new SmallAnnouncementFragment();
        Bundle args = new Bundle();
        args.putString(ARG_CONVERSATION_ID, conversationId);
        args.putParcelable(ARG_PART, (Parcelable)part);
        fragment.setArguments(args);
        return fragment;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.mListener = (OnSmallAnnouncementInteractionListener)activity;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + " must implement OnSmallAnnouncementInteractionListener");
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bridge.init(this.getActivity().getApplicationContext());
        this.conversationParts = new ArrayList<Part>();
        Bundle args = this.getArguments();
        if (args != null) {
            this.generator = new ViewHolderGenerator((Context)this.getActivity());
            this.blocksAnnouncementViewHolder = this.generator.getAnnouncementPreviewHolder(this);
            this.smallAnnouncement = (Part)args.getParcelable(ARG_PART);
            this.conversationId = args.getString(ARG_CONVERSATION_ID);
            this.conversationParts.add(this.smallAnnouncement);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.rootView == null) {
            this.rootView = inflater.inflate(R.layout.intercomsdk_fragment_small_announcement, container, false);
        } else {
            ViewGroup parent = (ViewGroup)this.rootView.getParent();
            if (parent != null) {
                parent.removeView(this.rootView);
            }
        }
        this.touchInterceptor = this.rootView.findViewById(R.id.touchInterceptor);
        this.blocks = new Blocks((Context)this.getActivity());
        ImageButton closeButton = (ImageButton)this.rootView.findViewById(R.id.close_button);
        closeButton.setOnClickListener((View.OnClickListener)this);
        this.displaySmallAnnouncement();
        return this.rootView;
    }

    private void displaySmallAnnouncement() {
        this.rootView.setOnClickListener((View.OnClickListener)this);
        this.createSmallAnnouncementUI();
        ImageButton closeButton = (ImageButton)this.rootView.findViewById(R.id.close_button);
        closeButton.setOnClickListener((View.OnClickListener)this);
        LinearLayout containerView = (LinearLayout)this.rootView.findViewById(R.id.announcement);
        final View view = this.getBlockView((ViewGroup)containerView);
        containerView.addView(view);
        view.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                SmallAnnouncementFragment.this.addBottomBorder(SmallAnnouncementFragment.this.smallAnnouncement, view);
                SmallAnnouncementFragment.this.setUpTouchInterceptor(view);
            }
        });
        Bridge.getApi().markConversationAsRead(this.conversationId);
        Bridge.getBus().post((Object)new ReadEvent(this.conversationId));
    }

    private void createSmallAnnouncementUI() {
        List<Block> blockParts = this.smallAnnouncement.getBlocks();
        if (!this.smallAnnouncement.getAttachments().isEmpty()) {
            ArrayList<BlockAttachment> blockAttachments = new ArrayList<BlockAttachment>();
            for (Attachments attachment : this.smallAnnouncement.getAttachments()) {
                blockAttachments.add(new BlockAttachment.Builder().withName(attachment.getName()).withUrl(attachment.getUrl()).build());
            }
            Block attachmentBlock = new Block.Builder().withType(BlockType.attachmentList.name()).withAttachments(blockAttachments).build();
            blockParts.add(attachmentBlock);
        }
        if (!(this.smallAnnouncement.getLightweightReply() instanceof LWR.NullLWR)) {
            Block lwrBlock = new Block.Builder().withType(BlockType.lwr.name()).withText(this.smallAnnouncement.getLightweightReply().getType()).build();
            blockParts.add(lwrBlock);
            LightWeightReply announcementLWR = (LightWeightReply)this.blocksAnnouncementViewHolder.getLwr();
            announcementLWR.setLwrObject(this.smallAnnouncement.getLightweightReply());
        }
        if (!blockParts.isEmpty()) {
            this.smallAnnouncement.setLayout(this.blocks.createBlocks(blockParts, this.blocksAnnouncementViewHolder));
        }
    }

    private View getBlockView(ViewGroup parent) {
        LayoutInflater inflater = LayoutInflater.from((Context)this.getActivity());
        View row = inflater.inflate((XmlPullParser)this.getActivity().getResources().getLayout(R.layout.intercomsdk_row_small_announcement), parent, false);
        ImageView networkAvatar = (ImageView)row.findViewById(R.id.avatarView);
        LinearLayout cellLayout = (LinearLayout)row.findViewById(R.id.cellLayout);
        LinearLayout blocks = this.smallAnnouncement.getLayout();
        if (blocks.getParent() != null) {
            ((LinearLayout)blocks.getParent()).removeView((View)blocks);
        }
        if (cellLayout.getChildCount() > 0) {
            cellLayout.removeAllViews();
        }
        cellLayout.addView((View)blocks, 0);
        row.setFocusable(false);
        cellLayout.setVisibility(0);
        Participant user = this.smallAnnouncement.getParticipant();
        networkAvatar.setVisibility(0);
        AvatarUtils.createAvatar(user.getAvatar(), networkAvatar, (Context)this.getActivity());
        return row;
    }

    private void addBottomBorder(Part smallAnnouncement, View messageView) {
        View fadeView = this.rootView.findViewById(R.id.white_fade);
        View roundBottom = this.rootView.findViewById(R.id.round_bottom);
        LinearLayout content = (LinearLayout)messageView.findViewById(R.id.cell_content);
        if (fadeView.getVisibility() != 0) {
            if (ScreenUtils.convertPixelsToDp(content.getMeasuredHeight(), (Context)this.getActivity()) == 190) {
                fadeView.setVisibility(0);
                roundBottom.setVisibility(0);
            } else {
                fadeView.setVisibility(4);
                roundBottom.setVisibility(4);
            }
            messageView.findViewById(R.id.buttonLayout).bringToFront();
        }
    }

    private void setUpTouchInterceptor(View messageView) {
        View fadeView = this.rootView.findViewById(R.id.white_fade);
        LinearLayout content = (LinearLayout)messageView.findViewById(R.id.cell_content);
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.touchInterceptor.getLayoutParams();
        params.height = content.getMeasuredHeight();
        if (fadeView.getVisibility() != 0 && !(this.smallAnnouncement.getLightweightReply() instanceof LWR.NullLWR)) {
            params.height -= ScreenUtils.convertDpToPixel(55.0f, (Context)this.getActivity());
        }
        this.touchInterceptor.setLayoutParams((ViewGroup.LayoutParams)params);
        this.touchInterceptor.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.touchInterceptor) {
            this.transitionToFullConversation();
        } else if (v.getId() == R.id.close_button || v.getId() == R.id.announcementRootView) {
            Bridge.getBus().post((Object)new CloseIAMEvent());
        }
    }

    private void transitionToFullConversation() {
        this.mListener.transitionToConversation(this.conversationId);
    }

    @Override
    public void sendLWRResponse(LWR lwr) {
        Bridge.getApi().sendLWRResponse(this.conversationId, lwr.getType(), lwr.getOption());
    }
}

