/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.text.TextUtils;
import com.bumptech.glide.load.engine.DiskCacheStrategy;

public class ImageUtils {
    public static double getAspectRatio(int imageWidth, int imageHeight) {
        double aspectRatio = 1.0 * (double)imageHeight / (double)imageWidth;
        if (Double.isNaN(aspectRatio)) {
            aspectRatio = 0.0;
        }
        return aspectRatio;
    }

    public static int getAspectHeight(int imageWidth, double aspectRatio) {
        return (int)((double)imageWidth * aspectRatio);
    }

    public static DiskCacheStrategy getDiskCacheStrategy(String url) {
        return ImageUtils.isGif(url) ? DiskCacheStrategy.DATA : DiskCacheStrategy.RESOURCE;
    }

    public static boolean isGif(String url) {
        return !TextUtils.isEmpty((CharSequence)url) && url.endsWith(".gif");
    }
}

