/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.intercom.commons.utilities.CollectionUtils;
import io.intercom.android.sdk.models.AutoValue_ComposerSuggestions;
import io.intercom.android.sdk.models.Prompt;
import io.intercom.android.sdk.models.Suggestion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@AutoValue
public abstract class ComposerSuggestions
implements Parcelable {
    public static final ComposerSuggestions NULL = ComposerSuggestions.create("null", Collections.emptyList(), false);
    public static final ComposerSuggestions UNKNOWN = ComposerSuggestions.create("unknown", Collections.emptyList(), true);
    public static final Parcelable.Creator<ComposerSuggestions> CREATOR = new Parcelable.Creator<ComposerSuggestions>(){

        public ComposerSuggestions createFromParcel(Parcel in) {
            String prompt = in.readString();
            ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
            in.readList(suggestions, Suggestion.class.getClassLoader());
            boolean composerDisabled = in.readInt() == 1;
            return ComposerSuggestions.create(prompt, suggestions, composerDisabled);
        }

        public ComposerSuggestions[] newArray(int size) {
            return new ComposerSuggestions[size];
        }
    };

    public static ComposerSuggestions create(String prompt, List<Suggestion> suggestions, boolean isComposerDisabled) {
        return new AutoValue_ComposerSuggestions(prompt, suggestions, isComposerDisabled);
    }

    public abstract String getPrompt();

    public abstract List<Suggestion> getSuggestions();

    public abstract boolean isComposerDisabled();

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getPrompt());
        dest.writeList(this.getSuggestions());
        dest.writeInt(this.isComposerDisabled() ? 1 : 0);
    }

    public static final class Builder {
        @Nullable
        List<Prompt.Builder> prompt;
        @Nullable
        List<Suggestion.Builder> suggestions;
        boolean composer_disabled;

        public Builder withPrompts(List<Prompt.Builder> prompt) {
            this.prompt = prompt;
            return this;
        }

        public Builder withSuggestions(List<Suggestion.Builder> suggestions) {
            this.suggestions = suggestions;
            return this;
        }

        public Builder withComposerDisabled(boolean composerDisabled) {
            this.composer_disabled = composerDisabled;
            return this;
        }

        public ComposerSuggestions build() {
            ArrayList<Prompt> prompts = new ArrayList<Prompt>(CollectionUtils.capacityFor(this.prompt));
            ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>(CollectionUtils.capacityFor(this.suggestions));
            if (this.prompt != null) {
                for (Prompt.Builder promptBuilder : this.prompt) {
                    if (promptBuilder == null) continue;
                    prompts.add(promptBuilder.build());
                }
            }
            if (this.suggestions != null) {
                for (Suggestion.Builder suggestionsBuilder : this.suggestions) {
                    if (suggestionsBuilder == null) continue;
                    suggestions.add(suggestionsBuilder.build());
                }
            }
            String promptText = prompts.isEmpty() ? "" : ((Prompt)prompts.get(0)).getPromptText();
            return ComposerSuggestions.create(promptText, suggestions, this.composer_disabled);
        }
    }
}

