/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation.composer.galleryinput;

import android.content.Context;
import android.graphics.drawable.Drawable;
import com.intercom.composer.Creator;
import com.intercom.composer.input.IconProvider;
import com.intercom.composer.input.Input;
import com.intercom.input.gallery.GalleryImage;
import com.intercom.input.gallery.GalleryInput;
import com.intercom.input.gallery.GalleryInputExpandedListener;
import com.intercom.input.gallery.GalleryInputFragment;
import com.intercom.input.gallery.GalleryOutputListener;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.composer.ComposerPresenter;
import io.intercom.android.sdk.conversation.composer.InputDrawableManager;
import io.intercom.android.sdk.conversation.composer.galleryinput.GifInputFragment;
import io.intercom.android.sdk.conversation.composer.galleryinput.LocalGalleryInputFragment;
import io.intercom.android.sdk.metrics.MetricTracker;

public class GalleryInputManager {
    private final Drawable galleryIcon;
    private final Drawable gifIcon;
    private final ComposerPresenter.Listener listener;
    private final MetricTracker metricTracker;
    private String conversationId;

    public GalleryInputManager(Context context, InputDrawableManager inputDrawableManager, ComposerPresenter.Listener listener, MetricTracker metricTracker, String conversationId) {
        this.listener = listener;
        this.metricTracker = metricTracker;
        this.conversationId = conversationId;
        this.galleryIcon = inputDrawableManager.createDrawable(context, R.drawable.intercom_input_gallery);
        this.gifIcon = inputDrawableManager.createDrawable(context, R.drawable.intercom_input_gif);
    }

    public Input createGalleryInput() {
        IconProvider iconProvider = new IconProvider(){

            public Drawable getIconDrawable(String inputIdentifier, Context context) {
                return GalleryInputManager.this.galleryIcon;
            }
        };
        GalleryOutputListener outputListener = new GalleryOutputListener(){

            public void onGalleryOutputReceived(GalleryImage galleryImage) {
                GalleryInputManager.this.listener.onUploadImageSelected(galleryImage);
            }
        };
        GalleryInputExpandedListener galleryInputExpandedListener = new GalleryInputExpandedListener(){

            public void onInputExpanded() {
                GalleryInputManager.this.metricTracker.expandedInput(GalleryInputManager.this.conversationId);
            }
        };
        Creator<GalleryInputFragment> fragmentCreator = new Creator<GalleryInputFragment>(){

            public GalleryInputFragment create() {
                return new LocalGalleryInputFragment();
            }
        };
        return new GalleryInput("gallery_input", iconProvider, outputListener, galleryInputExpandedListener, (Creator)fragmentCreator);
    }

    public Input createGifInput() {
        IconProvider iconProvider = new IconProvider(){

            public Drawable getIconDrawable(String inputIdentifier, Context context) {
                return GalleryInputManager.this.gifIcon;
            }
        };
        GalleryOutputListener outputListener = new GalleryOutputListener(){

            public void onGalleryOutputReceived(GalleryImage galleryImage) {
                GalleryInputManager.this.listener.onRemoteImageSelected(galleryImage);
            }
        };
        GalleryInputExpandedListener galleryInputExpandedListener = new GalleryInputExpandedListener(){

            public void onInputExpanded() {
                GalleryInputManager.this.metricTracker.expandedInput(GalleryInputManager.this.conversationId);
            }
        };
        Creator<GalleryInputFragment> fragmentCreator = new Creator<GalleryInputFragment>(){

            public GalleryInputFragment create() {
                return new GifInputFragment();
            }
        };
        return new GalleryInput("gif_input", iconProvider, outputListener, galleryInputExpandedListener, (Creator)fragmentCreator);
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }
}

