/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.inbox;

import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.VisibleForTesting;
import androidx.recyclerview.widget.RecyclerView;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.inbox.ConversationClickListener;
import io.intercom.android.sdk.inbox.InboxRowViewHolder;
import io.intercom.android.sdk.inbox.LoadingViewHolder;
import io.intercom.android.sdk.state.InboxState;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.views.InboxRowLayout;
import io.intercom.com.bumptech.glide.RequestManager;
import java.util.Locale;

class InboxAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @VisibleForTesting
    static final int CONVERSATION = 0;
    @VisibleForTesting
    static final int LOADING = 1;
    private final LayoutInflater inflater;
    private final ConversationClickListener conversationClickListener;
    private final Store<State> store;
    private final TimeFormatter timeFormatter;
    private final Provider<AppConfig> appConfigProvider;
    private InboxState inboxState;
    private UserIdentity userIdentity;
    private final RequestManager requestManager;

    InboxAdapter(LayoutInflater inflater, ConversationClickListener conversationClickListener, Store<State> store, TimeFormatter timeFormatter, Provider<AppConfig> appConfigProvider, UserIdentity userIdentity, RequestManager requestManager) {
        this.inflater = inflater;
        this.conversationClickListener = conversationClickListener;
        this.store = store;
        this.timeFormatter = timeFormatter;
        this.appConfigProvider = appConfigProvider;
        this.userIdentity = userIdentity;
        this.requestManager = requestManager;
        this.setHasStableIds(true);
    }

    void setInboxState(InboxState inboxState) {
        this.inboxState = inboxState;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 0) {
            InboxRowLayout inboxRowLayout = new InboxRowLayout(parent.getContext());
            inboxRowLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
            return new InboxRowViewHolder(inboxRowLayout, this.conversationClickListener, this.timeFormatter, this.requestManager);
        }
        if (viewType == 1) {
            return new LoadingViewHolder(this.inflater.inflate(R.layout.intercom_row_loading, parent, false));
        }
        throw new RuntimeException(String.format(Locale.getDefault(), "View type %d not supported", viewType));
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof InboxRowViewHolder) {
            InboxRowViewHolder viewHolder = (InboxRowViewHolder)holder;
            viewHolder.bindData(this.inboxState.conversations().get(position), this.userIdentity, this.appConfigProvider.get(), this.store.select(Selectors.TEAM_PRESENCE));
        }
    }

    public int getItemCount() {
        return this.conversationCount() + (this.inboxState.status() == InboxState.Status.LOADING ? 1 : 0);
    }

    public int getItemViewType(int position) {
        return position == this.conversationCount() ? 1 : 0;
    }

    public long getItemId(int position) {
        if (position == this.conversationCount()) {
            return -1L;
        }
        String id2 = this.inboxState.conversations().get(position).getId();
        long result = !TextUtils.isEmpty((CharSequence)id2) && TextUtils.isDigitsOnly((CharSequence)id2) ? Long.valueOf(id2) : (long)id2.hashCode();
        return result;
    }

    private int conversationCount() {
        return this.inboxState.conversations().size();
    }
}

