/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.CheckResult;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RawRes;
import android.widget.ImageView;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.GlideContext;
import io.intercom.com.bumptech.glide.ModelTypes;
import io.intercom.com.bumptech.glide.Priority;
import io.intercom.com.bumptech.glide.RequestManager;
import io.intercom.com.bumptech.glide.TransitionOptions;
import io.intercom.com.bumptech.glide.load.engine.DiskCacheStrategy;
import io.intercom.com.bumptech.glide.request.ErrorRequestCoordinator;
import io.intercom.com.bumptech.glide.request.FutureTarget;
import io.intercom.com.bumptech.glide.request.Request;
import io.intercom.com.bumptech.glide.request.RequestCoordinator;
import io.intercom.com.bumptech.glide.request.RequestFutureTarget;
import io.intercom.com.bumptech.glide.request.RequestListener;
import io.intercom.com.bumptech.glide.request.RequestOptions;
import io.intercom.com.bumptech.glide.request.SingleRequest;
import io.intercom.com.bumptech.glide.request.ThumbnailRequestCoordinator;
import io.intercom.com.bumptech.glide.request.target.PreloadTarget;
import io.intercom.com.bumptech.glide.request.target.Target;
import io.intercom.com.bumptech.glide.request.target.ViewTarget;
import io.intercom.com.bumptech.glide.signature.ApplicationVersionSignature;
import io.intercom.com.bumptech.glide.util.Preconditions;
import io.intercom.com.bumptech.glide.util.Util;
import java.io.File;
import java.net.URL;

public class RequestBuilder<TranscodeType>
implements Cloneable,
ModelTypes<RequestBuilder<TranscodeType>> {
    protected static final RequestOptions DOWNLOAD_ONLY_OPTIONS = new RequestOptions().diskCacheStrategy(DiskCacheStrategy.DATA).priority(Priority.LOW).skipMemoryCache(true);
    private final Context context;
    private final RequestManager requestManager;
    private final Class<TranscodeType> transcodeClass;
    private final RequestOptions defaultRequestOptions;
    private final Glide glide;
    private final GlideContext glideContext;
    @NonNull
    protected RequestOptions requestOptions;
    @NonNull
    private TransitionOptions<?, ? super TranscodeType> transitionOptions;
    @Nullable
    private Object model;
    @Nullable
    private RequestListener<TranscodeType> requestListener;
    @Nullable
    private RequestBuilder<TranscodeType> thumbnailBuilder;
    @Nullable
    private RequestBuilder<TranscodeType> errorBuilder;
    @Nullable
    private Float thumbSizeMultiplier;
    private boolean isDefaultTransitionOptionsSet = true;
    private boolean isModelSet;
    private boolean isThumbnailBuilt;

    protected RequestBuilder(Glide glide, RequestManager requestManager, Class<TranscodeType> transcodeClass, Context context) {
        this.glide = glide;
        this.requestManager = requestManager;
        this.transcodeClass = transcodeClass;
        this.defaultRequestOptions = requestManager.getDefaultRequestOptions();
        this.context = context;
        this.transitionOptions = requestManager.getDefaultTransitionOptions(transcodeClass);
        this.requestOptions = this.defaultRequestOptions;
        this.glideContext = glide.getGlideContext();
    }

    protected RequestBuilder(Class<TranscodeType> transcodeClass, RequestBuilder<?> other) {
        this(other.glide, other.requestManager, transcodeClass, other.context);
        this.model = other.model;
        this.isModelSet = other.isModelSet;
        this.requestOptions = other.requestOptions;
    }

    @CheckResult
    public RequestBuilder<TranscodeType> apply(@NonNull RequestOptions requestOptions) {
        Preconditions.checkNotNull(requestOptions);
        this.requestOptions = this.getMutableOptions().apply(requestOptions);
        return this;
    }

    protected RequestOptions getMutableOptions() {
        return this.defaultRequestOptions == this.requestOptions ? this.requestOptions.clone() : this.requestOptions;
    }

    @CheckResult
    public RequestBuilder<TranscodeType> transition(@NonNull TransitionOptions<?, ? super TranscodeType> transitionOptions) {
        this.transitionOptions = Preconditions.checkNotNull(transitionOptions);
        this.isDefaultTransitionOptionsSet = false;
        return this;
    }

    @CheckResult
    public RequestBuilder<TranscodeType> listener(@Nullable RequestListener<TranscodeType> requestListener) {
        this.requestListener = requestListener;
        return this;
    }

    public RequestBuilder<TranscodeType> error(@Nullable RequestBuilder<TranscodeType> errorBuilder) {
        this.errorBuilder = errorBuilder;
        return this;
    }

    @CheckResult
    public RequestBuilder<TranscodeType> thumbnail(@Nullable RequestBuilder<TranscodeType> thumbnailRequest) {
        this.thumbnailBuilder = thumbnailRequest;
        return this;
    }

    @CheckResult
    public RequestBuilder<TranscodeType> thumbnail(RequestBuilder<TranscodeType> ... thumbnails) {
        if (thumbnails == null || thumbnails.length == 0) {
            return this.thumbnail((RequestBuilder<TranscodeType>)null);
        }
        RequestBuilder<TranscodeType> previous = null;
        for (int i = thumbnails.length - 1; i >= 0; --i) {
            RequestBuilder<TranscodeType> current = thumbnails[i];
            if (current == null) continue;
            previous = previous == null ? current : current.thumbnail(previous);
        }
        return this.thumbnail(previous);
    }

    @CheckResult
    public RequestBuilder<TranscodeType> thumbnail(float sizeMultiplier) {
        if (sizeMultiplier < 0.0f || sizeMultiplier > 1.0f) {
            throw new IllegalArgumentException("sizeMultiplier must be between 0 and 1");
        }
        this.thumbSizeMultiplier = Float.valueOf(sizeMultiplier);
        return this;
    }

    @Override
    @CheckResult
    public RequestBuilder<TranscodeType> load(@Nullable Object model) {
        return this.loadGeneric(model);
    }

    private RequestBuilder<TranscodeType> loadGeneric(@Nullable Object model) {
        this.model = model;
        this.isModelSet = true;
        return this;
    }

    @Override
    @CheckResult
    public RequestBuilder<TranscodeType> load(@Nullable Bitmap bitmap) {
        return this.loadGeneric(bitmap).apply(RequestOptions.diskCacheStrategyOf(DiskCacheStrategy.NONE));
    }

    @Override
    @CheckResult
    public RequestBuilder<TranscodeType> load(@Nullable Drawable drawable) {
        return this.loadGeneric(drawable).apply(RequestOptions.diskCacheStrategyOf(DiskCacheStrategy.NONE));
    }

    @Override
    @CheckResult
    public RequestBuilder<TranscodeType> load(@Nullable String string) {
        return this.loadGeneric(string);
    }

    @Override
    @CheckResult
    public RequestBuilder<TranscodeType> load(@Nullable Uri uri) {
        return this.loadGeneric(uri);
    }

    @Override
    @CheckResult
    public RequestBuilder<TranscodeType> load(@Nullable File file) {
        return this.loadGeneric(file);
    }

    @Override
    @CheckResult
    public RequestBuilder<TranscodeType> load(@RawRes @DrawableRes @Nullable Integer resourceId) {
        return this.loadGeneric(resourceId).apply(RequestOptions.signatureOf(ApplicationVersionSignature.obtain(this.context)));
    }

    @Override
    @Deprecated
    @CheckResult
    public RequestBuilder<TranscodeType> load(@Nullable URL url) {
        return this.loadGeneric(url);
    }

    @Override
    @CheckResult
    public RequestBuilder<TranscodeType> load(@Nullable byte[] model) {
        RequestBuilder<TranscodeType> result = this.loadGeneric(model);
        if (!result.requestOptions.isDiskCacheStrategySet()) {
            result = result.apply(RequestOptions.diskCacheStrategyOf(DiskCacheStrategy.NONE));
        }
        if (!result.requestOptions.isSkipMemoryCacheSet()) {
            result = result.apply(RequestOptions.skipMemoryCacheOf(true));
        }
        return result;
    }

    @CheckResult
    public RequestBuilder<TranscodeType> clone() {
        try {
            RequestBuilder result = (RequestBuilder)super.clone();
            result.requestOptions = result.requestOptions.clone();
            result.transitionOptions = result.transitionOptions.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public <Y extends Target<TranscodeType>> Y into(@NonNull Y target) {
        return this.into(target, null);
    }

    private <Y extends Target<TranscodeType>> Y into(@NonNull Y target, @Nullable RequestListener<TranscodeType> targetListener) {
        return this.into(target, targetListener, this.getMutableOptions());
    }

    private <Y extends Target<TranscodeType>> Y into(@NonNull Y target, @Nullable RequestListener<TranscodeType> targetListener, RequestOptions options) {
        Request previous;
        Util.assertMainThread();
        Preconditions.checkNotNull(target);
        if (!this.isModelSet) {
            throw new IllegalArgumentException("You must call #load() before calling #into()");
        }
        Request request = this.buildRequest(target, targetListener, options = options.autoClone());
        if (request.isEquivalentTo(previous = target.getRequest())) {
            request.recycle();
            if (!Preconditions.checkNotNull(previous).isRunning()) {
                previous.begin();
            }
            return target;
        }
        this.requestManager.clear(target);
        target.setRequest(request);
        this.requestManager.track(target, request);
        return target;
    }

    public ViewTarget<ImageView, TranscodeType> into(ImageView view) {
        Util.assertMainThread();
        Preconditions.checkNotNull(view);
        RequestOptions requestOptions = this.requestOptions;
        if (!requestOptions.isTransformationSet() && requestOptions.isTransformationAllowed() && view.getScaleType() != null) {
            switch (view.getScaleType()) {
                case CENTER_CROP: {
                    requestOptions = requestOptions.clone().optionalCenterCrop();
                    break;
                }
                case CENTER_INSIDE: {
                    requestOptions = requestOptions.clone().optionalCenterInside();
                    break;
                }
                case FIT_CENTER: 
                case FIT_START: 
                case FIT_END: {
                    requestOptions = requestOptions.clone().optionalFitCenter();
                    break;
                }
                case FIT_XY: {
                    requestOptions = requestOptions.clone().optionalCenterInside();
                    break;
                }
            }
        }
        return this.into(this.glideContext.buildImageViewTarget(view, this.transcodeClass), null, requestOptions);
    }

    @Deprecated
    public FutureTarget<TranscodeType> into(int width, int height) {
        return this.submit(width, height);
    }

    public FutureTarget<TranscodeType> submit() {
        return this.submit(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public FutureTarget<TranscodeType> submit(int width, int height) {
        final RequestFutureTarget target = new RequestFutureTarget(this.glideContext.getMainHandler(), width, height);
        if (Util.isOnBackgroundThread()) {
            this.glideContext.getMainHandler().post(new Runnable(){

                @Override
                public void run() {
                    if (!target.isCancelled()) {
                        RequestBuilder.this.into(target, target);
                    }
                }
            });
        } else {
            this.into(target, target);
        }
        return target;
    }

    public Target<TranscodeType> preload(int width, int height) {
        PreloadTarget target = PreloadTarget.obtain(this.requestManager, width, height);
        return this.into(target);
    }

    public Target<TranscodeType> preload() {
        return this.preload(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    @Deprecated
    @CheckResult
    public <Y extends Target<File>> Y downloadOnly(Y target) {
        return this.getDownloadOnlyRequest().into(target);
    }

    @Deprecated
    @CheckResult
    public FutureTarget<File> downloadOnly(int width, int height) {
        return this.getDownloadOnlyRequest().submit(width, height);
    }

    @CheckResult
    protected RequestBuilder<File> getDownloadOnlyRequest() {
        return new RequestBuilder<File>(File.class, this).apply(DOWNLOAD_ONLY_OPTIONS);
    }

    private Priority getThumbnailPriority(Priority current) {
        switch (current) {
            case LOW: {
                return Priority.NORMAL;
            }
            case NORMAL: {
                return Priority.HIGH;
            }
            case HIGH: 
            case IMMEDIATE: {
                return Priority.IMMEDIATE;
            }
        }
        throw new IllegalArgumentException("unknown priority: " + (Object)((Object)this.requestOptions.getPriority()));
    }

    private Request buildRequest(Target<TranscodeType> target, @Nullable RequestListener<TranscodeType> targetListener, RequestOptions requestOptions) {
        return this.buildRequestRecursive(target, targetListener, null, this.transitionOptions, requestOptions.getPriority(), requestOptions.getOverrideWidth(), requestOptions.getOverrideHeight(), requestOptions);
    }

    private Request buildRequestRecursive(Target<TranscodeType> target, @Nullable RequestListener<TranscodeType> targetListener, @Nullable RequestCoordinator parentCoordinator, TransitionOptions<?, ? super TranscodeType> transitionOptions, Priority priority, int overrideWidth, int overrideHeight, RequestOptions requestOptions) {
        ErrorRequestCoordinator errorRequestCoordinator = null;
        if (this.errorBuilder != null) {
            errorRequestCoordinator = new ErrorRequestCoordinator(parentCoordinator);
            parentCoordinator = errorRequestCoordinator;
        }
        Request mainRequest = this.buildThumbnailRequestRecursive(target, targetListener, parentCoordinator, transitionOptions, priority, overrideWidth, overrideHeight, requestOptions);
        if (errorRequestCoordinator == null) {
            return mainRequest;
        }
        int errorOverrideWidth = this.errorBuilder.requestOptions.getOverrideWidth();
        int errorOverrideHeight = this.errorBuilder.requestOptions.getOverrideHeight();
        if (Util.isValidDimensions(overrideWidth, overrideHeight) && !this.errorBuilder.requestOptions.isValidOverride()) {
            errorOverrideWidth = requestOptions.getOverrideWidth();
            errorOverrideHeight = requestOptions.getOverrideHeight();
        }
        Request errorRequest = super.buildRequestRecursive(target, targetListener, errorRequestCoordinator, this.errorBuilder.transitionOptions, this.errorBuilder.requestOptions.getPriority(), errorOverrideWidth, errorOverrideHeight, this.errorBuilder.requestOptions);
        errorRequestCoordinator.setRequests(mainRequest, errorRequest);
        return errorRequestCoordinator;
    }

    private Request buildThumbnailRequestRecursive(Target<TranscodeType> target, RequestListener<TranscodeType> targetListener, @Nullable RequestCoordinator parentCoordinator, TransitionOptions<?, ? super TranscodeType> transitionOptions, Priority priority, int overrideWidth, int overrideHeight, RequestOptions requestOptions) {
        if (this.thumbnailBuilder != null) {
            if (this.isThumbnailBuilt) {
                throw new IllegalStateException("You cannot use a request as both the main request and a thumbnail, consider using clone() on the request(s) passed to thumbnail()");
            }
            TransitionOptions<?, ? super TranscodeType> thumbTransitionOptions = this.thumbnailBuilder.transitionOptions;
            if (this.thumbnailBuilder.isDefaultTransitionOptionsSet) {
                thumbTransitionOptions = transitionOptions;
            }
            Priority thumbPriority = this.thumbnailBuilder.requestOptions.isPrioritySet() ? this.thumbnailBuilder.requestOptions.getPriority() : this.getThumbnailPriority(priority);
            int thumbOverrideWidth = this.thumbnailBuilder.requestOptions.getOverrideWidth();
            int thumbOverrideHeight = this.thumbnailBuilder.requestOptions.getOverrideHeight();
            if (Util.isValidDimensions(overrideWidth, overrideHeight) && !this.thumbnailBuilder.requestOptions.isValidOverride()) {
                thumbOverrideWidth = requestOptions.getOverrideWidth();
                thumbOverrideHeight = requestOptions.getOverrideHeight();
            }
            ThumbnailRequestCoordinator coordinator = new ThumbnailRequestCoordinator(parentCoordinator);
            Request fullRequest = this.obtainRequest(target, targetListener, requestOptions, coordinator, transitionOptions, priority, overrideWidth, overrideHeight);
            this.isThumbnailBuilt = true;
            Request thumbRequest = super.buildRequestRecursive(target, targetListener, coordinator, thumbTransitionOptions, thumbPriority, thumbOverrideWidth, thumbOverrideHeight, this.thumbnailBuilder.requestOptions);
            this.isThumbnailBuilt = false;
            coordinator.setRequests(fullRequest, thumbRequest);
            return coordinator;
        }
        if (this.thumbSizeMultiplier != null) {
            ThumbnailRequestCoordinator coordinator = new ThumbnailRequestCoordinator(parentCoordinator);
            Request fullRequest = this.obtainRequest(target, targetListener, requestOptions, coordinator, transitionOptions, priority, overrideWidth, overrideHeight);
            RequestOptions thumbnailOptions = requestOptions.clone().sizeMultiplier(this.thumbSizeMultiplier.floatValue());
            Request thumbnailRequest = this.obtainRequest(target, targetListener, thumbnailOptions, coordinator, transitionOptions, this.getThumbnailPriority(priority), overrideWidth, overrideHeight);
            coordinator.setRequests(fullRequest, thumbnailRequest);
            return coordinator;
        }
        return this.obtainRequest(target, targetListener, requestOptions, parentCoordinator, transitionOptions, priority, overrideWidth, overrideHeight);
    }

    private Request obtainRequest(Target<TranscodeType> target, RequestListener<TranscodeType> targetListener, RequestOptions requestOptions, RequestCoordinator requestCoordinator, TransitionOptions<?, ? super TranscodeType> transitionOptions, Priority priority, int overrideWidth, int overrideHeight) {
        return SingleRequest.obtain(this.context, this.glideContext, this.model, this.transcodeClass, requestOptions, overrideWidth, overrideHeight, priority, target, targetListener, this.requestListener, requestCoordinator, this.glideContext.getEngine(), transitionOptions.getTransitionFactory());
    }
}

