/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.facebook.shimmer;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.util.AttributeSet;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.Px;
import io.intercom.com.facebook.shimmer.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class Shimmer {
    private static final int COMPONENT_COUNT = 4;
    final float[] positions = new float[4];
    final int[] colors = new int[4];
    final RectF bounds = new RectF();
    int direction = 0;
    @ColorInt
    int highlightColor = -1;
    @ColorInt
    int baseColor = 0x4CFFFFFF;
    int shape = 0;
    int fixedWidth = 0;
    int fixedHeight = 0;
    float widthRatio = 1.0f;
    float heightRatio = 1.0f;
    float intensity = 0.0f;
    float dropoff = 0.5f;
    float tilt = 20.0f;
    boolean clipToChildren = true;
    boolean autoStart = true;
    boolean alphaShimmer = true;
    int repeatCount = -1;
    int repeatMode = 1;
    long animationDuration = 1000L;
    long repeatDelay;

    Shimmer() {
    }

    int width(int width) {
        return this.fixedWidth > 0 ? this.fixedWidth : Math.round(this.widthRatio * (float)width);
    }

    int height(int height) {
        return this.fixedHeight > 0 ? this.fixedHeight : Math.round(this.heightRatio * (float)height);
    }

    void updateColors() {
        switch (this.shape) {
            default: {
                this.colors[0] = this.baseColor;
                this.colors[1] = this.highlightColor;
                this.colors[2] = this.highlightColor;
                this.colors[3] = this.baseColor;
                break;
            }
            case 1: {
                this.colors[0] = this.highlightColor;
                this.colors[1] = this.highlightColor;
                this.colors[2] = this.baseColor;
                this.colors[3] = this.baseColor;
            }
        }
    }

    void updatePositions() {
        switch (this.shape) {
            default: {
                this.positions[0] = Math.max((1.0f - this.intensity - this.dropoff) / 2.0f, 0.0f);
                this.positions[1] = Math.max((1.0f - this.intensity - 0.001f) / 2.0f, 0.0f);
                this.positions[2] = Math.min((1.0f + this.intensity + 0.001f) / 2.0f, 1.0f);
                this.positions[3] = Math.min((1.0f + this.intensity + this.dropoff) / 2.0f, 1.0f);
                break;
            }
            case 1: {
                this.positions[0] = 0.0f;
                this.positions[1] = Math.min(this.intensity, 1.0f);
                this.positions[2] = Math.min(this.intensity + this.dropoff, 1.0f);
                this.positions[3] = 1.0f;
            }
        }
    }

    void updateBounds(int viewWidth, int viewHeight) {
        int magnitude = Math.max(viewWidth, viewHeight);
        double rad = 1.5707963267948966 - Math.toRadians(this.tilt % 90.0f);
        double hyp = (double)magnitude / Math.sin(rad);
        int padding = 3 * Math.round((float)(hyp - (double)magnitude) / 2.0f);
        this.bounds.set((float)(-padding), (float)(-padding), (float)(this.width(viewWidth) + padding), (float)(this.height(viewHeight) + padding));
    }

    public static class ColorHighlightBuilder
    extends Builder<ColorHighlightBuilder> {
        public ColorHighlightBuilder() {
            this.mShimmer.alphaShimmer = false;
        }

        public ColorHighlightBuilder setHighlightColor(@ColorInt int color) {
            this.mShimmer.highlightColor = color;
            return this.getThis();
        }

        public ColorHighlightBuilder setBaseColor(@ColorInt int color) {
            this.mShimmer.baseColor = this.mShimmer.baseColor & 0xFF000000 | color & 0xFFFFFF;
            return this.getThis();
        }

        @Override
        ColorHighlightBuilder consumeAttributes(TypedArray a) {
            super.consumeAttributes(a);
            if (a.hasValue(R.styleable.ShimmerFrameLayout_shimmer_base_color)) {
                this.setBaseColor(a.getColor(R.styleable.ShimmerFrameLayout_shimmer_base_color, this.mShimmer.baseColor));
            }
            if (a.hasValue(R.styleable.ShimmerFrameLayout_shimmer_highlight_color)) {
                this.setHighlightColor(a.getColor(R.styleable.ShimmerFrameLayout_shimmer_highlight_color, this.mShimmer.highlightColor));
            }
            return this.getThis();
        }

        @Override
        protected ColorHighlightBuilder getThis() {
            return this;
        }
    }

    public static class AlphaHighlightBuilder
    extends Builder<AlphaHighlightBuilder> {
        public AlphaHighlightBuilder() {
            this.mShimmer.alphaShimmer = true;
        }

        @Override
        protected AlphaHighlightBuilder getThis() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        final Shimmer mShimmer = new Shimmer();

        protected abstract T getThis();

        public T consumeAttributes(Context context, AttributeSet attrs) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ShimmerFrameLayout, 0, 0);
            return this.consumeAttributes(a);
        }

        T consumeAttributes(TypedArray a) {
            if (a.hasValue(R.styleable.ShimmerFrameLayout_shimmer_clip_to_children)) {
                this.setClipToChildren(a.getBoolean(R.styleable.ShimmerFrameLayout_shimmer_clip_to_children, this.mShimmer.clipToChildren));
            }
            if (a.hasValue(R.styleable.ShimmerFrameLayout_shimmer_auto_start)) {
                this.setAutoStart(a.getBoolean(R.styleable.ShimmerFrameLayout_shimmer_auto_start, this.mShimmer.autoStart));
            }
            if (a.hasValue(R.styleable.ShimmerFrameLayout_shimmer_base_alpha)) {
                this.setBaseAlpha(a.getFloat(R.styleable.ShimmerFrameLayout_shimmer_base_alpha, 0.3f));
            }
            if (a.hasValue(R.styleable.ShimmerFrameLayout_shimmer_highlight_alpha)) {
                this.setHighlightAlpha(a.getFloat(R.styleable.ShimmerFrameLayout_shimmer_highlight_alpha, 1.0f));
            }
            if (a.hasValue(R.styleable.ShimmerFrameLayout_shimmer_duration)) {
                this.setDuration(a.getInt(R.styleable.ShimmerFrameLayout_shimmer_duration, (int)this.mShimmer.animationDuration));
            }
            if (a.hasValue(R.styleable.ShimmerFrameLayout_shimmer_repeat_count)) {
                this.setRepeatCount(a.getInt(R.styleable.ShimmerFrameLayout_shimmer_repeat_count, this.mShimmer.repeatCount));
            }
            if (a.hasValue(R.styleable.ShimmerFrameLayout_shimmer_repeat_delay)) {
                this.setRepeatDelay(a.getInt(R.styleable.ShimmerFrameLayout_shimmer_repeat_delay, (int)this.mShimmer.repeatDelay));
            }
            if (a.hasValue(R.styleable.ShimmerFrameLayout_shimmer_repeat_mode)) {
                this.setRepeatMode(a.getInt(R.styleable.ShimmerFrameLayout_shimmer_repeat_mode, this.mShimmer.repeatMode));
            }
            if (a.hasValue(R.styleable.ShimmerFrameLayout_shimmer_direction)) {
                int direction = a.getInt(R.styleable.ShimmerFrameLayout_shimmer_direction, this.mShimmer.direction);
                switch (direction) {
                    default: {
                        this.setDirection(0);
                        break;
                    }
                    case 1: {
                        this.setDirection(1);
                        break;
                    }
                    case 2: {
                        this.setDirection(2);
                        break;
                    }
                    case 3: {
                        this.setDirection(3);
                    }
                }
            }
            if (a.hasValue(R.styleable.ShimmerFrameLayout_shimmer_shape)) {
                int shape = a.getInt(R.styleable.ShimmerFrameLayout_shimmer_shape, this.mShimmer.shape);
                switch (shape) {
                    default: {
                        this.setShape(0);
                        break;
                    }
                    case 1: {
                        this.setShape(1);
                    }
                }
            }
            if (a.hasValue(R.styleable.ShimmerFrameLayout_shimmer_dropoff)) {
                this.setDropoff(a.getFloat(R.styleable.ShimmerFrameLayout_shimmer_dropoff, this.mShimmer.dropoff));
            }
            if (a.hasValue(R.styleable.ShimmerFrameLayout_shimmer_fixed_width)) {
                this.setFixedWidth(a.getDimensionPixelSize(R.styleable.ShimmerFrameLayout_shimmer_fixed_width, this.mShimmer.fixedWidth));
            }
            if (a.hasValue(R.styleable.ShimmerFrameLayout_shimmer_fixed_height)) {
                this.setFixedHeight(a.getDimensionPixelSize(R.styleable.ShimmerFrameLayout_shimmer_fixed_height, this.mShimmer.fixedHeight));
            }
            if (a.hasValue(R.styleable.ShimmerFrameLayout_shimmer_intensity)) {
                this.setIntensity(a.getFloat(R.styleable.ShimmerFrameLayout_shimmer_intensity, this.mShimmer.intensity));
            }
            if (a.hasValue(R.styleable.ShimmerFrameLayout_shimmer_width_ratio)) {
                this.setWidthRatio(a.getFloat(R.styleable.ShimmerFrameLayout_shimmer_width_ratio, this.mShimmer.widthRatio));
            }
            if (a.hasValue(R.styleable.ShimmerFrameLayout_shimmer_height_ratio)) {
                this.setHeightRatio(a.getFloat(R.styleable.ShimmerFrameLayout_shimmer_height_ratio, this.mShimmer.heightRatio));
            }
            if (a.hasValue(R.styleable.ShimmerFrameLayout_shimmer_tilt)) {
                this.setTilt(a.getFloat(R.styleable.ShimmerFrameLayout_shimmer_tilt, this.mShimmer.tilt));
            }
            return this.getThis();
        }

        public T copyFrom(Shimmer other) {
            this.setDirection(other.direction);
            this.setShape(other.shape);
            this.setFixedWidth(other.fixedWidth);
            this.setFixedHeight(other.fixedHeight);
            this.setWidthRatio(other.widthRatio);
            this.setHeightRatio(other.heightRatio);
            this.setIntensity(other.intensity);
            this.setDropoff(other.dropoff);
            this.setTilt(other.tilt);
            this.setClipToChildren(other.clipToChildren);
            this.setAutoStart(other.autoStart);
            this.setRepeatCount(other.repeatCount);
            this.setRepeatMode(other.repeatMode);
            this.setRepeatDelay(other.repeatDelay);
            this.setDuration(other.animationDuration);
            this.mShimmer.baseColor = other.baseColor;
            this.mShimmer.highlightColor = other.highlightColor;
            return this.getThis();
        }

        public T setDirection(int direction) {
            this.mShimmer.direction = direction;
            return this.getThis();
        }

        public T setShape(int shape) {
            this.mShimmer.shape = shape;
            return this.getThis();
        }

        public T setFixedWidth(@Px int fixedWidth) {
            if (fixedWidth < 0) {
                throw new IllegalArgumentException("Given invalid width: " + fixedWidth);
            }
            this.mShimmer.fixedWidth = fixedWidth;
            return this.getThis();
        }

        public T setFixedHeight(@Px int fixedHeight) {
            if (fixedHeight < 0) {
                throw new IllegalArgumentException("Given invalid height: " + fixedHeight);
            }
            this.mShimmer.fixedHeight = fixedHeight;
            return this.getThis();
        }

        public T setWidthRatio(float widthRatio) {
            if (widthRatio < 0.0f) {
                throw new IllegalArgumentException("Given invalid width ratio: " + widthRatio);
            }
            this.mShimmer.widthRatio = widthRatio;
            return this.getThis();
        }

        public T setHeightRatio(float heightRatio) {
            if (heightRatio < 0.0f) {
                throw new IllegalArgumentException("Given invalid height ratio: " + heightRatio);
            }
            this.mShimmer.heightRatio = heightRatio;
            return this.getThis();
        }

        public T setIntensity(float intensity) {
            if (intensity < 0.0f) {
                throw new IllegalArgumentException("Given invalid intensity value: " + intensity);
            }
            this.mShimmer.intensity = intensity;
            return this.getThis();
        }

        public T setDropoff(float dropoff) {
            if (dropoff < 0.0f) {
                throw new IllegalArgumentException("Given invalid dropoff value: " + dropoff);
            }
            this.mShimmer.dropoff = dropoff;
            return this.getThis();
        }

        public T setTilt(float tilt) {
            this.mShimmer.tilt = tilt;
            return this.getThis();
        }

        public T setBaseAlpha(@FloatRange(from=0.0, to=1.0) float alpha) {
            int intAlpha = (int)(Builder.clamp(0.0f, 1.0f, alpha) * 255.0f);
            this.mShimmer.baseColor = intAlpha << 24 | this.mShimmer.baseColor & 0xFFFFFF;
            return this.getThis();
        }

        public T setHighlightAlpha(@FloatRange(from=0.0, to=1.0) float alpha) {
            int intAlpha = (int)(Builder.clamp(0.0f, 1.0f, alpha) * 255.0f);
            this.mShimmer.highlightColor = intAlpha << 24 | this.mShimmer.highlightColor & 0xFFFFFF;
            return this.getThis();
        }

        public T setClipToChildren(boolean status) {
            this.mShimmer.clipToChildren = status;
            return this.getThis();
        }

        public T setAutoStart(boolean status) {
            this.mShimmer.autoStart = status;
            return this.getThis();
        }

        public T setRepeatCount(int repeatCount) {
            this.mShimmer.repeatCount = repeatCount;
            return this.getThis();
        }

        public T setRepeatMode(int mode) {
            this.mShimmer.repeatMode = mode;
            return this.getThis();
        }

        public T setRepeatDelay(long millis) {
            if (millis < 0L) {
                throw new IllegalArgumentException("Given a negative repeat delay: " + millis);
            }
            this.mShimmer.repeatDelay = millis;
            return this.getThis();
        }

        public T setDuration(long millis) {
            if (millis < 0L) {
                throw new IllegalArgumentException("Given a negative duration: " + millis);
            }
            this.mShimmer.animationDuration = millis;
            return this.getThis();
        }

        public Shimmer build() {
            this.mShimmer.updateColors();
            this.mShimmer.updatePositions();
            return this.mShimmer;
        }

        private static float clamp(float min, float max, float value) {
            return Math.min(max, Math.max(min, value));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Direction {
        public static final int LEFT_TO_RIGHT = 0;
        public static final int TOP_TO_BOTTOM = 1;
        public static final int RIGHT_TO_LEFT = 2;
        public static final int BOTTOM_TO_TOP = 3;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Shape {
        public static final int LINEAR = 0;
        public static final int RADIAL = 1;
    }
}

