/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.engine;

import android.support.v4.util.Pools;
import io.intercom.com.bumptech.glide.load.engine.Resource;
import io.intercom.com.bumptech.glide.util.Preconditions;
import io.intercom.com.bumptech.glide.util.pool.FactoryPools;
import io.intercom.com.bumptech.glide.util.pool.StateVerifier;

final class LockedResource<Z>
implements Resource<Z>,
FactoryPools.Poolable {
    private static final Pools.Pool<LockedResource<?>> POOL = FactoryPools.threadSafe(20, new FactoryPools.Factory<LockedResource<?>>(){

        @Override
        public LockedResource<?> create() {
            return new LockedResource();
        }
    });
    private final StateVerifier stateVerifier = StateVerifier.newInstance();
    private Resource<Z> toWrap;
    private boolean isLocked;
    private boolean isRecycled;

    static <Z> LockedResource<Z> obtain(Resource<Z> resource) {
        LockedResource result = Preconditions.checkNotNull((LockedResource)POOL.acquire());
        result.init(resource);
        return result;
    }

    LockedResource() {
    }

    private void init(Resource<Z> toWrap) {
        this.isRecycled = false;
        this.isLocked = true;
        this.toWrap = toWrap;
    }

    private void release() {
        this.toWrap = null;
        POOL.release((Object)this);
    }

    synchronized void unlock() {
        this.stateVerifier.throwIfRecycled();
        if (!this.isLocked) {
            throw new IllegalStateException("Already unlocked");
        }
        this.isLocked = false;
        if (this.isRecycled) {
            this.recycle();
        }
    }

    @Override
    public Class<Z> getResourceClass() {
        return this.toWrap.getResourceClass();
    }

    @Override
    public Z get() {
        return this.toWrap.get();
    }

    @Override
    public int getSize() {
        return this.toWrap.getSize();
    }

    @Override
    public synchronized void recycle() {
        this.stateVerifier.throwIfRecycled();
        this.isRecycled = true;
        if (!this.isLocked) {
            this.toWrap.recycle();
            this.release();
        }
    }

    @Override
    public StateVerifier getVerifier() {
        return this.stateVerifier;
    }
}

