/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation.composer.galleryinput;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.intercom.composer.ImageLoader;
import com.intercom.input.gallery.GalleryImage;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.com.bumptech.glide.RequestBuilder;
import io.intercom.com.bumptech.glide.RequestManager;
import io.intercom.com.bumptech.glide.TransitionOptions;
import io.intercom.com.bumptech.glide.load.DataSource;
import io.intercom.com.bumptech.glide.load.DecodeFormat;
import io.intercom.com.bumptech.glide.load.Transformation;
import io.intercom.com.bumptech.glide.load.engine.DiskCacheStrategy;
import io.intercom.com.bumptech.glide.load.engine.GlideException;
import io.intercom.com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import io.intercom.com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import io.intercom.com.bumptech.glide.request.RequestListener;
import io.intercom.com.bumptech.glide.request.RequestOptions;
import io.intercom.com.bumptech.glide.request.target.Target;

class GalleryImageLoader
implements ImageLoader {
    private static final float GIF_SIZE_MULTIPLIER = 0.5f;
    private final DiskCacheStrategy diskCacheStrategy;
    @Nullable
    private final BitmapTransformation transformation;
    private final RequestManager requestManager;

    static GalleryImageLoader create(DiskCacheStrategy diskCacheStrategy, @Nullable BitmapTransformation transformation, RequestManager requestManager) {
        return new GalleryImageLoader(diskCacheStrategy, transformation, requestManager);
    }

    GalleryImageLoader(DiskCacheStrategy diskCacheStrategy, @Nullable BitmapTransformation transformation, RequestManager requestManager) {
        this.diskCacheStrategy = diskCacheStrategy;
        this.transformation = transformation;
        this.requestManager = requestManager;
    }

    public void loadImageIntoView(GalleryImage image, ImageView view) {
        String previewPath = image.getPreviewPath();
        final Uri imageUri = TextUtils.isEmpty((CharSequence)previewPath) ? image.getUri() : Uri.parse((String)previewPath);
        Context context = view.getContext();
        RequestOptions options = new RequestOptions().diskCacheStrategy(this.diskCacheStrategy).placeholder((Drawable)new ColorDrawable(ContextCompat.getColor((Context)context, (int)R.color.intercom_search_bg_grey)));
        if (this.transformation != null) {
            options = options.transform((Transformation)this.transformation);
        }
        RequestBuilder request = this.requestManager.load(imageUri);
        if (image.isGif()) {
            options = options.sizeMultiplier(0.5f).format(DecodeFormat.PREFER_RGB_565);
        }
        request.apply(options).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).listener((RequestListener)new RequestListener<Drawable>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                GalleryImageLoader.this.logErrorMessageForUrl((Exception)e, imageUri.toString());
                return false;
            }

            public boolean onResourceReady(Drawable drawable2, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                return false;
            }
        }).into(view);
    }

    private void logErrorMessageForUrl(Exception e, String url) {
        Twig twig = LumberMill.getLogger();
        String messageStart = "Failed to load image for URL: " + url + " - ";
        if (e == null) {
            twig.e(messageStart + "no error message, data probably failed to decode", new Object[0]);
        } else {
            twig.e(messageStart + e.getMessage(), new Object[0]);
        }
    }

    public void clear(ImageView imageView) {
        this.requestManager.clear((View)imageView);
    }

    @Nullable
    public Bitmap getBitmapFromView(ImageView imageView) {
        Drawable drawable2 = imageView.getDrawable();
        if (drawable2 instanceof TransitionDrawable) {
            TransitionDrawable transitionDrawable = (TransitionDrawable)drawable2;
            for (int i = transitionDrawable.getNumberOfLayers() - 1; i >= 0; --i) {
                Bitmap realBitmap = this.getBitmapFromDrawable(transitionDrawable.getDrawable(i));
                if (realBitmap == null) continue;
                return realBitmap;
            }
            return null;
        }
        return this.getBitmapFromDrawable(drawable2);
    }

    @Nullable
    private Bitmap getBitmapFromDrawable(Drawable drawable2) {
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        return null;
    }
}

