/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.lib;

import android.view.View;
import android.view.ViewGroup;
import io.intercom.android.sdk.blocks.lib.BlockTypeNotImplementedException;
import io.intercom.android.sdk.blocks.lib.BlocksViewHolder;
import io.intercom.android.sdk.blocks.lib.VideoProvider;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.blocks.lib.models.ConversationRating;
import io.intercom.android.sdk.blocks.lib.models.Link;
import io.intercom.android.sdk.blocks.lib.models.LinkList;
import io.intercom.android.sdk.commons.utilities.HtmlCompat;
import java.util.Locale;

public enum BlockType {
    PARAGRAPH("paragraph"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getParagraph().addParagraph(HtmlCompat.fromHtml((String)block.getText()), block.getAlign(), isFirstObject, isLastObject, layout2);
        }
    }
    ,
    HEADING("heading"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getHeading().addHeading(HtmlCompat.fromHtml((String)block.getText()), block.getAlign(), isFirstObject, isLastObject, layout2);
        }
    }
    ,
    SUBHEADING("subheading"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getSubheading().addSubheading(HtmlCompat.fromHtml((String)block.getText()), block.getAlign(), isFirstObject, isLastObject, layout2);
        }
    }
    ,
    CODE("code"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getCode().addCode(HtmlCompat.fromHtml((String)block.getText()), isFirstObject, isLastObject, layout2);
        }
    }
    ,
    LINK("link"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getLink().addLinkBlock(Link.fromBlock(block), isFirstObject, isLastObject, layout2);
        }
    }
    ,
    CONVERSATIONRATING("conversationRating"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getConversationRating().addConversationRatingBlock(ConversationRating.fromBlock(block), isFirstObject, isLastObject, layout2);
        }
    }
    ,
    LINKLIST("linkList"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getLinkList().addLinkListBlock(LinkList.fromBlock(block), isFirstObject, isLastObject, layout2);
        }
    }
    ,
    UNORDEREDLIST("unorderedList"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getUnorderedList().addUnorderedList(block.getItems(), isFirstObject, isLastObject, layout2);
        }
    }
    ,
    ORDEREDLIST("orderedList"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getOrderedList().addOrderedList(block.getItems(), isFirstObject, isLastObject, layout2);
        }
    }
    ,
    ATTACHMENTLIST("attachmentList"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getAttachmentList().addAttachmentList(block.getAttachments(), isFirstObject, isLastObject, layout2);
        }
    }
    ,
    IMAGE("image"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getImage().addImage(block.getUrl(), 11.getLinkUrl(block), block.getWidth(), block.getHeight(), block.getAlign(), isFirstObject, isLastObject, layout2);
        }
    }
    ,
    BUTTON("button"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getButton().addButton(block.getText(), 12.getLinkUrl(block), block.getAlign(), isFirstObject, isLastObject, layout2);
        }
    }
    ,
    FACEBOOKLIKEBUTTON("facebookLikeButton"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getFacebookButton().addFacebookButton(block.getUrl(), block.getAlign(), isFirstObject, isLastObject, layout2);
        }
    }
    ,
    TWITTERFOLLOWBUTTON("twitterFollowButton"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getTwitterButton().addTwitterButton("https://twitter.com/" + block.getUsername(), block.getAlign(), isFirstObject, isLastObject, layout2);
        }
    }
    ,
    VIDEO("video"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getVideo().addVideo(block.getText(), VideoProvider.videoValueOf(block.getProvider()), block.getId(), isFirstObject, isLastObject, layout2);
        }
    }
    ,
    VIDEOFILE("videoFile"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getVideoFile().addVideoFile(block.getText(), block.getUrl(), block.getThumbnailUrl(), isFirstObject, isLastObject, layout2);
        }
    }
    ,
    MESSENGERCARD("messengerCard"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getMessengerCardBlock().addCard(block.getText(), block.getFallbackUrl(), isFirstObject, isLastObject, layout2);
        }
    }
    ,
    LOCALIMAGE("localImage"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getLocalImage().addImage(block.getUri(), block.getWidth(), block.getHeight(), block.getAlign(), isFirstObject, isLastObject, layout2);
        }
    }
    ,
    LOCAL_ATTACHMENT("local_attachment"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getLocalAttachment().addAttachment(block.getAttachments().get(0), isFirstObject, isLastObject, layout2);
        }
    }
    ,
    UNKNOWN("unknown"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, boolean isFirstObject, boolean isLastObject) {
            if (!block.getText().isEmpty() && viewHolder.getParagraph() != null) {
                return PARAGRAPH.generateViewFromBlockAndLayout(viewHolder, block, layout2, isFirstObject, isLastObject);
            }
            throw new BlockTypeNotImplementedException();
        }
    };

    private final String serializedName;

    private BlockType(String serializedName) {
        this.serializedName = serializedName;
    }

    abstract View generateViewFromBlockAndLayout(BlocksViewHolder var1, Block var2, ViewGroup var3, boolean var4, boolean var5);

    public String getSerializedName() {
        return this.serializedName;
    }

    public View getView(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, boolean isFirstObject, boolean isLastObject) throws BlockTypeNotImplementedException {
        try {
            return this.generateViewFromBlockAndLayout(viewHolder, block, layout2, isFirstObject, isLastObject);
        }
        catch (NullPointerException exception) {
            try {
                return UNKNOWN.generateViewFromBlockAndLayout(viewHolder, block, layout2, isFirstObject, isLastObject);
            }
            catch (BlockTypeNotImplementedException | NullPointerException e) {
                throw new BlockTypeNotImplementedException();
            }
        }
    }

    protected static String getLinkUrl(Block block) {
        return block.getTrackingUrl().isEmpty() ? block.getLinkUrl() : block.getTrackingUrl();
    }

    public static BlockType typeValueOf(String type) {
        BlockType blockType = UNKNOWN;
        try {
            blockType = BlockType.valueOf(type.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return blockType;
    }
}

