/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.engine;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import io.intercom.com.bumptech.glide.load.DataSource;
import io.intercom.com.bumptech.glide.load.Key;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class GlideException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final StackTraceElement[] EMPTY_ELEMENTS = new StackTraceElement[0];
    private final List<Throwable> causes;
    private Key key;
    private DataSource dataSource;
    private Class<?> dataClass;

    public GlideException(String message) {
        this(message, Collections.emptyList());
    }

    public GlideException(String detailMessage, Throwable cause) {
        this(detailMessage, Collections.singletonList(cause));
    }

    public GlideException(String detailMessage, List<Throwable> causes) {
        super(detailMessage);
        this.setStackTrace(EMPTY_ELEMENTS);
        this.causes = causes;
    }

    void setLoggingDetails(Key key, DataSource dataSource) {
        this.setLoggingDetails(key, dataSource, null);
    }

    void setLoggingDetails(Key key, DataSource dataSource, Class<?> dataClass) {
        this.key = key;
        this.dataSource = dataSource;
        this.dataClass = dataClass;
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    public List<Throwable> getCauses() {
        return this.causes;
    }

    public List<Throwable> getRootCauses() {
        ArrayList<Throwable> rootCauses = new ArrayList<Throwable>();
        this.addRootCauses(this, rootCauses);
        return rootCauses;
    }

    public void logRootCauses(String tag) {
        List<Throwable> causes = this.getRootCauses();
        int size = causes.size();
        for (int i = 0; i < size; ++i) {
            Log.i((String)tag, (String)("Root cause (" + (i + 1) + " of " + size + ")"), (Throwable)causes.get(i));
        }
    }

    private void addRootCauses(Throwable throwable, List<Throwable> rootCauses) {
        if (throwable instanceof GlideException) {
            GlideException glideException = (GlideException)throwable;
            for (Throwable t : glideException.getCauses()) {
                this.addRootCauses(t, rootCauses);
            }
        } else {
            rootCauses.add(throwable);
        }
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream err) {
        this.printStackTrace((Appendable)err);
    }

    @Override
    public void printStackTrace(PrintWriter err) {
        this.printStackTrace((Appendable)err);
    }

    private void printStackTrace(Appendable appendable) {
        GlideException.appendExceptionMessage(this, appendable);
        GlideException.appendCauses(this.getCauses(), new IndentedAppendable(appendable));
    }

    @Override
    public String getMessage() {
        return super.getMessage() + (this.dataClass != null ? ", " + this.dataClass : "") + (this.dataSource != null ? ", " + (Object)((Object)this.dataSource) : "") + (this.key != null ? ", " + this.key : "");
    }

    private static void appendExceptionMessage(Throwable t, Appendable appendable) {
        try {
            appendable.append(t.getClass().toString()).append(": ").append(t.getMessage()).append('\n');
        }
        catch (IOException e1) {
            throw new RuntimeException(t);
        }
    }

    private static void appendCauses(List<Throwable> causes, Appendable appendable) {
        try {
            GlideException.appendCausesWrapped(causes, appendable);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void appendCausesWrapped(List<Throwable> causes, Appendable appendable) throws IOException {
        int size = causes.size();
        for (int i = 0; i < size; ++i) {
            appendable.append("Cause (").append(String.valueOf(i + 1)).append(" of ").append(String.valueOf(size)).append("): ");
            Throwable cause = causes.get(i);
            if (cause instanceof GlideException) {
                GlideException glideCause = (GlideException)cause;
                glideCause.printStackTrace(appendable);
                continue;
            }
            GlideException.appendExceptionMessage(cause, appendable);
        }
    }

    private static final class IndentedAppendable
    implements Appendable {
        private static final String EMPTY_SEQUENCE = "";
        private static final String INDENT = "  ";
        private final Appendable appendable;
        private boolean printedNewLine = true;

        IndentedAppendable(Appendable appendable) {
            this.appendable = appendable;
        }

        @Override
        public Appendable append(char c) throws IOException {
            if (this.printedNewLine) {
                this.printedNewLine = false;
                this.appendable.append(INDENT);
            }
            this.printedNewLine = c == '\n';
            this.appendable.append(c);
            return this;
        }

        @Override
        public Appendable append(@Nullable CharSequence charSequence) throws IOException {
            charSequence = this.safeSequence(charSequence);
            return this.append(charSequence, 0, charSequence.length());
        }

        @Override
        public Appendable append(@Nullable CharSequence charSequence, int start, int end) throws IOException {
            charSequence = this.safeSequence(charSequence);
            if (this.printedNewLine) {
                this.printedNewLine = false;
                this.appendable.append(INDENT);
            }
            this.printedNewLine = charSequence.length() > 0 && charSequence.charAt(end - 1) == '\n';
            this.appendable.append(charSequence, start, end);
            return this;
        }

        @NonNull
        private CharSequence safeSequence(@Nullable CharSequence sequence) {
            if (sequence == null) {
                return EMPTY_SEQUENCE;
            }
            return sequence;
        }
    }
}

