/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.v4.app.ActivityOptionsCompat;
import android.text.TextUtils;
import android.view.View;
import android.view.WindowManager;
import android.widget.ImageView;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.ImageClickListener;
import io.intercom.android.sdk.lightbox.LightBoxActivity;
import io.intercom.android.sdk.utilities.LinkOpener;

public class LightboxOpeningImageClickListener
implements ImageClickListener {
    private final Api api;

    public LightboxOpeningImageClickListener(Api api) {
        this.api = api;
    }

    @Override
    public void onImageClicked(String imageUrl, String linkUrl, ImageView imageView, int width, int height) {
        Context context = imageView.getContext();
        if (!TextUtils.isEmpty((CharSequence)linkUrl)) {
            LinkOpener.handleUrl(linkUrl, context, this.api);
            return;
        }
        if (context instanceof Activity) {
            Activity rootActivity = (Activity)context;
            WindowManager.LayoutParams windowAttributes = rootActivity.getWindow().getAttributes();
            boolean fullScreen = (windowAttributes.flags & 0x400) != 0;
            Intent intent = LightBoxActivity.imageIntent((Context)rootActivity, imageUrl, fullScreen);
            if (Build.VERSION.SDK_INT >= 16) {
                ActivityOptionsCompat options = ActivityOptionsCompat.makeSceneTransitionAnimation((Activity)rootActivity, (View)imageView, (String)"lightbox_image");
                rootActivity.startActivity(intent, options.toBundle());
            } else {
                rootActivity.startActivity(intent);
            }
        } else {
            context.startActivity(LightBoxActivity.imageIntent(context, imageUrl, false));
        }
    }
}

